#!/usr/bin/env python
#
# Written by Bram Cohen
# Modified by Cameron Dale
# see LICENSE.txt for license information
#
# $Id: debtorrent-tracker.py 270 2007-08-19 07:33:13Z camrdale-guest $

"""Start a debtorrent download tracker."""

from DebTorrent import PSYCO
if PSYCO.psyco:
    try:
        import psyco
        assert psyco.__version__ >= 0x010100f0
        psyco.full()
    except:
        pass

PROFILE = 0
    
from sys import argv, version_info
from DebTorrent.BT1.track import track

assert version_info >= (2,3), 'Requires Python 2.3 or better'

if __name__ == '__main__':
    if PROFILE:
        import profile, pstats
        p = profile.Profile()
        p.runcall(track, argv[1:])
        p.dump_stats('debtorrent-tracker.pstat')
#        pstats.Stats(p).strip_dirs().sort_stats('cumulative').print_stats()
        pstats.Stats(p).strip_dirs().sort_stats('time').print_stats()
    else:
        # Run the tracker in a loop, exiting when it says it shouldn't be restarted
        while track(argv[1:]):
            pass
