/* prefdialog.c
 * functions for a preferences dialog
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001 Matthew Hiller, Adam Tee */

#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "datastructures.h"
#include "prefops.h"
#include "utils.h"

struct callbackdata
{
  struct prefinfo *prefs;
  GtkWidget *lilypathentry;
  GtkWidget *midiplayerentry;
  GtkWidget *checkimmediateplayback;
  GtkWidget *checklilystyle;
  GtkWidget *checkclone;
  GtkWidget *checkplayback;
};

static void
set_preferences (GtkWidget * widget, gpointer data)
{
  struct callbackdata *cbdata = data;
  struct prefinfo *prefs = cbdata->prefs;
  static GString *localrc = NULL;
  FILE *fp;

  g_string_assign (prefs->lilypath,
		   gtk_entry_get_text (GTK_ENTRY (cbdata->lilypathentry)));
  g_string_assign (prefs->midiplayer,
		   gtk_entry_get_text (GTK_ENTRY (cbdata->midiplayerentry)));
  prefs->immediateplayback =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
				  (cbdata->checkimmediateplayback));
  prefs->lilyentrystyle =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cbdata->checklilystyle));
  prefs->createclones =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cbdata->checkclone));

  prefs->playbackoutput =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cbdata->checkplayback));
  /* Now write it all to denemorc */
  if (!localrc)
    {
      localrc = g_string_new (locatedotdenemo ());
      g_string_append (localrc, "/denemorc");
    }
  if (fp = fopen (localrc->str, "w"))
    {
      fprintf (fp, "lilypath = %s\n", prefs->lilypath->str);
      fprintf (fp, "midiplayer = %s\n", prefs->midiplayer->str);
      fprintf (fp, "immediateplayback = %s\n",
	       prefs->immediateplayback ? "true" : "false");
      fprintf (fp, "lilyentrystyle = %s\n",
	       prefs->lilyentrystyle ? "true" : "false");
      fprintf (fp, "createclones = %s\n",
	       prefs->createclones ? "true" : "false");
      fprintf (fp, "playbackoutput = %s\n",
	       prefs->playbackoutput ? "true" : "false");
      fclose (fp);
    }
  else
    g_warning (_("set_preferences : error opening %s : %s"), localrc->str,
	       g_strerror (errno));
}

void
preferences_change (gpointer callback_data, guint callback_action,
		    GtkWidget * widget)
{
  struct scoreinfo *si = callback_data;
  GtkWidget *dialog;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *lilypathentry;
  GtkWidget *midiplayerentry;
  GtkWidget *checkimmediateplayback;
  GtkWidget *checklilystyle;
  GtkWidget *checkclone;
  GtkWidget *checkplayback;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  static struct callbackdata cbdata;

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Set preferences"));

  table = gtk_table_new (6, 2, TRUE);

  label = gtk_label_new (_("Path to Lilypond"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  gtk_widget_show (label);
  lilypathentry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (lilypathentry), si->prefs->lilypath->str);
  gtk_table_attach_defaults (GTK_TABLE (table), lilypathentry, 1, 2, 0, 1);
  gtk_widget_show (lilypathentry);

  label = gtk_label_new (_("External midi player"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  gtk_widget_show (label);
  midiplayerentry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (midiplayerentry),
		      si->prefs->midiplayer->str);
  gtk_table_attach_defaults (GTK_TABLE (table), midiplayerentry, 1, 2, 1, 2);
  gtk_widget_show (midiplayerentry);

  label = gtk_label_new (_("Play back entered notes immediately?"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
  gtk_widget_show (label);
  checkimmediateplayback = gtk_check_button_new ();
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkimmediateplayback),
				si->prefs->immediateplayback);
  gtk_table_attach_defaults (GTK_TABLE (table), checkimmediateplayback,
			     1, 2, 2, 3);
  gtk_widget_show (checkimmediateplayback);

  label = gtk_label_new (_("Use lilypond-style note entry?"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 3, 4);
  gtk_widget_set_sensitive (label, FALSE);
  gtk_widget_show (label);
  checklilystyle = gtk_check_button_new ();
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checklilystyle),
				si->prefs->lilyentrystyle);
  gtk_widget_set_sensitive (checklilystyle, FALSE);
  /* Comment that out when the feature is added */
  gtk_table_attach_defaults (GTK_TABLE (table), checklilystyle, 1, 2, 3, 4);
  gtk_widget_show (checklilystyle);

  label = gtk_label_new (_("Clone chords when tying them?"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 4, 5);
  gtk_widget_set_sensitive (label, FALSE);
  gtk_widget_show (label);
  checkclone = gtk_check_button_new ();
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkclone),
				si->prefs->createclones);
  gtk_widget_set_sensitive (checkclone, FALSE);
  /* Comment that out when the feature is added */
  gtk_table_attach_defaults (GTK_TABLE (table), checkclone, 1, 2, 4, 5);
  gtk_widget_show (checkclone);


  label = gtk_label_new (_("Set Playback Output"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 5, 6);
  /*gtk_widget_set_sensitive (label, FALSE); */
  gtk_widget_show (label);
  checkplayback = gtk_check_button_new ();
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkplayback),
				si->prefs->playbackoutput);
  /*gtk_widget_set_sensitive (checkplayback, FALSE); */
  /* Comment that out when the feature is added */
  gtk_table_attach_defaults (GTK_TABLE (table), checkplayback, 1, 2, 5, 6);
  gtk_widget_show (checkplayback);



  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
		      table, TRUE, TRUE, 0);
  gtk_widget_show (table);

  /* Set up the callback data */
  cbdata.prefs = si->prefs;
  cbdata.lilypathentry = lilypathentry;
  cbdata.midiplayerentry = midiplayerentry;
  cbdata.checkimmediateplayback = checkimmediateplayback;
  cbdata.checklilystyle = checklilystyle;
  cbdata.checkclone = checkclone;
  cbdata.checkplayback = checkplayback;

  processenter (lilypathentry, set_preferences, cbdata, dialog);
  processenter (midiplayerentry, set_preferences, cbdata, dialog);

  okbutton = gtk_button_new_with_label (_("OK"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      okbutton, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (set_preferences), &cbdata);
  gtk_signal_connect_object (GTK_OBJECT (okbutton), "clicked",
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), "clicked",
			     gtk_widget_destroy, GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);

  gtk_widget_grab_focus (lilypathentry);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);
}
