# Copyright 2009 Canonical Ltd.
#
# This file is part of desktopcouch.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.


import pygtk
pygtk.require('2.0')

from twisted.internet import gtk2reactor
gtk2reactor.install()
from twisted.internet import reactor, task

from desktopcouch.pair.couchdb_pairing.network_io import (
    start_send_invitation, ListenForInvitations)
from desktopcouch.pair.couchdb_pairing.dbus_io import get_local_hostname

import os
import unittest

local_hostname = ".".join(get_local_hostname())

a_hostid = "hostid a"
a_oauth_data = dict(token="atoken", token_secret="atokensecret",
        consumer="aconsumer", consumer_secret="aconsumersecret")

b_hostid = "hostid b"
b_oauth_data = dict(token="btoken", token_secret="btokensecret",
        consumer="bconsumer", consumer_secret="bconsumersecret")


class TestNetworkIO(unittest.TestCase):

    def setUp(self):
        self._listener_socket_state = "open"
        self._inviter_socket_state = "open"
        self._listener_auth_completed = False
        self._inviter_auth_completed = False

    def test_successful_lifespan(self):

        secret = "sekrit"

        def listener_get_secret_from_user(sender, f, send_secret, hostid,
                oauth_info):
            """Get secret from user.  Try several first."""

            self.assertEquals("hostid b", hostid)
            self.assertTrue("token" in oauth_info)

            self.assertFalse(f("sek"))
            self.assertFalse(f(""))
            self.assertFalse(f("                                  fs"))
            ret = f(secret)
            self.assertTrue(ret)
            if ret:
                send_secret(secret)
                listener_complete_auth()

        def listener_close_socket():
            self._listener_socket_state = "closed"

        def inviter_close_socket():
            self._inviter_socket_state = "closed"

        def inviter_complete_auth(hostname, hostid, oauth_info):
            self.assertEquals("hostid a", hostid)
            self.assertTrue("token" in oauth_info)
            self._inviter_auth_completed = True

        def listener_complete_auth():
            self._listener_auth_completed = True

        self.listener = ListenForInvitations(listener_get_secret_from_user,
                listener_close_socket, a_hostid, a_oauth_data)
        listener_port = self.listener.get_local_port()

        def inviter_display_message(*args):
            """Show message to user."""
            logging.info("display message from inviter: %s", args)

        self.inviter = start_send_invitation(local_hostname, listener_port,
                inviter_complete_auth, secret, "seed", inviter_close_socket,
                b_hostid, b_oauth_data)

        def exit_on_success():
            if self._listener_auth_completed and self._inviter_auth_completed:
                reactor.stop()
        task.LoopingCall(exit_on_success).start(1.0)

        def exit_on_timeout():
            reactor.stop()
        reactor.callLater(30, exit_on_timeout)

        reactor.run()

        self.assertTrue(self._listener_auth_completed)
        self.assertTrue(self._inviter_auth_completed)

        self.assertEqual(self._inviter_socket_state, "open")  # still open at end
        self.assertEqual(self._listener_socket_state, "open")  # still open at end


    def disabled__test_inviter_quits(self):

        secret = "sekrit"

        def listener_get_secret_from_user(sender, f, send_secret):
            """Get secret from user.  Try several first."""
            self.assertFalse(f("sek"))
            # HMM

            self.inviter.close()
            inviter_close_socket()


        def listener_close_socket():
            self._listener_socket_state = "closed"

        def inviter_close_socket():
            self._inviter_socket_state = "closed"

        def inviter_complete_auth(a, b, c):
            self._inviter_auth_completed = True

        def listener_complete_auth():
            self._listener_auth_completed = True


        self.listener = ListenForInvitations(listener_get_secret_from_user,
                listener_close_socket)
        listener_port = self.listener.get_local_port()

        def inviter_display_message(*args):
            """Show message to user."""
            logging.info("display message from inviter: %s", args)

        self.inviter = start_send_invitation(local_hostname, listener_port,
                inviter_complete_auth, secret, "seed", inviter_close_socket)

        # FIXME

        self.assertFalse(self._listener_auth_completed)
        self.assertFalse(self._inviter_auth_completed)

        self.assertEqual(self._inviter_socket_state, "closed")  # still open at end
        self.assertEqual(self._listener_socket_state, "closed")  # still open at end


    def disabled__test_listener_quits(self):

        secret = "sekrit"

        def listener_get_secret_from_user(sender, f, send_secret):
            """Get secret from user.  Try several first."""
            self.assertFalse(f("sek"))
            self.assertFalse(f(""))
            self.assertFalse(f("                                  fs"))
            self.listener.close()
            listener_close_socket()


        def listener_close_socket():
            self._listener_socket_state = "closed"

        def inviter_close_socket():
            self._inviter_socket_state = "closed"

        def inviter_complete_auth(a, b, c):
            self._inviter_auth_completed = True

        def listener_complete_auth():
            self._listener_auth_completed = True


        self.listener = ListenForInvitations(listener_get_secret_from_user,
                listener_close_socket)
        listener_port = self.listener.get_local_port()

        def inviter_display_message(*args):
            """Show message to user."""
            logging.info("display message from inviter: %s", args)

        self.inviter = start_send_invitation(local_hostname, listener_port,
                inviter_complete_auth, secret, "seed", inviter_close_socket)

        # FIXME

        self.assertFalse(self._listener_auth_completed)
        self.assertFalse(self._inviter_auth_completed)

        self.assertEqual(self._listener_socket_state, "closed")
        self.assertEqual(self._inviter_socket_state, "closed")


if __name__ == "__main__":
    unittest.main()
