/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <stdio.h>
#include <unistd.h>

#include "detect.h"
#include "utils.h"


extern int verbose_report;


int main(int argc, char *argv[]){

  setlocale(LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  textdomain(PACKAGE);

  parseCommandLine(argc, argv);
  version();

  if(getuid()){
    fprintf(stderr, "\n%s\n\n", 
                           _("You must be root to run this software."));
    exit(-1);
  }/*endif*/
  fprintf(stdout, "\n%s\n", 
                           _("Detection in progress, please wait ..."));

  if(report_verbose_detect(trim("report.txt"), verbose_report)){
    fprintf(stderr, _("Error in report function\n"));
    exit(-1);
  }/*endif*/
  return 0;
}/*endfunc main*/
