/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "global.h"
#include "rubwindow.h"
#include "color.h"
#include "pixmap.h"
#include "iconmanager.h"
#include <X11/Xlib.h>
#include "includepixmaps/rubberband.xpm"

Window x1y1x2y1,x1y1x1y2,x1y2x2y2,x2y1x2y2;

void InitRubberband()
{
  XSetWindowAttributes xswa;
  unsigned long valuemask;
  Pixmap pixmap;
  static int init=0;

  if (init==0) {
    if (GetIsDesktop()==True) {
    xswa.override_redirect=True;
    xswa.event_mask=ButtonReleaseMask|ButtonPressMask|PointerMotionMask;
    valuemask=CWOverrideRedirect|CWEventMask;
    x1y1x2y1=XCreateWindow(GetDisplay(),XDefaultRootWindow(GetDisplay()),0,0,1,1,
		      0,CopyFromParent,InputOutput,CopyFromParent,valuemask,&xswa);
    x1y1x1y2=XCreateWindow(GetDisplay(),XDefaultRootWindow(GetDisplay()),0,0,1,1,
		      0,CopyFromParent,InputOutput,CopyFromParent,valuemask,&xswa);
    x1y2x2y2=XCreateWindow(GetDisplay(),XDefaultRootWindow(GetDisplay()),0,0,1,1,
		      0,CopyFromParent,InputOutput,CopyFromParent,valuemask,&xswa);
    x2y1x2y2=XCreateWindow(GetDisplay(),XDefaultRootWindow(GetDisplay()),0,0,1,1,
		      0,CopyFromParent,InputOutput,CopyFromParent,valuemask,&xswa);
   } else {
    x1y1x2y1=XCreateSimpleWindow(GetDisplay(),GetMoveWindow(),0,0,1,1,0,0,0);
    x1y1x1y2=XCreateSimpleWindow(GetDisplay(),GetMoveWindow(),0,0,1,1,0,0,0);
    x1y2x2y2=XCreateSimpleWindow(GetDisplay(),GetMoveWindow(),0,0,1,1,0,0,0);
    x2y1x2y2=XCreateSimpleWindow(GetDisplay(),GetMoveWindow(),0,0,1,1,0,0,0);
  }
  DataPixmap(rubberband_xpm,&pixmap,NULL);
  XSetWindowBackgroundPixmap(GetDisplay(),x1y1x2y1,pixmap);
  XSetWindowBackgroundPixmap(GetDisplay(),x1y1x1y2,pixmap);
  XSetWindowBackgroundPixmap(GetDisplay(),x1y2x2y2,pixmap);
  XSetWindowBackgroundPixmap(GetDisplay(),x2y1x2y2,pixmap);
  XFreePixmap(GetDisplay(),pixmap);
  init++;
  }
}


void HideRubberband()
{
  InitRubberband();
  XUnmapWindow(GetDisplay(),x1y1x2y1);
  XUnmapWindow(GetDisplay(),x1y1x1y2);
  XUnmapWindow(GetDisplay(),x2y1x2y2);
  XUnmapWindow(GetDisplay(),x1y2x2y2);
}

void ShowRubberband()
{
  Window last;
  unsigned int changemask;
  XWindowChanges wc;
  
  InitRubberband();
  if (GetIsDesktop()==True) {
    XLowerWindow(GetDisplay(),GetWindow()); 
    last=LowerIcons();
    wc.sibling=last;
    wc.stack_mode=Above;
    changemask=CWStackMode|CWSibling;
    XConfigureWindow(GetDisplay(),x1y1x2y1,changemask,&wc);
    XConfigureWindow(GetDisplay(),x1y1x1y2,changemask,&wc);
    XConfigureWindow(GetDisplay(),x2y1x2y2,changemask,&wc);
    XConfigureWindow(GetDisplay(),x1y2x2y2,changemask,&wc);
  } else {
    XRaiseWindow(GetDisplay(),x1y1x2y1);
    XRaiseWindow(GetDisplay(),x1y1x1y2);
    XRaiseWindow(GetDisplay(),x2y1x2y2);
    XRaiseWindow(GetDisplay(),x1y2x2y2);
  }
  XMapWindow(GetDisplay(),x1y1x2y1);
  XMapWindow(GetDisplay(),x1y1x1y2);
  XMapWindow(GetDisplay(),x2y1x2y2);
  XMapWindow(GetDisplay(),x1y2x2y2);
}

void PlaceRubberband(int x1,int y1,int x2,int y2)
{
  InitRubberband();
  XMoveResizeWindow(GetDisplay(),x1y1x2y1,x1,y1,x2+1,1);
  XMoveResizeWindow(GetDisplay(),x1y1x1y2,x1,y1,1,y2+1);
  XMoveResizeWindow(GetDisplay(),x2y1x2y2,x1+x2,y1,1,y2+1);
  XMoveResizeWindow(GetDisplay(),x1y2x2y2,x1,y1+y2,x2+1,1);
}
