/* dhcdbd.h
 * Dynamic Host Configuration Client manager D-BUS Daemon  
 *
 * Copyright © 2006 Red Hat, Inc.  All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions of
 * the GNU General Public License v.2.  This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY expressed or
 * implied, including the implied warranties of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
 * USA. Any Red Hat trademarks that are incorporated in the source code or
 * documentation are not subject to the GNU General Public License and may
 * only be used or replicated with the express permission of Red Hat, Inc.
 *
 * Red Hat Author(s):  Jason Vas Dias
 *                     David Cantrell
 */

#ifndef DHCDBD_H
#define DHCDBD_H

#ifndef DHCDBD_DESTINATION
#define DHCDBD_DESTINATION "com.redhat.dhcp"
#endif

#ifndef DHCDBD_OBJECT_PATH
#define DHCDBD_OBJECT_PATH "/com/redhat/dhcp"
#endif

#ifndef DHCDBD_INTERFACE_PREFIX
#define DHCDBD_INTERFACE_PREFIX "com.redhat.dhcp"
#endif

#ifndef DHCDBD_DHCLIENT_BIN
#define DHCDBD_DHCLIENT_BIN "/sbin/dhclient"
#endif

#ifndef DHCDBD_DHCLIENT_LEASE_DIR
#define DHCDBD_DHCLIENT_LEASE_DIR "/var/lib/dhclient/"
#endif

#ifndef DHCDBD_DHCLIENT_LEASE_PFX
#define DHCDBD_DHCLIENT_LEASE_PFX "dhclient-"
#endif

#ifndef DHCDBD_DHCLIENT_LEASE_SFX
#define DHCDBD_DHCLIENT_LEASE_SFX ".leases"
#endif

#ifndef DHCDBD_PID_FILE
#define DHCDBD_PID_FILE  "/var/run/dhcdbd.pid"
#endif

#ifndef DHCDBD_DHCLIENT_PID_PFX
#define DHCDBD_DHCLIENT_PID_PFX "/var/run/dhclient-"
#endif

#ifndef DHCDBD_DHCLIENT_PID_SFX
#define DHCDBD_DHCLIENT_PID_SFX ".pid"
#endif

#ifndef DHCDBD_DHCLIENT_CONF_PFX
#define DHCDBD_DHCLIENT_CONF_PFX "/etc/dhclient"
#endif

#ifndef DHCDBD_DHCLIENT_CONF_SEP
#define DHCDBD_DHCLIENT_CONF_SEP "-"
#endif

#ifndef DHCDBD_DHCLIENT_CONF_SFX
#define DHCDBD_DHCLIENT_CONF_SFX ".conf"
#endif

#ifndef DHCLIENT_EXTENDED_OPTION_ENVIRONMENT
#define DHCLIENT_EXTENDED_OPTION_ENVIRONMENT 1
#endif

#define DHCDBD_INTERFACE_TEXT "text"   
#define DHCDBD_INTERFACE_BIN "binary"
#define DHCDBD_INTERFACE_DBUS "dbus"
#define DHCDBD_INTERFACE_SUBS "subscribe"

typedef enum dhcdbd_dhcsflags_e {
     DHCLIENT_SCRIPT_DEFAULT     = 0,
     DHCLIENT_SCRIPT_NO_RESOLV   = 1,
     DHCLIENT_SCRIPT_NO_IFCONFIG = 2,
     DHCLIENT_SCRIPT_NO_ROUTES   = 4,
     DHCLIENT_SCRIPT_NO_YPCONF   = 8,
     DHCLIENT_SCRIPT_NO_NTPCONF  =16,
     DHCLIENT_SCRIPT_DBUS_ONLY   =31
} DHCDBD_DHCLIENT_SCRIPT_MODE;

typedef enum dhcdbd_dhcflags_e {
     DHCLIENT_PERSISTENT = 1,
     DHCLIENT_RELEASE    = 2,
     DHCLIENT_NO_LEASES  = 4
} DHCDBD_DHCLIENT_FLAGS;

/* these correspond to "reason" dhcp option values */
typedef enum dhcdbd_dhcs_e {
     DHC_NBI,             /* no broadcast interfaces found              */
     DHC_PREINIT,         /* configuration started                      */
     DHC_BOUND,           /* lease obtained                             */
     DHC_RENEW,           /* lease renewed                              */
     DHC_REBOOT,          /* have valid lease, but now obtained a       */
                          /*     different one                          */
     DHC_REBIND,          /* new, different lease                       */
     DHC_STOP,            /* remove old lease                           */
     DHC_MEDIUM,          /* media selection begun                      */
     DHC_TIMEOUT,         /* timed out contacting DHCP server           */
     DHC_FAIL,            /* all attempts to contact server timed out,  */
                          /*     sleeping                               */
     DHC_EXPIRE,          /* lease has expired, renewing                */
     DHC_RELEASE,         /* releasing lease                            */
                          /* "fake" states generated by dhcdbd:         */
     DHC_START,           /* sent when dhclient started OK              */
     DHC_ABEND,           /* dhclient exited abnormally                 */
     DHC_END,             /* dhclient exited normally                   */
     DHC_END_OPTIONS,     /* last option in subscription sent           */
     DHC_INVALID=255      
}  DHCDBD_dhclient_state;

typedef enum {
    D_BUS_SESSION,
    D_BUS_SYSTEM, 
    D_BUS_STARTER 
} D_BUS_TYPE;

extern char *dhcdbd_destination, *dhcdbd_object_path, *dhcdbd_interface_prefix;
extern int dhcdbd_daemonize;

extern int dhcdbd_run(D_BUS_TYPE bus);

enum { FALSE, TRUE };

#endif
