case $CONFIG in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting Makefile (with variable substitutions)"
$spitshell >Makefile <<!GROK!THIS!
#
#  di makefile
#
#  Copyright 1995-2003 Brad Lanam
#
#  $Id: Makefile.SH,v 1.19 2003-01-12 13:18:02-08 bll Exp $
#  $Source: /home/bll/DI/RCS/Makefile.SH,v $
#  @(#)Makefile	1.25
#
#

SHELL = $sh
CC = $cc
LD = $ld
$make_set_make
OBJ_EXT = $_o
EXE_EXT = $_exe

#
# additional flags/libraries
#
CFLAGS = $ccflags $optimize -DDI_LOCALE_DIR=\\"\$(PREFIX)/lib/di/locale\\"
LDFLAGS = $ldflags
C64FLAGS = $cc64flags
LD64FLAGS = $ld64flags
OTHERFLAGS = -DPROG=\\"\$(PROG)\\" -DMPROG=\\"\$(MPROG)\\"
LIBS = $libs

#
# installation options
#
PREFIX = $prefix
INSTDIR = \$(PREFIX)/bin
PROG = $di_prog
MPROG = mi
TARGET = \$(INSTDIR)/\$(PROG)
MTARGET = \$(INSTDIR)/\$(MPROG)

# if you need permissions other than the default,
# edit these, and do a "make installperm".
USER = root
GROUP = bin
#INSTPERM = 111   # change USER to bin also...
INSTPERM = 4111   # install suid if your system has a mount table only root
#                   can read.  For SysV.4 and Solaris, the mount command may
#                   reset the permissions of /etc/mnttab.

#
# simple man page installation
#
MANDIR = $mansrcexp
MANTARGET = \$(PROG).$manext
MANPERM = 644

#
# common programs
#
LN = $ln
RM = $rm
CP = $cp
MV = $mv
TEST = $test
CHOWN = $chown
CHGRP = $chgrp
CHMOD = $chmod
TOUCH = $touch
SED = $sed
MSGFMT = $msgfmt
MKDIR = $mkdir

###

all:	\$(PROG)\$(EXE_EXT)

####################

all:	\$(PROG)\$(EXE_EXT)
	-\$(LN) -f \$(PROG)\$(EXE_EXT) \$(MPROG)\$(EXE_EXT)

all-64:	\$(PROG)-64\$(EXE_EXT)
	-\$(LN) -f \$(PROG)-64\$(EXE_EXT) \$(MPROG)-64\$(EXE_EXT)
	-\$(LN) -f \$(PROG)-32\$(EXE_EXT) \$(MPROG)-32\$(EXE_EXT)

objclean:
	-\$(RM) -rf *.o *.obj

clean:
	-\$(RM) -f \$(PROG)\$(EXE_EXT) \$(MPROG)\$(EXE_EXT) \\
		\$(PROG)-32\$(EXE_EXT) \$(MPROG)-32\$(EXE_EXT) \\
		\$(PROG)-64\$(EXE_EXT) \$(MPROG)-64\$(EXE_EXT) \\
		*.o *.obj a.out \\
		>/dev/null 2>&1
	-\$(RM) -rf UU > /dev/null 2>&1

distclean:
	\$(MAKE) clean
	-\$(RM) -f config.h config.sh Makefile \\
		di\$(EXE_EXT) diskinfo\$(EXE_EXT) \\
		Wanted Obsolete >/dev/null 2>&1

realclean:
	\$(MAKE) distclean

install:	install-prog install-man

install-po:	install-prog install-man
	-\$(TEST) -d \$(PREFIX)/lib || \$(MKDIR) \$(PREFIX)/lib
	-\$(TEST) -d \$(PREFIX)/lib/di || \$(MKDIR) \$(PREFIX)/lib/di
	-\$(TEST) -d \$(PREFIX)/lib/di/locale || \$(MKDIR) \$(PREFIX)/lib/di/locale
	-(cd po;for i in *.po; do \\
		j=\`echo \$\$i | \$(SED) 's,\\\\.po\$\$,,'\`; \\
		\$(TEST) -d \$(PREFIX)/lib/di/locale/\$\$j || \\
			\$(MKDIR) \$(PREFIX)/lib/di/locale/\$\$j; \\
		\$(TEST) -d \$(PREFIX)/lib/di/locale/\$\$j/LC_MESSAGES || \\
			\$(MKDIR) \$(PREFIX)/lib/di/locale/\$\$j/LC_MESSAGES; \\
		\$(MSGFMT) -o \$(PREFIX)/lib/di/locale/\$\$j/LC_MESSAGES/di.mo \$\$i; \\
	done)

install-prog:
	-\$(TEST) -d \$(PREFIX) || \$(MKDIR) \$(PREFIX)
	-\$(TEST) -d \$(INSTDIR) || \$(MKDIR) \$(INSTDIR)
	-\$(TEST) -f \$(TARGET) && \$(MV) -f \$(TARGET) \$(TARGET).old
	-\$(TEST) -f \$(MTARGET) && \$(MV) -f \$(MTARGET) \$(MTARGET).old
	\$(CP) -f \$(PROG) \$(TARGET)
	-\$(LN) -f \$(TARGET) \$(MTARGET)
	-\$(RM) -f \$(TARGET).old \$(MTARGET).old

install-man:
	\$(CP) -f di.1 \$(MANDIR)/\$(MANTARGET)
	\$(CHMOD) \$(MANPERM) \$(MANDIR)/\$(MANTARGET)

installperms:
	\$(CHOWN) \$(USER) \$(TARGET)
	\$(CHGRP) \$(GROUP) \$(TARGET)
	\$(CHMOD) \$(INSTPERM) \$(TARGET)

###

\$(PROG)\$(EXE_EXT):	di\$(OBJ_EXT) dilib\$(OBJ_EXT) getopt\$(OBJ_EXT)
	\$(CC) \$(CFLAGS) \$(LDFLAGS) \\
		-o \$(PROG)\$(EXE_EXT) \\
		di\$(OBJ_EXT) dilib\$(OBJ_EXT) getopt\$(OBJ_EXT) \$(LIBS)

\$(PROG)-64\$(EXE_EXT):
	\$(MAKE) objclean
	\$(MAKE) CFLAGS="\$(CFLAGS) \$(C64FLAGS)" \\
		LDFLAGS="\$(LDFLAGS) \$(LD64FLAGS)" \$(PROG)\$(EXE_EXT)
	test -f \$(PROG)\$(EXE_EXT) && \\
		mv -f \$(PROG)\$(EXE_EXT) \$(PROG)-64\$(EXE_EXT)
	\$(MAKE) objclean
	\$(MAKE) CFLAGS="\$(CFLAGS)" \\
		LDFLAGS="\$(LDFLAGS)" \$(PROG)\$(EXE_EXT)
	test -f \$(PROG)\$(EXE_EXT) && \\
		mv -f \$(PROG)\$(EXE_EXT) \$(PROG)-32\$(EXE_EXT)

###

di\$(OBJ_EXT):	di.c config.h di.h version.h
	\$(CC) -c \$(CFLAGS) \$(OTHERFLAGS) di.c

dilib\$(OBJ_EXT):	dilib.c config.h di.h
	\$(CC) -c \$(CFLAGS) dilib.c

getopt\$(OBJ_EXT):	getopt.c
	\$(CC) -c \$(CFLAGS) getopt.c


!GROK!THIS!

chmod 755 Makefile
$eunicefix Makefile
