/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_suite.cpp
 *
 * @brief [LEVEL: beta] implementation of @ref
 * diagnostics::unittest::Test_Suite class
 *
 * $Id: test_suite.cpp,v 1.6 2005/06/23 09:54:24 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#include <diagnostics/unittest/test_suite.hpp>

#include <diagnostics/unittest/test_case.hpp>
#include <diagnostics/unittest/test_system_exception.hpp>
#include <diagnostics/unittest/name_separators.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

Test_Suite::Test_Suite(::std::string const & name) 
    : m_name(name)
      
{
    if(!name_adheres_convention(name))
	throw Test_System_Exception("The Test_Suite name does not comply to the conventions");
}

Test_Suite::~Test_Suite()
{
    {
	Test_Cases_t::iterator current(m_test_cases.begin());
	Test_Cases_t::iterator const end (m_test_cases.end());
	for(;current!=end;++current) delete *current;
    }
    
    {
	Test_Suites_t::iterator current(m_test_suites.begin());
	Test_Suites_t::iterator const end (m_test_suites.end());
	for(;current!=end;++current) delete *current;
    }
}

void Test_Suite::add(Test_Case* const test_case) 
{
    if(test_case==NULL)	throw Test_System_Exception("test_case==NULL");
    if(test_case->name().size()==0) throw Test_System_Exception("tried to a add an unnamed test_case");    

    Test_Cases_t::const_iterator current(m_test_cases.begin());
    Test_Cases_t::const_iterator const end (m_test_cases.end());
    for(;current!=end;++current)
	if((*current)->name()==test_case->name())
	    throw Test_System_Exception("A Test_Case with name " + test_case->name() + " already exists.");
    

    m_test_cases.push_back(test_case);
}

void Test_Suite::add(Test_Suite* const test_suite) 
{
    if(test_suite==NULL) throw Test_System_Exception("test_suite==NULL");
    if(test_suite->name().size()==0) throw Test_System_Exception("tried to a add an unnamed test_suite");

    Test_Suites_t::const_iterator current(m_test_suites.begin());
    Test_Suites_t::const_iterator const end (m_test_suites.end());
    for(;current!=end;++current)
	if((*current)->name()==test_suite->name())
	    throw Test_System_Exception("A Test_Suite with name " + test_suite->name() + " already exists.");

    m_test_suites.push_back(test_suite);
}


UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
// vim:ts=4:sw=4
