/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/dummy_test_data_source.ts.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref ::diagnostics::unittest::testing::Dummy_Test_Data_Source
 *
 * @test none
 */


#ifndef DIAGNOSTICS__UTIL__DUMMY_TEST_DATA_SOURCE_TS_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__DUMMY_TEST_DATA_SOURCE_TS_HPP__INCLUDE_GUARD

#include <diagnostics/unittest.hpp>

#include <diagnostics/unittest/test_system/test_data_source.hpp>

#include <map>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

class Dummy_Test_Data_Source
    : public Test_Data_Source
{
public:
    Dummy_Test_Data_Source();

    virtual bool is_initialized() const;
    virtual bool exists_entry(::std::string const & id) const;
    virtual ::std::string const & get_entry(::std::string const & id) const;
    virtual void set_entry(::std::string const & id, ::std::string const & data);

    typedef ::std::map< ::std::string, ::std::string> Data_t;
    inline Data_t & data() { return m_data; }
private:
    Data_t m_data;
};


TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
