/****
DIAMOND protein aligner
Copyright (C) 2013-2018 Benjamin Buchfink <buchfink@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
****/

#ifndef FIXED_ARRAY_H_
#define FIXED_ARRAY_H_

#include <stdlib.h>
#include <string.h>

template <typename _t>
struct FixedArray
{

	FixedArray():
		data_(NULL)
	{}

	~FixedArray()
	{
		delete[] data_;
	}

	void resize(size_t n)
	{
		delete[] data_;
		data_ = new _t[n];
		memset(data_, 0, sizeof(_t)*n);
	}

	_t& operator[](size_t i)
	{
		return data_[i];
	}

private:

	_t *data_;

};

#endif