/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

/*******************************************************************************
 Esta rutina genera el archivo configure.ac, a partir del cual se genera
 el script configure usando autoconf.
 Devido a los problemas de conpilacion en otras distribuciones distintas
 a debian, el archivo generado es el configure.in
 *******************************************************************************/
void aut_crear_configure_ac(void)
{
	gchar *nombre;
	FILE *archivo;
	gchar *contenido,*tmp;
	gchar *version;
	gchar *lenguaje;
	gchar *libs;
	gchar *libs_usuario;
	gchar *opciones;
	gchar *warnings;
	gchar *srcdir;
	gchar *glade_file;
	gchar *idiomas;
	gint cont;
	gboolean usar_pkg_config;
	gchar *nombre_locale;
	gsize read, written;
	GError *error;
	
	DEBUG_MSG(->aut_crear_configure_ac);
	contenido=g_strdup_printf("dnl Process this file with autoconf to produce a configure script.\n");
	tmp=contenido;
	contenido=g_strdup_printf("%s\nAC_INIT\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\nAC_PREREQ(2.50)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\nAC_CONFIG_SRCDIR([configure.ac])\n",tmp);
	g_free(tmp);
	tmp=contenido;
	nombre=pro_ejecutable(LOCALE);
	version=pro_version();
	contenido=g_strdup_printf("%sAM_INIT_AUTOMAKE(%s, %s)\n",tmp,nombre,version);
	g_free(nombre);
	g_free(version);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sAM_CONFIG_HEADER(config.h)\n",tmp);
	g_free(tmp);
	tmp=contenido;

	libs=pro_librerias_lincado();

	contenido=g_strdup_printf("%s\nAC_PROG_INSTALL\n",tmp);
	g_free(tmp);
	tmp=contenido;

	lenguaje=pro_lenguaje();
	switch (lenguaje[0]) {
		case '0':
			contenido=g_strdup_printf("%s\nAC_PROG_CC\n",tmp);
			break;
		case '1':
			contenido=g_strdup_printf("%s\nAC_PROG_CXX\n",tmp);
			break;
	}
	g_free(tmp);
	tmp=contenido;
	switch (lenguaje[0]) {
		case '0':
			contenido=g_strdup_printf("%s\nAC_LANG_C\n",tmp);
			break;
		case '1':
			contenido=g_strdup_printf("%s\nAC_LANG_CPLUSPLUS\n",tmp);
			break;
	}
	g_free(tmp);
	tmp=contenido;

	if (libs[LGETTEXT]=='1') {
		idiomas=pro_idiomas();
		contenido=g_strdup_printf("%s\ndnl Add the languages wich your aplication supports here.\nALL_LINGUAS=\"%s\"\nAM_GNU_GETTEXT\n",tmp,idiomas);
		g_free(tmp);
		g_free(idiomas);
		tmp=contenido;
	}

	contenido=g_strdup_printf("%s\ndnl Set PACKAGE_LOCALE_DIR in config.h.\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sif test \"x${prefix}\" = \"xNONE\"; then\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_LOCALE_DIR, \"${ac_default_prefix}/${DATADIRNAME}/locale\",This needs a coment)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%selse\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_LOCALE_DIR, \"${prefix}/${DATADIRNAME}/locale\",This needs a coment)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sfi\n",tmp);
	g_free(tmp);
	tmp=contenido;
	
	if ((libs[LGNOME2]=='1') || (libs[LGTK2]=='1') || (libs[LGTK_X112])) {
		contenido=g_strdup_printf("%s\ndnl Set PREFIX in config.h.\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sAC_DEFINE(PREFIX, \"${prefix}\",This needs a coment)\n",tmp);
		g_free(tmp);
		tmp=contenido;

		contenido=g_strdup_printf("%s\ndnl Set SYSCONFDIR in config.h.\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sAC_DEFINE(SYSCONFDIR, \"${sysconfdir}\",This needs a coment)\n",tmp);
		g_free(tmp);
		tmp=contenido;
		
		contenido=g_strdup_printf("%s\ndnl Set DATADIR in config.h.\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sAC_DEFINE(DATADIR, \"${datadir}\",This needs a coment)\n",tmp);
		g_free(tmp);
		tmp=contenido;
		
		contenido=g_strdup_printf("%s\ndnl Set LIBDIR in config.h.\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sAC_DEFINE(LIBDIR, \"${libdir}\",This needs a coment)\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	
	contenido=g_strdup_printf("%s\ndnl Subst PACKAGE_PIXMAPS_DIR and set it in config.h.\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sif test \"x${prefix}\" = \"xNONE\"; then\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_PIXMAPS_DIR, \"${ac_default_prefix}/share/pixmaps/${PACKAGE}\",This is the path where pixmaps will be instaled)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tPACKAGE_PIXMAPS_DIR=\"${ac_default_prefix}/share/pixmaps/${PACKAGE}\"\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%selse\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_PIXMAPS_DIR, \"${prefix}/share/pixmaps/${PACKAGE}\",This is the path where pixmaps will be instaled)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tPACKAGE_PIXMAPS_DIR=\"${prefix}/share/pixmaps/${PACKAGE}\"\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sfi\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sAC_SUBST(PACKAGE_PIXMAPS_DIR)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	
	contenido=g_strdup_printf("%s\ndnl Subst PACKAGE_DATA_DIR and set it in config.h.\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sif test \"x${prefix}\" = \"xNONE\"; then\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_DATA_DIR, \"${ac_default_prefix}/share/${PACKAGE}\",This is the path where data will be instaled)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tPACKAGE_DATA_DIR=\"${ac_default_prefix}/share/${PACKAGE}\"\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%selse\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_DATA_DIR, \"${prefix}/share/${PACKAGE}\",This is the path where data will be instaled)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tPACKAGE_DATA_DIR=\"${prefix}/share/${PACKAGE}\"\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sfi\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sAC_SUBST(PACKAGE_DATA_DIR)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	
	contenido=g_strdup_printf("%s\ndnl Subst PACKAGE_DOC_DIR and set it in config.h.\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sif test \"x${prefix}\" = \"xNONE\"; then\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_DOC_DIR, \"${ac_default_prefix}/share/doc/${PACKAGE}\",This is the path where docs will be instaled)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tPACKAGE_DOC_DIR=\"${ac_default_prefix}/share/doc/${PACKAGE}\"\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%selse\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(PACKAGE_DOC_DIR, \"${prefix}/share/doc/${PACKAGE}\",This is the path where docs will be instaled)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tPACKAGE_DOC_DIR=\"${prefix}/share/doc/${PACKAGE}\"\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sfi\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sAC_SUBST(PACKAGE_DOC_DIR)\n",tmp);
	g_free(tmp);
	tmp=contenido;

	if (libs[LLIBGLADE2]=='1') {
		glade_file=pro_glade_file(LOCALE);
		if (glade_file!=NULL) {
			contenido=g_strdup_printf("%s\ndnl Set GLADE_PROJECT in config.h.\n",tmp);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%sif test \"x${prefix}\" = \"xNONE\"; then\n",tmp);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(GLADE_PROJECT, \"${ac_default_prefix}/share/${PACKAGE}/%s\",This is the path where the glade proyect file will be instaled including the file name)\n",tmp,glade_file);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%selse\n",tmp);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%s\tAC_DEFINE_UNQUOTED(GLADE_PROJECT, \"${prefix}/share/${PACKAGE}/%s\",This is the path where the glade proyect file will be instaled including the file name)\n",tmp,glade_file);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%sfi\n",tmp);
			g_free(tmp);
			tmp=contenido;
		}
		g_free(glade_file);
	}

	//with this lines we try to autodetect the sistem type to create specific defines
	contenido=g_strdup_printf("%s\ndnl Try to autodetect system type\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sAC_CHECK_PROG(SYSTEM_TYPE,uname,`uname -s`,\"FALSE\")\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sif test \"x${SYSTEM_TYPE}\" = \"xFALSE\"; then\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tUNAME_DEFS=\"\"\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%selse\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tcase $SYSTEM_TYPE in\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tLinux)\n\t\tUNAME_DEFS=\"-D_LINUX\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tFreeBSD)\n\t\tUNAME_DEFS=\"-D_FREEBSD\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tNetBSD)\n\t\tUNAME_DEFS=\"-D_NETBSD\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tBSD/OS)\n\t\tUNAME_DEFS=\"-D_BSD_OS\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tOpenBSD)\n\t\tUNAME_DEFS=\"-D_OPENBSD\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tSunOS)\n\t\tUNAME_DEFS=\"-D_SUNOS\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tQNX)\n\t\tUNAME_DEFS=\"-D_QNX\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tDarwin)\n\t\tUNAME_DEFS=\"-D_DARWIN\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tIRIX*)\n\t\tUNAME_DEFS=\"-D_IRIX\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tHP-UX*)\n\t\tUNAME_DEFS=\"-D_HP_UX\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t[cC][yY][gG][wW][iI][nN]*)\n\t\tUNAME_DEFS=\"-D_CYGWIN\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t*)\n\t\tUNAME_DEFS=\"\"\n\t\t;;\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tesac\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%sfi\n",tmp);
	g_free(tmp);
	tmp=contenido;

	opciones=pro_opciones_cflags();
	warnings=pro_warnings();
	switch (lenguaje[0]) {
		case '0':
			contenido=g_strdup_printf("%s\nCFLAGS=\"%s %s\"\n",tmp,opciones,warnings);
			break;
		case '1':
			contenido=g_strdup_printf("%s\nCXXFLAGS=\"%s %s\"\n",tmp,opciones,warnings);
			break;
	}
	g_free(tmp);
	g_free(opciones);
	g_free(warnings);
	tmp=contenido;
	
	contenido=g_strdup_printf("%s\ndnl Looking for configuration scripts.\n",tmp);
	g_free(tmp);
	tmp=contenido;
	for (cont=0;cont<LGLIB2;cont++) {
		if ((libs[cont]=='1') && (preferencias.inc[cont]!=NULL) && (pro_nombre_librerias_autoconf[cont]!=NULL)) {
			contenido=g_strdup_printf("%s%s_INC=\"%s\"\nAC_SUBST(%s_INC)\n",tmp,pro_nombre_librerias_autoconf[cont],preferencias.inc[cont],pro_nombre_librerias_autoconf[cont]);
			g_free(tmp);
			tmp=contenido;
		}
	}
	usar_pkg_config=FALSE;
	for (cont=LGLIB2;cont<LTOTALES;cont++) {
		if (libs[cont]=='1') {
			usar_pkg_config=TRUE;
		}
	}
	if (usar_pkg_config) {
		contenido=g_strdup_printf("%sAC_CHECK_PROG(PKG_INC,pkg-config,`pkg-config --cflags",tmp);
		g_free(tmp);
		tmp=contenido;
		for (cont=LGLIB2;cont<LTOTALES;cont++) {
			if ((libs[cont]=='1') && (preferencias.inc[cont]!=NULL) && (pro_nombre_librerias_autoconf[cont]!=NULL)) {
				contenido=g_strdup_printf("%s %s",tmp,pro_nombre_librerias[cont]);
				g_free(tmp);
				tmp=contenido;
			}
		}
		contenido=g_strdup_printf("%s`)\nAC_SUBST(PKG_INC)\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}

	contenido=g_strdup_printf("%s\ndnl Looking for libraries.\n",tmp);
	g_free(tmp);
	tmp=contenido;

	usar_pkg_config=FALSE;
	for (cont=LGLIB2;cont<LTOTALES;cont++) {
		if (libs[cont]=='1') {
			usar_pkg_config=TRUE;
		}
	}
	if (usar_pkg_config) {
		contenido=g_strdup_printf("%sPKG_LIB2=`pkg-config --libs",tmp);
		g_free(tmp);
		tmp=contenido;
		for (cont=LGLIB2;cont<LTOTALES;cont++) {
			if ((libs[cont]=='1') && (pro_nombre_librerias_autoconf[cont]!=NULL)) {
				contenido=g_strdup_printf("%s %s",tmp,pro_nombre_librerias[cont]);
				g_free(tmp);
				tmp=contenido;
			}
		}
		contenido=g_strdup_printf("%s`\nPKG_LIB=\"\"\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $PKG_LIB2 ; do\n\tcase $i in \n\t\t-l*) PKG_LIB=\"$i $PKG_LIB\" ;;\n\t\t-L*) LIBS=\"$LIBS $i\" ;;\n\t\t*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $PKG_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LX11]=='1') {
		if (preferencias.lib[LX11]!=NULL) {
			contenido=g_strdup_printf("%sLIBS=\"%s $LIBS\"\n",tmp,preferencias.lib[LX11]);
			g_free(tmp);
			tmp=contenido;
		}
		contenido=g_strdup_printf("%sAC_CHECK_LIB(ICE,main)\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sAC_CHECK_LIB(SM,main)\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sAC_CHECK_LIB(Xext,main)\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sAC_CHECK_LIB(X11,main)\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sAC_CHECK_LIB(Xi,main)\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	libs_usuario=pro_librerias_usuario();
	if (libs_usuario!=NULL) {
		contenido=g_strdup_printf("%s%s\nUSER_LIB=\"\"\n",tmp,libs_usuario);
		g_free(tmp);
		tmp=contenido;
		g_free(libs_usuario);
		contenido=g_strdup_printf("%sfor i in $USER_LIBS ; do\n\tcase $i in \n\t\t-l*) USER_LIB=\"$i $USER_LIB\" ;;\n\t\t-L*) LIBS=\"$LIBS $i\" ;;\n\t\t*) LIBS=\"$i $LIBS\" ;;\n\tesac\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
		contenido=g_strdup_printf("%sfor i in $USER_LIB ; do\n\tj=${i#'-l'}\n\tAC_CHECK_LIB($j,main)\ndone\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	if (libs[LELECTRIC_FENCE]=='1') {
		if (preferencias.lib_electric_fence!=NULL) {
			contenido=g_strdup_printf("%sLIBS=\"$LIBS %s\"\n",tmp,preferencias.lib_electric_fence);
			g_free(tmp);
			tmp=contenido;
		}
		contenido=g_strdup_printf("%sAC_CHECK_LIB(efence,main)\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	
	contenido=g_strdup_printf("%s\nAC_CONFIG_FILES([\nMakefile\n",tmp);
	g_free(tmp);
	tmp=contenido;
	srcdir=pro_srcdir(LOCALE);
	contenido=g_strdup_printf("%s%s/Makefile\n",tmp,srcdir);
	g_free(tmp);
	g_free(srcdir);
	tmp=contenido;
	if (libs[LGETTEXT]=='1') {
		contenido=g_strdup_printf("%spo/Makefile.in\nintl/Makefile\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	contenido=g_strdup_printf("%s])\nAC_OUTPUT\n",tmp);
	g_free(tmp);
	tmp=contenido;
	
	nombre=pro_nombre_completo_archivo("configure.ac",FALSE, LOCALE);
	archivo=fopen(nombre,"w");
	fwrite(contenido,strlen(contenido),1,archivo);
	fclose(archivo);
	g_free(nombre);
	g_free(contenido);
	g_free(libs);
	g_free(lenguaje);
	nombre=pro_nombre_completo_archivo("configure.in",FALSE, UTF8);
	if (gen_existe_fichero(nombre)) {
		nombre_locale = g_locale_from_utf8(nombre, -1, &read, &written, &error);
		remove(nombre_locale);
		g_free(nombre_locale);
	}
	g_free(nombre);
	autoconfiguracion=autoconfiguracion | AUTO_CONF;

	DEBUG_MSG(->aut_crear_configure_ac);
}

/*******************************************************************************
 Esta funcion genera el Makefile.am que hay en la carpeta de las fuentes
 *******************************************************************************/
void aut_crear_makefile_src(void)
{
	FILE *archivo;
	gchar *nombre;
	gchar *contenido,*tmp,*siguiente;
	gint cont;
	xmlNodePtr nodo;
	gchar *includes;
	gchar *libs;
	gchar *srcdir,*prodir;
	gboolean usar_pkg_config;
	
	DEBUG_MSG(->aut_crear_makefile_src);
	contenido=g_strdup_printf("## Process this file with automake to produce Makefile.in\n");
	tmp=contenido;
	contenido=g_strdup_printf("%s\nINCLUDES=",tmp);
	g_free(tmp);
	tmp=contenido;
	libs=pro_librerias_lincado();
	for (cont=0;cont<LGLIB2;cont++) {
		if ((libs[cont]=='1') && (preferencias.inc[cont]!=NULL) && (pro_nombre_librerias_autoconf[cont]!=NULL)) {
			contenido=g_strdup_printf("%s @%s_INC@",tmp,pro_nombre_librerias_autoconf[cont]);
			g_free(tmp);
			tmp=contenido;
		}
	}
	usar_pkg_config=FALSE;
	for (cont=LGLIB2;cont<LTOTALES;cont++) {
		if (libs[cont]=='1') {
			usar_pkg_config=TRUE;
		}
	}
	if (usar_pkg_config) {
		contenido=g_strdup_printf("%s @PKG_INC@",tmp);
		g_free(tmp);
		tmp=contenido;
	}
	g_free(libs);
	includes=pro_includes();
	if (includes!=NULL) {
		contenido=g_strdup_printf("%s %s",tmp,includes);
		g_free(tmp);
		tmp=contenido;
	}
	contenido=g_strdup_printf("%s -I/usr/include",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\n",tmp);
	g_free(tmp);
	tmp=contenido;
	nombre=pro_ejecutable(LOCALE);
	contenido=g_strdup_printf("%s\nbin_PROGRAMS = %s\n",tmp,nombre);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\n%s_SOURCES = \\\n",tmp,nombre);
	g_free(tmp);
	tmp=contenido;
	g_free(nombre);
	nodo=NULL;
	do {
		siguiente=pro_cabeceras(&nodo, LOCALE);
		if (siguiente!=NULL) {
			contenido=g_strdup_printf("%s\t%s \\\n",tmp,siguiente);
			g_free(siguiente);
			g_free(tmp);
			tmp=contenido;
		}
	} while (siguiente!=NULL);
	nodo=NULL;
	do {
		siguiente=pro_fuentes(&nodo, LOCALE);
		if (siguiente!=NULL) {
			contenido=g_strdup_printf("%s\t%s \\\n",tmp,siguiente);
			g_free(siguiente);
			g_free(tmp);
			tmp=contenido;
		}
	} while (siguiente!=NULL);
	for (cont=0;contenido[cont]!=0;cont++);
	for (;contenido[cont]!=' ';cont--);
	contenido[cont]='\n';
	contenido[cont+1]=0;
	prodir=pro_prodir(LOCALE);
	srcdir=pro_srcdir(LOCALE);
	nombre=g_strdup_printf("%s/%s/Makefile.am",prodir,srcdir);
	g_free(prodir);
	g_free(srcdir);
	archivo=fopen(nombre,"w");
	fwrite(contenido,strlen(contenido),1,archivo);
	fclose(archivo);
	g_free(nombre);
	g_free(contenido);
	autoconfiguracion=autoconfiguracion | AUTO_MAKE;

	DEBUG_MSG(<-aut_crear_makefile_src);
}

/*******************************************************************************
 Esta funcion genera el Makefile.am que hay en el directorio raiz del proyecto
 *******************************************************************************/
void aut_crear_makefile(void)
{
	FILE *archivo;
	gchar *nombre;
	gchar *contenido,*tmp;
	gchar *srcdir;
	gint cont;
	gchar *libs;
	gchar *pixdir;
	gchar *datadir;
	gchar *docdir;
	gchar *glade_file;
	
	DEBUG_MSG(->aut_crear_makefile);
	contenido=g_strdup_printf("## Process this file with automake to produce Makefile.in\n");
	tmp=contenido;
	srcdir=pro_srcdir(LOCALE);
	contenido=g_strdup_printf("%s\nSUBDIRS = %s\n",tmp,srcdir);
	g_free(tmp);
	tmp=contenido;
	g_free(srcdir);
	libs=pro_librerias_lincado();
	if (libs[LGETTEXT]=='1') {
		for (cont=0;contenido[cont]!=0;cont++);
		contenido[cont-1]=0;

		contenido=g_strdup_printf("%s intl po\n",tmp);
		g_free(tmp);
		tmp=contenido;
	}

	if ((libs[LGNOME2]=='1') || (libs[LGTK2]=='1') || (libs[LGTK_X112])) {
		glade_file=pro_glade_file(LOCALE);
		if (glade_file!=NULL) {
			contenido=g_strdup_printf("%s\n## Add extra files that sould be included in the distribution.\n",tmp);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%sEXTRA_DIST = %s %sp\n",tmp,glade_file,glade_file);
			g_free(tmp);
			tmp=contenido;
			g_free(glade_file);
		}
	}
	
	pixdir=pro_pixdir(LOCALE);
	datadir=pro_datadir(LOCALE);
	docdir=pro_docdir(LOCALE);
	// here we add instruction to install the pixmaps, data and docs directorys
	contenido=g_strdup_printf("%s\ninstall-data-local:\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t@$(NORMAL_INSTALL)\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tfunction strlen_diasce {\\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\teval echo \"\\$${#$${1}}\"; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t}; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tfunction es_cvs_diasce {\\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\ttemporal=$$1; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tlongitud=\"$$(strlen_diasce temporal)\"; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tlet longitud=longitud-4; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tcadena=$${temporal:longitud}; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tif [ \"x$$cadena\" = \"x/CVS\" ] ; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\treturn 0; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\telse \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\treturn 1; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfi; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t}; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tfunction subdirs_diasce {\\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\ttemporal=$$3; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tlongitud=\"$$(strlen_diasce temporal)\"; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfor doc in $$1/*; do \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tif test -f $$doc; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tdestino=\"$$2$${1:longitud}\"; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t$(INSTALL_DATA) $$doc $$destino; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfi; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tif test -d $$doc; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tif ! (es_cvs_diasce $$doc); then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\tdestino=\"$$2$${doc:longitud}\"; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\t$(mkinstalldirs) $$destino; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\tsubdirs_diasce $$doc $$2 $$3; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tdone; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t}; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	// first the pixmaps directorie
	contenido=g_strdup_printf("%s\tif test -d $(srcdir)/%s; then \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tif test \"x${prefix}\" = \"xNONE\"; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t$(mkinstalldirs) $(DESTDIR)@PACKAGE_PIXMAPS_DIR@; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfor pixmap in $(srcdir)/%s/*; do \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tif test -f $$pixmap; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\t$(INSTALL_DATA) $$pixmap $(DESTDIR)@PACKAGE_PIXMAPS_DIR@; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tdone \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\telse \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t$(mkinstalldirs) $(DESTDIR)$(prefix)/share/pixmaps/$(PACKAGE); \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfor pixmap in $(srcdir)/%s/*; do \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tif test -f $$pixmap; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\t$(INSTALL_DATA) $$pixmap $(DESTDIR)$(prefix)/share/pixmaps/$(PACKAGE); \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tdone \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tfi; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	// second the data directorie
	contenido=g_strdup_printf("%s\tif test -d $(srcdir)/%s; then \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tif test \"x${prefix}\" = \"xNONE\"; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t$(mkinstalldirs) $(DESTDIR)@PACKAGE_DATA_DIR@; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfor data in $(srcdir)/%s/*; do \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tif test -f $$data; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\t$(INSTALL_DATA) $$data $(DESTDIR)@PACKAGE_DATA_DIR@; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tdone \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\telse \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t$(mkinstalldirs) $(DESTDIR)$(prefix)/share/$(PACKAGE); \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfor data in $(srcdir)/%s/*; do \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tif test -f $$data; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\t$(INSTALL_DATA) $$data $(DESTDIR)$(prefix)/share/$(PACKAGE); \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tdone \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tfi; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	// third the doc directorie
	contenido=g_strdup_printf("%s\tif test -d $(srcdir)/%s; then \\\n",tmp,docdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tif test \"x${prefix}\" = \"xNONE\"; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t$(mkinstalldirs) $(DESTDIR)@PACKAGE_DOC_DIR@; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tsubdirs_diasce $(srcdir)/%s $(DESTDIR)@PACKAGE_DOC_DIR@ $(srcdir)/%s;\\\n",tmp,docdir,docdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\telse \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t$(mkinstalldirs) $(DESTDIR)$(prefix)/share/doc/$(PACKAGE); \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tsubdirs_diasce $(srcdir)/%s $(DESTDIR)$(prefix)/share/doc/$(PACKAGE) $(srcdir)/%s; \\\n",tmp,docdir,docdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tfi\n",tmp);
	g_free(tmp);
	tmp=contenido;
	// now we add instructions to get the glade project file to get instaled in the data directorie if necesary
	if (libs[LLIBGLADE2]=='1') {
		glade_file=pro_glade_file(LOCALE);
		if (glade_file!=NULL) {
			contenido=g_strdup_printf("%s\tif test -f $(srcdir)/%s; then \\\n",tmp,glade_file);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%s\t\tif test \"x${prefix}\" = \"xNONE\"; then \\\n",tmp);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%s\t\t\t$(mkinstalldirs) $(DESTDIR)@PACKAGE_DATA_DIR@; \\\n",tmp);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%s\t\t\t$(INSTALL_DATA) %s $(DESTDIR)@PACKAGE_DATA_DIR@; \\\n",tmp,glade_file);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%s\t\telse \\\n",tmp);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%s\t\t\t$(mkinstalldirs) $(DESTDIR)$(prefix)/share/$(PACKAGE); \\\n",tmp);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%s\t\t\t$(INSTALL_DATA) %s $(DESTDIR)$(prefix)/share/$(PACKAGE); \\\n",tmp,glade_file);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%s\t\tfi \\\n",tmp);
			g_free(tmp);
			tmp=contenido;
			contenido=g_strdup_printf("%s\tfi\n",tmp);
			g_free(tmp);
			tmp=contenido;
		}
		g_free(glade_file);
	}
	
	// here we add instructions to include de pixmaps and data directories in the distribution
	contenido=g_strdup_printf("%s\ndist-hook:\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tfunction strlen_diasce {\\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\teval echo \"\\$${#$${1}}\"; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t}; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tfunction es_cvs_diasce {\\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\ttemporal=$$1; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tlongitud=\"$$(strlen_diasce temporal)\"; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tlet longitud=longitud-4; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tcadena=$${temporal:longitud}; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tif [ \"x$$cadena\" = \"x/CVS\" ] ; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\treturn 0; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\telse \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\treturn 1; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfi; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t}; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tfunction subdirs_diasce {\\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\ttemporal=$$3; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tlongitud=\"$$(strlen_diasce temporal)\"; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfor doc in $$1/*; do \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tif test -f $$doc; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tdestino=\"$$2$${1:longitud}\"; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tcp -p $$doc $$destino; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfi; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tif test -d $$doc; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tif ! (es_cvs_diasce $$doc); then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\tdestino=\"$$2$${doc:longitud}\"; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\t$(mkinstalldirs) $$destino; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\t\tsubdirs_diasce $$doc $$2 $$3; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfi \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tdone; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t}; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	// first the pixmaps directorie
	contenido=g_strdup_printf("%s\tif test -d %s; then \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tmkdir $(distdir)/%s; \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfor pixmap in %s/*; do \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tif test -f $$pixmap; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tcp -p $$pixmap $(distdir)/%s; \\\n",tmp,pixdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfi \\\n\t\tdone \\\n\tfi; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	// second the	data directorie
	contenido=g_strdup_printf("%s\tif test -d %s; then \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tmkdir $(distdir)/%s; \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tfor data in %s/*; do \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tif test -f $$data; then \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\t\tcp -p $$data $(distdir)/%s; \\\n",tmp,datadir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tfi \\\n\t\tdone \\\n\tfi; \\\n",tmp);
	g_free(tmp);
	tmp=contenido;
	// third the	doc directorie
	contenido=g_strdup_printf("%s\tif test -d %s; then \\\n",tmp,docdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\tmkdir $(distdir)/%s; \\\n",tmp,docdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\t\t\tsubdirs_diasce %s $(distdir)/%s %s; \\\n",tmp,docdir,docdir,docdir);
	g_free(tmp);
	tmp=contenido;
	contenido=g_strdup_printf("%s\tfi\n",tmp);
	g_free(tmp);
	tmp=contenido;
	g_free(pixdir);
	g_free(datadir);
	g_free(docdir);
	
	nombre=pro_nombre_completo_archivo("Makefile.am",FALSE, LOCALE);
	archivo=fopen(nombre,"w");
	fwrite(contenido,strlen(contenido),1,archivo);
	fclose(archivo);
	g_free(nombre);
	g_free(contenido);
	g_free(libs);
	autoconfiguracion=autoconfiguracion | AUTO_MAKE;
	
	DEBUG_MSG(<-aut_crear_makefile);
}

/*******************************************************************************
 Esta funcion genera el archivo profiles.in que se encuentra en la carpeta po
 *******************************************************************************/
void aut_crear_potfiles_in(void)
{
	FILE *archivo;
	gchar *nombre;
	gchar *contenido,*tmp,*siguiente;
	xmlNodePtr nodo;
	gchar *libs;
	gchar *srcdir;
	
	DEBUG_MSG(->aut_crear_potfiles_in);
	libs=pro_librerias_lincado();
	if (libs[LGETTEXT]=='0') {
		g_free(libs);
		DEBUG_MSG(<-aut_crear_potfiles_in GETTEXT off);
		return;
	}
	
	contenido=g_strdup_printf("# List of source files containing translable strings.\n\n");
	tmp=contenido;
	
	srcdir=pro_srcdir(LOCALE);
	if ((libs[LLIBGLADE2]=='1') && (libs[LGETTEXT]=='1')) {
		contenido=g_strdup_printf("%s%s/translatable_strings_file.c\n",tmp,srcdir);
		g_free(tmp);
		tmp=contenido;
	}
	
	nodo=NULL;
	do {
		siguiente=pro_fuentes(&nodo, LOCALE);
		if (siguiente!=NULL) {
			contenido=g_strdup_printf("%s%s/%s\n",tmp,srcdir,siguiente);
			g_free(siguiente);
			g_free(tmp);
			tmp=contenido;
		}
	} while (siguiente!=NULL);
	g_free(srcdir);

	nombre=pro_prodir(LOCALE);
	tmp=nombre;
	nombre=g_strdup_printf("%s/po/POTFILES.in",tmp);
	g_free(tmp);
	archivo=fopen(nombre,"w");
	fwrite(contenido,strlen(contenido),1,archivo);
	fclose(archivo);
	g_free(nombre);
	g_free(contenido);
	g_free(libs);
	DEBUG_MSG(<-aut_crear_potfiles_in);
}

/*******************************************************************************
 Esta funcion genera el archivo acconfig.h
 *******************************************************************************/
void aut_crear_acconfig_h(void)
{
	gchar *nombre;
	
	DEBUG_MSG(->aut_crear_acconfig_h);

	nombre=pro_nombre_completo_archivo("acconfig",TRUE, LOCALE);
	g_free(nombre);
	if (gen_existe_fichero("acconfig.h")) {
		remove("acconfig.h");
	}
	
	autoconfiguracion=autoconfiguracion | AUTO_HEADER;
	
	DEBUG_MSG(<-aut_crear_acconfig_h);
}
