/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

/*******************************************************************************
 Inicializa las variables globales del arbol cefv
 *******************************************************************************/
void cefv_inicializar(void)
{
	GtkTreeView *tree_view;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkTreeSelection *selection;

	DEBUG_MSG(->cefv_inicializar);
	lista_cefv=NULL;

	cefv_store=gtk_tree_store_new(COL_TOTAL,GDK_TYPE_PIXBUF,G_TYPE_STRING);
		
	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(david_ventana,"cefv_arbol"));
	gtk_tree_view_set_model(tree_view,GTK_TREE_MODEL(cefv_store));
	
	renderer=gtk_cell_renderer_pixbuf_new();
	column=gtk_tree_view_column_new_with_attributes(NULL,renderer,"pixbuf",COL_ICONO,NULL);
	gtk_tree_view_append_column(tree_view,column);
	renderer=gtk_cell_renderer_text_new();
	column=gtk_tree_view_column_new_with_attributes(NULL,renderer,"text",COL_NOMBRE,NULL);
	gtk_tree_view_append_column(tree_view,column);
	
	selection=gtk_tree_view_get_selection(tree_view);
	gtk_tree_selection_set_mode(selection,GTK_SELECTION_SINGLE);
	g_signal_connect(G_OBJECT(selection),"changed",G_CALLBACK(on_cefv_arbol_tree_select_row),NULL);
	
	gtk_tree_sortable_set_default_sort_func(GTK_TREE_SORTABLE(cefv_store),(GtkTreeIterCompareFunc)gen_GtkTreeIterCompareFunc,(gpointer)COL_NOMBRE,NULL);
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(cefv_store),GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,GTK_SORT_ASCENDING);
		
	DEBUG_MSG(<-cefv_inicializar);
}

/*******************************************************************************
 Creea el arbol cefv con las secciones bacias
 *******************************************************************************/
void cefv_crear(void)
{
	DEBUG_MSG(->cefv_crear);
	
	gtk_tree_store_clear(cefv_store);

	gtk_tree_store_append(cefv_store,&cefv_clases,NULL);
	gtk_tree_store_append(cefv_store,&cefv_funciones,NULL);
	gtk_tree_store_append(cefv_store,&cefv_uniones,NULL);
	gtk_tree_store_append(cefv_store,&cefv_estructuras,NULL);
	gtk_tree_store_append(cefv_store,&cefv_bariables,NULL);
	gtk_tree_store_append(cefv_store,&cefv_enumeraciones,NULL);
	gtk_tree_store_append(cefv_store,&cefv_tipos,NULL);

	gtk_tree_store_set(cefv_store,&cefv_clases,COL_ICONO,pixbufs[CLASES],COL_NOMBRE,_("Clases"),-1);
	gtk_tree_store_set(cefv_store,&cefv_funciones,COL_ICONO,pixbufs[FUNCIONES],COL_NOMBRE,_("Functions"),-1);
	gtk_tree_store_set(cefv_store,&cefv_uniones,COL_ICONO,pixbufs[UNIONES],COL_NOMBRE,_("Unions"),-1);
	gtk_tree_store_set(cefv_store,&cefv_estructuras,COL_ICONO,pixbufs[ESTRUCURAS],COL_NOMBRE,_("Structures"),-1);
	gtk_tree_store_set(cefv_store,&cefv_bariables,COL_ICONO,pixbufs[BARIABLES],COL_NOMBRE,_("Variables"),-1);
	gtk_tree_store_set(cefv_store,&cefv_enumeraciones,COL_ICONO,pixbufs[ENUMERACIONES],COL_NOMBRE,_("Enumerations"),-1);
	gtk_tree_store_set(cefv_store,&cefv_tipos,COL_ICONO,pixbufs[TIPOS],COL_NOMBRE,_("Types"),-1);

	cefv_lista_combo=NULL;
	cefv_congelar_lista_combo=TRUE;
	DEBUG_MSG(<-cefv_crear);
}

/*******************************************************************************
 Aade una entrada al arbol cefv
 El parametro pasado es una cadena correspondiente a una linea del
 archivo tags creado por exuberant-ctags
 *******************************************************************************/
void cefv_anadir(gchar *tag_line)
{
	struct s_lista_cefv *nodo_lista;
	gchar *archivo,*definicion,*texto_rama;
	guint cont,inicio;
	gchar *tipo;
	
	if (lista_cefv==NULL) {
		lista_cefv=g_malloc(sizeof(struct s_lista_cefv));
		nodo_lista=lista_cefv;
		nodo_lista->anterior=NULL;
	} else {
		nodo_lista=lista_cefv;
		while (nodo_lista->siguiente!=NULL) {
			nodo_lista=nodo_lista->siguiente;
		}
		nodo_lista->siguiente=g_malloc(sizeof(struct s_lista_cefv));
		nodo_lista->siguiente->anterior=nodo_lista;
		nodo_lista=nodo_lista->siguiente;
	}
	cont=0;
	inicio=0;
	for (;tag_line[cont]!='\t';cont++);
	tag_line[cont]=0;
	texto_rama=g_strdup_printf("%s",tag_line+inicio);
	cont++;
	inicio=cont;
	for (;tag_line[cont]!='\t';cont++);
	tag_line[cont]=0;
	archivo=g_strdup_printf("%s",tag_line+inicio);
	cont+=3;
	inicio=cont;
	for (;(tag_line[cont]!='\t') || (tag_line[cont-1]!='"') || (tag_line[cont-2]!=';') || (tag_line[cont-3]!='/') || (tag_line[cont-4]!='$');cont++);
	tag_line[cont-4]=0;
	definicion=g_strdup_printf("%s",tag_line+inicio);
	cont++;
	inicio=cont;
	tag_line[cont+1]=0;
	tipo=g_strdup_printf("%s",tag_line+inicio);

	nodo_lista->siguiente=NULL;
	nodo_lista->hijos=NULL;
	nodo_lista->archivo=archivo;
	nodo_lista->definicion=definicion;
	nodo_lista->rama=texto_rama;

	switch (tipo[0]) {
		case 'c':
			gtk_tree_store_append(cefv_store,&(nodo_lista->nodo),&cefv_clases);
			gtk_tree_store_set(cefv_store,&(nodo_lista->nodo),COL_ICONO,pixbufs[CLASES],COL_NOMBRE,nodo_lista->rama,-1);
			break;
		case 's':
			gtk_tree_store_append(cefv_store,&(nodo_lista->nodo),&cefv_estructuras);
			gtk_tree_store_set(cefv_store,&(nodo_lista->nodo),COL_ICONO,pixbufs[ESTRUCURAS],COL_NOMBRE,nodo_lista->rama,-1);
			break;
		case 'f':
			cefv_lista_combo=g_list_insert_sorted(cefv_lista_combo,g_strdup(nodo_lista->rama),(GCompareFunc)strcmp);
			gtk_tree_store_append(cefv_store,&(nodo_lista->nodo),&cefv_funciones);
			gtk_tree_store_set(cefv_store,&(nodo_lista->nodo),COL_ICONO,pixbufs[FUNCIONES],COL_NOMBRE,nodo_lista->rama,-1);
			break;
		case 'v':
			gtk_tree_store_append(cefv_store,&(nodo_lista->nodo),&cefv_bariables);
			gtk_tree_store_set(cefv_store,&(nodo_lista->nodo),COL_ICONO,pixbufs[BARIABLES],COL_NOMBRE,nodo_lista->rama,-1);
			break;
		case 'g':
			gtk_tree_store_append(cefv_store,&(nodo_lista->nodo),&cefv_enumeraciones);
			gtk_tree_store_set(cefv_store,&(nodo_lista->nodo),COL_ICONO,pixbufs[ENUMERACIONES],COL_NOMBRE,nodo_lista->rama,-1);
			break;
		case 'u':
			gtk_tree_store_append(cefv_store,&(nodo_lista->nodo),&cefv_uniones);
			gtk_tree_store_set(cefv_store,&(nodo_lista->nodo),COL_ICONO,pixbufs[UNIONES],COL_NOMBRE,nodo_lista->rama,-1);
			break;
		case 't':
			gtk_tree_store_append(cefv_store,&(nodo_lista->nodo),&cefv_tipos);
			gtk_tree_store_set(cefv_store,&(nodo_lista->nodo),COL_ICONO,pixbufs[TIPOS],COL_NOMBRE,nodo_lista->rama,-1);
			break;
		case 'm':
			g_free(nodo_lista->definicion);
			g_free(nodo_lista->archivo);
			nodo_lista->definicion=nodo_lista->anterior->definicion;
			nodo_lista->archivo=nodo_lista->anterior->archivo;
			gtk_tree_store_append(cefv_store,&(nodo_lista->nodo),&(nodo_lista->anterior->nodo));
			gtk_tree_store_set(cefv_store,&(nodo_lista->nodo),COL_ICONO,pixbufs[MIEMBRO],COL_NOMBRE,nodo_lista->rama,-1);
			nodo_lista->anterior->siguiente=NULL;
			nodo_lista->siguiente=nodo_lista->anterior->hijos;
			nodo_lista->anterior->hijos=nodo_lista;
			nodo_lista->anterior=NULL;
			if (nodo_lista->siguiente!=NULL) {
				nodo_lista->siguiente->anterior=nodo_lista;
			}
			break;
	}
	g_free(tipo);
}

/*******************************************************************************
 Analiza un archivo llamano a exuberant-ctags y aadiendo todas las entradas
 en el arbol cefv. "nombre" must be passed in UTF8
 *******************************************************************************/
int cefv_analizar_archivo(gchar *nombre)
{
	FILE *archivo,*tuberia;
	gchar *tags;
	gchar *tmp;
	gchar *comando;
	guint size;
	guint cont;
	guint comienzo_tag;
	gchar *tag;
	gint tipo;
	GtkWidget *combo;
     int retorno;
	gchar *nombre_locale;
	gsize read, written;
	GError *error;

	DEBUG_MSG(->cefv_analizar_archivo);
	
	if (!ejecutables.ctags) {
		DEBUG_MSG(<-cefv_analizar_archivo 2);
		return -1;
	}
	
	tipo=gen_tipo_archivo(nombre);
	if ((tipo==1) || (tipo==2)) {
		tmp=pro_nombre_completo_archivo(nombre,TRUE, UTF8);
		g_free(tmp);
		// nos aseguramos de que no exista un archibo tags
		retorno = remove ("tags");
		//we try exuberant-ctags and ctags, as the name is different depending on the distribution used.
		nombre_locale = g_locale_from_utf8(nombre, -1, &read, &written, &error);
		comando=g_strdup_printf("ctags-exuberant --excmd=p --c-types=-edn --sort=no %s 2> /dev/null",nombre_locale);
		tuberia=popen(comando,"r");
		pclose(tuberia);
		archivo=fopen("tags","r");
		if (archivo!=NULL) {
			fseek(archivo,0,SEEK_END);
			size=ftell(archivo);
		}
		if (archivo==NULL) {
			//"ctags-exuberant" did not work, we try now "ctags"
			retorno = remove ("tags");
			g_free(comando);
			comando=g_strdup_printf("ctags --excmd=p --c-types=-edn --sort=no %s 2> /dev/null",nombre_locale);
			tuberia=popen(comando,"r");
			pclose(tuberia);
			archivo=fopen("tags","r");
			if (archivo!=NULL) {
				fseek(archivo,0,SEEK_END);
				size=ftell(archivo);
			}
			if (archivo==NULL) {
				//Both calls failed, so exuberant-ctags is not installed or working correctly
				retorno = remove ("tags");
				//Aqui habra que poner una ventana advirtiendo al usuario que no tiene exuberant-ctags bien instalado
				g_printerr(_("An error ocurred while executing exuberant-ctags. DiaSCE can't work if exuberant-ctags doesn't work properly. Fix that problem before continuing using DiaSCE. The command lines use to call exuberant-ctags were:\nctags-exuberant --excmd=p --c-types=-edn --sort=no %s\nctags --excmd=p --c-types=-edn --sort=no %s\n"),nombre_locale,nombre_locale);
				g_free(comando);
				g_free(nombre_locale);
				DEBUG_MSG(<-cefv_analizar_archivo 1);
				return -1;
			}
		}
		g_free(comando);
		g_free(nombre_locale);
		tags=g_malloc(size);
		fseek(archivo,0,SEEK_SET);
		fread(tags,size,1,archivo);
		fclose(archivo);
		//ya no necesitamos el archivo tags, asi que lo borramos
		retorno = remove ("tags");
		
		cont=0;
		do {
			for (;(tags[cont]!='\n') && (cont<size);cont++);
			cont++;
		} while ((tags[cont]=='!') && (cont!=size));
		if (cont==size) {
			DEBUG_MSG(<-cefv_analizar_archivo);
			return 0;
		}
		
		cefv_eliminar_archivo(nombre);

		do {
			comienzo_tag=cont;
			for (;tags[cont]!='\n';cont++);
			tags[cont]=0;
			tag=g_strdup_printf("%s",tags+comienzo_tag);
			cefv_anadir(tag);
			g_free(tag);
			cont++;
		} while (cont!=size);
		g_free(tags);
	}

	if ((!cefv_congelar_lista_combo) && (cefv_lista_combo!=NULL)) {
		cefv_congelar_lista_combo=TRUE;
		combo=glade_xml_get_widget(david_ventana,"funciones_combo");
		gtk_combo_set_popdown_strings(GTK_COMBO(combo),cefv_lista_combo);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),"");
		cefv_congelar_lista_combo=FALSE;
	}

	DEBUG_MSG(<-cefv_analizar_archivo);
	return 0;
}

/*******************************************************************************
 Elimina todas las entradas correspondientes a un mismo archivo del
 arbol cefv
 *******************************************************************************/
void cefv_eliminar_archivo(gchar *nombre)
{
	struct s_lista_cefv *nodo_cefv,*eliminar,*hijos;
	GList *lista_combo;
	
	DEBUG_MSG(->cefv_eliminar_archivo);
	nodo_cefv=lista_cefv;
	while (nodo_cefv!=NULL) {
		if (!strcmp(nodo_cefv->archivo,nombre)) {
			eliminar=nodo_cefv;
			gtk_tree_store_remove(cefv_store,&(nodo_cefv->nodo));
			if (nodo_cefv->siguiente!=NULL) {
				nodo_cefv->siguiente->anterior=nodo_cefv->anterior;
			}
			if (nodo_cefv->anterior!=NULL) {
				nodo_cefv->anterior->siguiente=nodo_cefv->siguiente;
			} else {
				lista_cefv=nodo_cefv->siguiente;
			}
			g_free(nodo_cefv->definicion);
			
			lista_combo=g_list_find_custom(cefv_lista_combo,nodo_cefv->rama,(GCompareFunc)&strcasecmp);
			cefv_lista_combo=g_list_remove_link(cefv_lista_combo,lista_combo);
			g_list_free_1(lista_combo);
			
			g_free(nodo_cefv->rama);
			g_free(nodo_cefv->archivo);
			if (nodo_cefv->hijos!=NULL) {
				hijos=nodo_cefv->hijos;
				do {
					if (hijos->siguiente!=NULL) {
						g_free(hijos->rama);
						hijos=hijos->siguiente;
						g_free(hijos->anterior);
					} else {
						g_free(hijos->rama);
						g_free(hijos);
						hijos=NULL;
					}
				} while (hijos!=NULL);
				nodo_cefv->hijos=NULL;
			}
			nodo_cefv=nodo_cefv->siguiente;
			g_free(eliminar);
		} else {
			nodo_cefv=nodo_cefv->siguiente;
		}
	}
	DEBUG_MSG(<-cefv_eliminar_archivo);
}
