/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

#define PRIMER_PROYECTO_RECIENTE	7

//*******************************************************************

enum e_ayuda {GTK,XML,GLIB,ORBIT,GNOME,GNOMEUI,GNORBA,TOTAL_AYUDAS};

enum e_add_file {ADD_SOURCE,ADD_PIXMAP,ADD_DATA,ADD_DOC};

struct s_ejecutables {
	gboolean which;
	gboolean gcc;
	gboolean gdb;
	gboolean glade;
	gboolean ddd;
	gboolean memprof;
	gboolean make;
	gboolean aclocal;
	gboolean automake;
	gboolean autoconf;
	gboolean autoheader;
	gboolean ctags;
	gboolean lpr;
	gboolean grep;
	gboolean pkg_config;
	gboolean gnome_terminal;
	gboolean cvs;
} ejecutables;

gboolean separador_recientes;

gchar *prefix_automake;

GtkClipboard *gen_clipboard;

//*******************************************************************

void gen_salir(void);

void gen_cerrar_ventana(GtkWidget *widget);

void gen_anadir(gint destino);

guint gen_comando(gchar *comando,gchar *mensaje);

void gen_nuevo(GtkWidget *widget);

guint gen_tipo_archivo(gchar *nombre);

void gen_ayuda(enum e_ayuda ayuda);

void gen_eliminar(void);

void gen_cargar_proyecto(void);

void gen_recargar(void);

void gen_limpiar(void);

void gen_crear_proyecto(GtkWidget *widget);

void gen_abrir_proyecto(gchar *nombre);

void gen_mensajes_stderr(gchar *mensaje);

void gen_mensajes_stdout(gchar *mensaje);

void gen_limpiar_mensajes(void);

gboolean gen_existe_fichero(gchar *nombre);

void gen_anular_funciones(void);

void gen_ultimos_proyectos (void);

void gen_recent_project_open (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

gboolean gen_es_salida_grep(gchar *salida);

GtkWidget *gen_create_perdidas_ventana (void);

void gen_refrescar(void);

void gen_hijo_muerto(void);

gint gen_create_david_gui(void);

gint gen_GtkTreeIterCompareFunc(GtkTreeModel *model,GtkTreeIter *a,GtkTreeIter *b,gpointer user_data);

void gen_localizar_automake(void);

gint gen_load_stored_project_windows (void);

void gen_ventana_mensaje(gchar *mensaje,GtkMessageType tipo);

void gen_add_files_ventana(void);

void gen_anadir_a_lista(GtkWidget *widget);

gboolean gen_ventana_confirmacion(gchar *mensaje,GtkButtonsType botones);
