/*****************************************************************

  ddj.h

  Copyright (c) 1999 by Mike Oliphant - oliphant@ling.ed.ac.uk

    http://www.ling.ed.ac.uk/~oliphant/ddj

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

*****************************************************************/

#include <glib.h>

#define VERSION "0.6"

#define PROGRAM "DigitalDJ"

/* Random value in a range */

#define RRand(range) (random()%(range))

/* Song orders */

#define SONG_ORDER_RANDOM 0
#define SONG_ORDER_DISC 1
#define SONG_ORDER_OLDEST 2
#define SONG_ORDER_SLOWEST 3

/* BPM range */

#define LOW_BPM 0
#define HIGH_BPM 300

/* Speed catagories */

#define SLOW_BPM 60
#define MEDIUM_BPM 130
#define FAST_BPM 170


/* size of scrolling display window */

typedef struct _artist
{
  int id;
  char name[80];
} Artist;

typedef struct _disc
{
  int id;
  char title[80];
  int artistid;
  int year;
} Disc;

typedef struct _song
{
  int id;
  char filename[256];
  char title[80];
  int artistid;
  int discid;
  char genre[20];
  int track_num;
  int start_frame;
  int num_frames;
  int mins;
  int secs;
  int bpm;
  int year;
} Song;

/* Routines in mp3db.c */

void EscapeQuote(char *in,char *out,int maxlen);
gboolean ConnectSQL(void);
void DisconnectSQL(void);
gboolean SQLQuery(char *query);
gboolean InitSQL(char *rootpswd);
gboolean ReloadSQL(char *rootpswd);
gboolean MakeSQLUser(char *user,char *host,char *pswd,char *rootpswd);
gboolean DeleteSQLUser(char *user,char *host,char *rootpswd);
int AddSQLArtist(char *artist);
int AddSQLDisc(char *disc,int artistid,char *genre,int year);
int AddSQLEntry(char *filename,char *artist,char *sartist,char *title,
		char *disc_name,char *genre,int year,
		int track_num,int start_frame,int num_frames,int mins,
		int secs,int bpm);
gboolean DeleteSongByID(int id);

/* Routines in mp3.c */

#ifdef BUILTIN_MP3
gboolean MP3Init(void);
void MP3CleanUp(void);
gboolean PlayMP3(char *fname);
#endif
