/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __SCALE_INFO
#define __SCALE_INFO

#include <string>
#include <vector>
#include <map>

struct scale_info {

  std::string name; // name of scale

  float lo_tonic, tonic, hi_tonic;

  std::map <std::string, float> intervals; // custom intervals for this scale

  std::vector<std::string> notes; // notes of the scale
  int num_ranges; // number of tone ranges (see range.h)
  int last_range;


  scale_info () {
    num_ranges = 0;
    last_range = -1;
    intervals.clear ();
  }

  void load_last ();
  void save_last ();

  bool set_tonic (float s);
  bool set_scale (const std::string& n);

  bool load_custom_tuning ();
  void save_custom_tuning ();


};

#endif
