#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <gnome.h>
#include "appglobals.h"
#include "appsupport.h"
#include "prefs.h"

void
load_prefs (void)
{

  FILE *fd;
  gchar buf[1024];
  gchar **split = NULL;
  gchar *homedir = NULL;
  gchar *cfgfile = NULL;
  connection_profile *connprof = NULL;

  homedir = g_get_home_dir ();

/*
   this reads user creation defaults
   this is also supposed to be read with a lexical scanner from
   /etc/login.defs
*/
  preferences.logindefaults.PASS_MIN_DAYS = 0;
  preferences.logindefaults.PASS_MAX_DAYS = 30;
  preferences.logindefaults.PASS_WARN_AGE = 7;
  preferences.logindefaults.PASS_INACTIVE_AGE = 2;
  preferences.logindefaults.PASS_MIN_LEN = 5;
  preferences.logindefaults.VUID_MIN = 1000;
  preferences.logindefaults.VUID_MAX = 60000;
  preferences.logindefaults.VGID_MIN = 1000;
  preferences.logindefaults.VGID_MAX = 60000;



/*
   this reads available shells
   this is read from /etc/shells, but zeroed first
*/


  preferences.logindefaults.shells = NULL;

  //now reading shells
  fd = fopen ("/etc/shells", "r");
  if (fd)
    {
      while (fgets (buf, sizeof (buf), fd) != NULL)
	{
	  // Skip comments and empty lines...
	  if (*buf == '\n' || *buf == '#')
	    continue;

	  // Remove newline at the end...
	  buf[strlen (buf) - 1] = '\0';

	  preferences.logindefaults.shells =
	    g_list_append (preferences.logindefaults.shells, g_strdup (buf));
	}
      fclose (fd);
    }

  /* this sets the password format by defaulty */
  preferences.passwordcrypttype = CLEARTEXT;

  //now reading password crypt type
  cfgfile =
    g_strconcat (homedir, "/.directory_administrator/crypttype", NULL);
  fd = fopen (cfgfile, "r");
  if (fd)
    {
      if (fgets (buf, sizeof (buf), fd) != NULL)
	{

	  g_print (buf);
	  if (strcasecmp (buf, "CLEARTEXT") == 0)
	    {
	      g_print ("\nSetting password crypt type to cleartext\n");
	      preferences.passwordcrypttype = CLEARTEXT;
	    }
	  if (strcasecmp (buf, "CRYPT") == 0)
	    {
	      g_print ("\nSetting password crypt type to crypt\n");
	      preferences.passwordcrypttype = CRYPT;
	    }
	  if (strcasecmp (buf, "MD5") == 0)
	    {
	      g_print ("\nSetting password crypt type to md5sum\n");
	      preferences.passwordcrypttype = MD5;
	    }

	}
      else
	{
	  perror ("hola");
	}
      fclose (fd);
    }


  connection_profile_list = NULL;

// now scanning profile config file
  cfgfile = g_strconcat (homedir, "/.directory_administrator/profiles", NULL);
  fd = fopen (cfgfile, "r");
  if (fd)
    {
      while (!feof (fd))
	{
	  while (fgets (buf, sizeof (buf), fd))
	    {
	      if (*buf == '\n' || *buf == '#')
		continue;
	      buf[strlen (buf) - 1] = '\0';
	      split = g_strsplit (buf, "|", 0);
	      connprof =
		connection_profile_new (split[0], split[1],
					split[2], split[3], split[4]);
	      if (split[4])
		{
		  if (split[5])
		    {
		      connection_profile_set_last_user_ou (connprof,
							   split[5]);
		      if (split[6])
			connection_profile_set_last_group_ou (connprof,
							      split[6]);
		    }
		}
	      connection_profile_list =
		g_list_append (connection_profile_list, connprof);
	      g_strfreev (split);
	    }
	}
      fclose (fd);
    }
  g_free (cfgfile);

  current_connection_profile = NULL;

  if (preferences.passwordcrypttype == CLEARTEXT)
    g_print ("\nread password crypt type: cleartext\n");
  if (preferences.passwordcrypttype == CRYPT)
    g_print ("\nread password crypt type: crypt\n");
  if (preferences.passwordcrypttype == MD5)
    g_print ("\nread password crypt type: md5sum\n");

}


void
save_prefs (void)
{

  FILE *fd;
  int dd;
  struct stat *statbuf = NULL;
  gchar *homedir = NULL;
  gchar *cfgfile = NULL;

  GList *loopix = NULL;

  homedir = g_get_home_dir ();

  cfgfile = g_strconcat (homedir, "/.directory_administrator", NULL);
  statbuf = g_new (struct stat, 1);
  dd = stat (cfgfile, statbuf);
  if (dd)
    {
      if (errno == ENOENT)
	{
	  mkdir (cfgfile, 0700);
	}
      else
	{
	  perror ("while saving preferences: opendir failed");
	  exit (1);
	}
    }
  g_free (statbuf);
  g_free (cfgfile);

  //now saving profile list
  cfgfile = g_strconcat (homedir, "/.directory_administrator/profiles", NULL);
  loopix = g_list_first (connection_profile_list);
  fd = fopen (cfgfile, "w");
  if (fd)
    {
      while (loopix)
	{
	  if (connection_profile_get_name (loopix->data))
	    fprintf (fd, "%s", connection_profile_get_name (loopix->data));
	  fprintf (fd, "|");
	  if (connection_profile_get_dn (loopix->data))
	    fprintf (fd, "%s", connection_profile_get_dn (loopix->data));
	  fprintf (fd, "|");
	  if (connection_profile_get_password (loopix->data))
	    fprintf (fd, "%s",
		     connection_profile_get_password (loopix->data));
	  fprintf (fd, "|");
	  if (connection_profile_get_server (loopix->data))
	    fprintf (fd, "%s", connection_profile_get_server (loopix->data));
	  fprintf (fd, "|");
	  if (connection_profile_get_treeroot (loopix->data))
	    fprintf (fd, "%s",
		     connection_profile_get_treeroot (loopix->data));
	  fprintf (fd, "|");
	  if (connection_profile_get_last_user_ou (loopix->data))
	    fprintf (fd, "%s",
		     connection_profile_get_last_user_ou (loopix->data));
	  fprintf (fd, "|");
	  if (connection_profile_get_last_group_ou (loopix->data))
	    fprintf (fd, "%s",
		     connection_profile_get_last_group_ou (loopix->data));
	  fprintf (fd, "\n");
	  loopix = g_list_next (loopix);
	}
      fclose (fd);
    }
  g_free (cfgfile);

  //now saving password crypt type
  cfgfile =
    g_strconcat (homedir, "/.directory_administrator/crypttype", NULL);
  loopix = g_list_first (connection_profile_list);
  fd = fopen (cfgfile, "w");
  if (fd)
    {
      if (preferences.passwordcrypttype == MD5)
	fprintf (fd, "MD5");
      if (preferences.passwordcrypttype == CLEARTEXT)
	fprintf (fd, "CLEARTEXT");
      if (preferences.passwordcrypttype == CRYPT)
	fprintf (fd, "CRYPT");
    }
  g_free (cfgfile);

  if (preferences.passwordcrypttype == CLEARTEXT)
    g_print ("\nwrote password crypt type: cleartext\n");
  if (preferences.passwordcrypttype == CRYPT)
    g_print ("\nwrote password crypt type: crypt\n");
  if (preferences.passwordcrypttype == MD5)
    g_print ("\nwrote password crypt type: md5sum\n");

}


//this function saves the preference changes of the dialog in memory
//returns TRUE if everything went okay
//returns FALSE in case there is a format or something else error
gboolean
process_preferences_dialog (GnomeDialog * gnomedialog)
{

  GtkWidget *dialogbox = GTK_WIDGET (gnomedialog);

  g_print ("\nCalled process preferences dialog\n");

  // saving modifications
  if (GTK_TOGGLE_BUTTON (lookup_widget (dialogbox, "pass_cleartext"))->active)
    {
      g_print ("password type: cleartext");
      preferences.passwordcrypttype = CLEARTEXT;
    }
  if (GTK_TOGGLE_BUTTON (lookup_widget (dialogbox, "pass_crypt"))->active)
    {
      g_print ("password type: crypt");
      preferences.passwordcrypttype = CRYPT;
    }
  if (GTK_TOGGLE_BUTTON (lookup_widget (dialogbox, "pass_md5"))->active)
    {
      g_print ("password type: md5sum");
      preferences.passwordcrypttype = MD5;
    }

  return (TRUE);
}
