/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it 
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be 
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/


#include <string.h>
#include <glib.h>
#include <lber.h>
#include <ldap.h>

#ifndef __profile_h_defined
#define __profile_h_defined 1

/*
 * Work around versions of the LDAP client libs that don't have the OIDs
 * defined, or have them defined under the old name.  
 * This functionality is really a factor of the server, not the client 
 *
 */

#if defined(LDAP_EXOP_X_MODIFY_PASSWD) && !defined(LDAP_EXOP_MODIFY_PASSWD)
#define LDAP_EXOP_MODIFY_PASSWD LDAP_EXOP_X_MODIFY_PASSWD
#elif !defined(LDAP_EXOP_MODIFY_PASSWD)
#define LDAP_EXOP_MODIFY_PASSWD "1.3.6.1.4.1.4203.1.11.1"
#endif

#if defined(LDAP_EXOP_X_MODIFY_PASSWD_ID) && !defined(LDAP_EXOP_MODIFY_PASSWD_ID)
#define LDAP_TAG_EXOP_MODIFY_PASSWD_ID LDAP_EXOP_X_MODIFY_PASSWD_ID
#elif !defined(LDAP_EXOP_MODIFY_PASSWD_ID)
#define LDAP_TAG_EXOP_MODIFY_PASSWD_ID        ((ber_tag_t) 0x80U)
#endif
 
#if defined(LDAP_EXOP_X_MODIFY_PASSWD_NEW) && !defined(LDAP_EXOP_MODIFY_PASSWD_NEW)
#define LDAP_TAG_EXOP_MODIFY_PASSWD_NEW LDAP_EXOP_X_MODIFY_PASSWD_NEW
#elif !defined(LDAP_EXOP_MODIFY_PASSWD_NEW)
#define LDAP_TAG_EXOP_MODIFY_PASSWD_NEW       ((ber_tag_t) 0x82U)
#endif


typedef struct _connection_profile
{
  gchar *name;
  gchar *dn;
  gchar *pw;
  gchar *server;
  gchar *treeroot;
  gint tls;
  LDAP *connid;
  gchar *lastuserou;
  gchar *lastgroupou;
}
connection_profile;

connection_profile *connection_profile_new (gchar * name, gchar * dn,
					    gchar * pw, gchar * server,
					    gint tls, gchar * treeroot);
connection_profile *connection_profile_duplicate (connection_profile *
						  tobeduped);
void connection_profile_destroy (connection_profile * todestroy);
void connection_profile_set_name (connection_profile * conn, gchar * name);
void connection_profile_set_dn (connection_profile * conn, gchar * dn);
void connection_profile_set_password (connection_profile * conn, gchar * pw);
void connection_profile_set_server (connection_profile * conn,
				    gchar * server);
void connection_profile_set_treeroot (connection_profile * conn,
				      gchar * treeroot);

gchar *connection_profile_get_name (connection_profile * conn);
gchar *connection_profile_get_server (connection_profile * conn);
gint connection_profile_get_tls (connection_profile * conn);
gchar *connection_profile_get_dn (connection_profile * conn);
gchar *connection_profile_get_password (connection_profile * conn);
gchar *connection_profile_get_treeroot (connection_profile * conn);
LDAP *connection_profile_get_ldap_handler (connection_profile * conn);
void connection_profile_disconnect (connection_profile * conn);
gboolean connection_profile_is_connected (connection_profile * conn);
int connection_profile_connect (connection_profile * conn);

void connection_profile_set_last_user_ou (connection_profile * conn, gchar * ou);
void connection_profile_set_last_group_ou (connection_profile * conn, gchar * ou);
gchar *connection_profile_get_last_user_ou (connection_profile * conn);
gchar *connection_profile_get_last_group_ou (connection_profile * conn);


connection_profile *connection_profile_list_getbyname (GList * connec,
						       gchar * nombre);
GList *connection_profile_list_remove (GList * connec,
				       connection_profile * nombre);
GList *connection_profile_list_add (GList * connec,
				    connection_profile * nombre);

void dump_mods (LDAPMod ** mods);

int connection_profile_commit_modifications (connection_profile * conn,
					     LDAPMod ** modifications,
					     char *dn);
int connection_profile_commit_password (connection_profile * conn,
					 gchar *password, gchar *dn, gchar **warning);
int connection_profile_create_record (connection_profile * conn,
				      LDAPMod ** modifications, char *dn);

void connection_profile_invalidate(connection_profile * d);

#endif

