/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "discover.h"
#include "utils.h"


extern struct ethernet_info *ethernet_detect(struct bus_lst *bus){
  struct pci_info *pci = (struct pci_info *)NULL;
  struct isa_info *isa = (struct isa_info *)NULL;
  struct pcmcia_info *pcmcia = (struct pcmcia_info *)NULL;
  struct ethernet_info *result = (struct ethernet_info *)NULL;
  static struct ethernet_info *first = (struct ethernet_info *)NULL;
  
#if defined(__PPC__)
  FILE *fd;
  char *line;
  char *file;
  char *folder;
  size_t len = 0;
  char *ppc_dev;
  int i;

  char *ppc_ethernet_dev[] = {
    "/proc/device-tree/aliases/enet",
    NULL
  };
#endif

  if(first){
    return first;
  }/*endif*/
  
  if(debug)
    printf(_("\nProbing ethernet card...\n"));

  
  /********************************************************************/
  /******************* PCI ETHERNET CARD DETECTION ********************/
  /********************************************************************/
  if(debug)
    printf(_("\tProbing PCI ethernet card...\n"));

  
  for(pci = bus->pci; pci; pci = pci->next){
    if(pci->type == ETHERNETCARD){
      if(!first){
        first = result = (struct ethernet_info *) 
                                my_malloc(sizeof(struct ethernet_info));
      }else{
        result->next = (struct ethernet_info *) 
                                my_malloc(sizeof(struct ethernet_info));
        result = result->next;
      }/*endif*/
      result->next = (struct ethernet_info *)NULL;
      result->vendor = pci->vendor;
      result->model = pci->model;
      result->module = pci->modulename;
      result->long_id = pci->id;
      result->bus = PCI;
      if(debug)
	printf(_("\t\tFound %s %s\n"), 
	       result->vendor, result->model);
    }/*endif*/
  }/*next pci*/
  
  /********************************************************************/
  /******************* ISA ETHERNET CARD DETECTION ********************/
  /********************************************************************/
  if(debug)
    printf(_("\tProbing ISA ethernet card...\n"));
  
  for(isa = bus->isa; isa; isa = isa->next){
    if(isa->type == ETHERNETCARD){
      if(!first){
        first = result = (struct ethernet_info *) 
                                my_malloc(sizeof(struct ethernet_info));
      }else{
        result->next = (struct ethernet_info *) 
                                my_malloc(sizeof(struct ethernet_info));
        result = result->next;
      }/*endif*/
      result->next = (struct ethernet_info *)NULL;
      
      result->board_num = isa->board_num;
      result->board_id =  isa->board_id;
      result->dev_id = isa->dev_id;
      result->dev_num= isa->dev_num;
      result->vendor = isa->vendor;
      result->model = isa->model;
      result->module = isa->modulename;
      result->io = isa->io;
      result->irq = isa->irq;
      result->bus = ISA;
      
      if(debug)
	printf(("\t\tFound %s %s\n"), 
		result->vendor, result->model);
    }/*endif*/
  }/*next isa*/
  
  
  /********************************************************************/
  /****************** PCMCIA ETHERNET CARD DETECTION ******************/
  /********************************************************************/
  if(debug)
    printf(_("\tProbing PCMCIA ethernet card...\n"));

  for(pcmcia = bus->pcmcia; pcmcia; pcmcia = pcmcia->next){
    if(pcmcia->type == ETHERNETCARD){
      if(!first){
        first = result = (struct ethernet_info *) 
                                my_malloc(sizeof(struct ethernet_info));
      }else{
        result->next = (struct ethernet_info *) 
                                my_malloc(sizeof(struct ethernet_info));
          result = result->next;
      }/*endif*/
      result->next = (struct ethernet_info *)NULL;

      result->vendor = pcmcia->vendor;
      result->model = pcmcia->model;
      result->module = pcmcia->modulename;
      result->long_id = pcmcia->id;	
      result->bus = PCMCIA;
      if(debug)
	printf(_("\t\tFound %s %s\n"), 
	       result->vendor, result->model);
    }/*endif*/
  }/*next pcmcia*/
  
#if defined(__PPC__)
  /********************************************************************/
  /*************** PowerPC ETHERNET-INTERFACE DETECTION ***************/
  /********************************************************************/
  if(debug)
    printf(_("\tProbing PowerPC interface...\n"));

  i = 0;
  for(ppc_dev = ppc_ethernet_dev[i]; ppc_dev != NULL;
                                    i++, ppc_dev = ppc_ethernet_dev[i]){
    fd = fopen(ppc_dev, "r");
    if(fd == (FILE *)NULL){
      if(debug)
	fprintf(stderr, FOPEN_READ_ERROR, ppc_dev);
    }else{
      line = 0; len = 0;
      getline(&line, &len, fd);
      fclose(fd);
      folder = my_malloc((sizeof(line) * strlen(line) + 20));
      sprintf(folder, "%s%s", "/proc/device-tree", line);
      if(!first){
        first = result = (struct ethernet_info *)
                              my_malloc((sizeof(struct ethernet_info)));
      }else{
        result->next = (struct ethernet_info *)
                              my_malloc((sizeof(struct ethernet_info)));
        result = result->next;
      }/*endif*/
      result->next = (struct ethernet_info *)NULL;

      result->vendor = "Apple";
      result->id = 0;
      result->bus = UNKNOWN_BUS;

      file = my_malloc(sizeof(folder) * strlen(folder) + 15);
      sprintf(file, "%s/model", folder);
      fd = fopen(file, "r");
      if(fd == (FILE *)NULL){
	if(debug)
	  fprintf(stderr, FOPEN_READ_ERROR, file);
        result->model = s_unknown;
      }else{
        getline(&line, &len, fd);
        result->model = my_malloc(sizeof(line) * strlen(line) + 1);
        strcpy(result->model, line);
        fclose(fd);
      }/*endif*/
      sprintf(file, "%s/name", folder);
      fd = fopen(file, "r");
      if(fd == (FILE *)NULL){
	if(debug)
	  fprintf(stderr, FOPEN_READ_ERROR, file);
        result->module = s_unknown;
      }else{
        getline(&line, &len, fd);
        result->module = my_malloc(sizeof(line) * strlen(line) + 1);
        strcpy(result->module, line);
        fclose(fd);
      }/*endif*/

      if(debug)
	printf(_("\t\tFound %s %s\n"),
	       result->vendor, result->model);
      free(line); line=0;
      free(file); file=0;
    }/*endif*/
  }/*next ppc_dev*/
#endif

  return first;
}/*endfunc ethernet_detect*/
