#ifndef SERIAL_H
#define SERIAL_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <termios.h>
#include <errno.h>
#include <signal.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

/* character strings ARE null-terminated in the following structure   */
/* these elements are marked with a (string) in the comment           */
/* If PnP device sent 6 bit data stream, we've xlated by a 0x20       */
/* offset. When computing checksum, must remove this offset           */
struct pnp_com_id {
  unsigned char xlate_6bit;      /* does this contain xlated data     */
  unsigned char other_id[17];    /* backward compatibility with pre-PNP */
  unsigned char other_len;       /* length of the other_id            */
  unsigned char pnp_rev[2];      /* PnP revision bytes                */
  unsigned char pnp_rev_str[8];  /* PnP revision (s version)          */
  unsigned char eisa_id[4];      /* EISA Mfr identifier (s)           */
  unsigned char product_id[5];   /* Mfr determined product ID (s)     */
  unsigned char serial_number[9];/* Optional dev serial number (s)    */
  unsigned char class_name[33];  /* Optional PnP Class name (s)       */
  unsigned char driver_id[42];   /* Optional compat device IDs (s)    */
  unsigned char user_name[42];   /* Optional verbose product descr (s)*/
  unsigned char checksum[2];     /* Optional checksum                 */
};

/* Set of functions used by modem and mouse detection                 */
extern int wait_for_input(int fd, struct timeval *timo);
extern int open_serial_port(char *port);
extern int close_serial_port(int fd);
extern int get_serial_lines(int fd);
extern int set_serial_lines(int fd, int modem_lines);
extern int get_serial_attr(int fd, struct termios *attr);
extern int set_serial_attr(int fd, struct termios *attr);
extern int setup_serial_port(int fd, int nbits, struct termios *attr);
extern struct termios *init_serial_port(int fd);
extern int parse_pnp_string(unsigned char *pnp_id_string, int pnp_len, 
                            struct pnp_com_id *pnp_id );
void print_pnp_id(struct pnp_com_id id);

extern int find_legacy_modem(int fd);
extern short modem_capabilities(int fd);
extern long modem_speed(int fd);
extern char *modem_response(int fd, char *send);
#endif

