#ifndef _CACHE_H_INCLUDED
#define _CACHE_H_INCLUDED

#include <qvaluelist.h>
#include <qstring.h>

class CacheItem
{
public:
	CacheItem(QString path, int bpm, int length);
	CacheItem();
	CacheItem(const CacheItem& source);
	~CacheItem();
	CacheItem& operator= (const CacheItem& source);

	QString path;
	int bpm;
	int length;
};

class Cache
{
public:
	Cache();
	~Cache();

	void add(QString path, int bpm, int length);
	CacheItem find(QString path);
	void remove(QString path);
protected:
	QValueList<CacheItem> list;
};
#endif
