#include "dirview.h"

#include <stdio.h>
#include "scanthread.h"

DirViewItem::DirViewItem(QListView *parent, QString text, bool is_dir) : QListViewItem(parent, text)
{
	isdir=is_dir;
	s_new=false;
	s_played=false;
	s_current=false;
}

DirViewItem::~DirViewItem()
{
	if(scan.thread())
		scan.thread()->removeFile(scan);
}

void DirViewItem::setScanItem(ScanItem item)
{
	scan=item;
}

QString DirViewItem::key(int column, bool ascending) const
{
	if(isdir)
	{
		if(text(0) == "..")
			return (QString)"0"+text(column);
		else
			return (QString)"1"+text(column);
	}
	else
		return (QString)"2"+text(column);

}

bool DirViewItem::isDir()
{
	return isdir;
}

void DirViewItem::paintCell ( QPainter *p, const QColorGroup & cg, int column, int width, int alignment )
{
    QColorGroup ccg=cg;
    if(s_current)
    {
        ccg.setColor(QColorGroup::Text, QColor(255, 0, 0));
        ccg.setColor(QColorGroup::Highlight, QColor(255, 0, 0));
    }
    if(s_new)
    {
        ccg.setColor(QColorGroup::Base, QColor(222, 222, 222));
        ccg.setColor(QColorGroup::Highlight, QColor(128, 128, 255));
        ccg.setColor(QColorGroup::HighlightedText, QColor(255, 255, 255));
    }
    if(s_played)
    {
        ccg.setColor(QColorGroup::Text, QColor(128, 128, 128));
        ccg.setColor(QColorGroup::HighlightedText, QColor(222, 222, 222));
    }

    QListViewItem::paintCell ( p, ccg, column, width, alignment );
}

void DirViewItem::setCurrent()
{
	s_current=true;
	s_played=false;
	s_new=false;
	listView()->repaintItem(this);
}

void DirViewItem::setRecent()
{
	s_current=false;
	s_played=false;
	s_new=true;
	listView()->repaintItem(this);
}

void DirViewItem::setPlayed()
{
	s_current=false;
	s_played=true;
	s_new=false;
	listView()->repaintItem(this);
}

bool DirViewItem::played()
{
	return s_played;
}

bool DirViewItem::recent()
{
	return s_new;
}

bool DirViewItem::current()
{
	return s_current;
}

ScanItem DirViewItem::scanItem()
{
	return scan;
}

bool DirViewItem::normal()
{
	if(!s_new && !s_current && !s_played)
		return true;
	return false;
}

void DirViewItem::setNormal()
{
	s_current=false;
	s_played=false;
	s_new=false;
	listView()->repaintItem(this);
}
