#include "config.h"
#include "playerlist.h"
#include <qlistview.h>
#include <dirent.h>
#include "dirview.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <qpixmap.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <qtabwidget.h>
#include <ctype.h>
#include <qfileinfo.h>
#include <qpopupmenu.h>
#include <qmessagebox.h>
#include "playlist.h"
#ifdef HAVE_QOBJECTLIST_H
#include <qobjectlist.h>
#else
#ifdef HAVE_QOBJCOLL_H
#include <qobjcoll.h>
#else
#error "Your QT has neither qobjcoll.h nor qobjectlist.h"
#endif
#endif
#include "dragsort.h"

#include "dir.xpm"
#include "file.xpm"
#include "up.xpm"

void PlayerList::resizeEvent(QResizeEvent *e)
{
	lv->resize(e->size().width()-10, e->size().height()-10);
	lv->setColumnWidth(0, e->size().width()-174);
	lv->setColumnWidth(1, 70);
	lv->setColumnWidth(2, 70);
	lv->repaint();
}

PlayerList::PlayerList(QWidget *parent, Playlist *pl, const char *name, WFlags f) : VirList(parent, pl, name, f)
{
	current_song[0]=current_song[1]=0;
	p_dir=new QPixmap((const char **)dir_xpm);
	p_file=new QPixmap((const char **)file_xpm);
	p_up=new QPixmap((const char **)up_xpm);
	dir="";
	lv=new DragSortList(this);
	lv->move(5, 5);
	lv->addColumn(dir);
	lv->addColumn("BPM");
	lv->addColumn("Time");
	lv->setColumnWidthMode(0, QListView::Manual);
	lv->setAllColumnsShowFocus(true);
	lv->setColumnAlignment(1, AlignRight);
	lv->setColumnAlignment(2, AlignRight);
	lv->setSelectionMode(QListView::Extended);

	connect(lv, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(lv_doubleClicked(QListViewItem *)));
	connect(lv, SIGNAL(rightButtonPressed(QListViewItem *, const QPoint&, int)), this, SLOT(lv_rightClicked(QListViewItem *, const QPoint&, int)));
}

void PlayerList::load()
{
	if(file == "" || file == QString::null)
		return;

	pl->scanThread()->pause(true);
	QFileInfo info(file);
	if(info.exists())
	{
		FILE *fp=fopen(file, "r");
		if(!fp)
			return;

		char buf[2048];
		while(fgets(buf, sizeof(buf), fp) && !feof(fp))
		{
			char *x=strchr(buf, '\n');
			if(x)
				*x='\0';
			addFile(buf, false);
		}
		fclose(fp);
	}
	else
	{
		int fd=open(file, O_CREAT | O_WRONLY, 0644);
		if(fd >= 0)
			close(fd);
	}
	pl->scanThread()->pause(false);
	save();
}

PlayerList::~PlayerList()
{
	save();
	pl->scanThread()->removeList(this);
}

void PlayerList::lv_doubleClicked(QListViewItem *it)
{
	if(it)
	{
		((DirViewItem *)it)->setCurrent();
		lv->clearSelection();
		lv->setSelected(it, true);
		lv->setCurrentItem(it);
	}
	pl->doubleClick();
}

void PlayerList::setDir(QString i_dir)
{
}

QString PlayerList::getDir()
{
	return "";
}

void PlayerList::setFile(QString i_file)
{
	file=i_file;
	load();
}

void PlayerList::lv_rightClicked(QListViewItem *it, const QPoint& pos, int col)
{
	if(!it)
		return;
	QPopupMenu *menu=new QPopupMenu(this);
	menu->insertItem("Load left", pl, SLOT(left_clicked()));
	menu->insertItem("Load right", pl, SLOT(right_clicked()));
	menu->insertSeparator();
	menu->insertItem("Remove", this, SLOT(removeItem()));
	menu->insertSeparator();
	QPopupMenu *flagmenu=new QPopupMenu(menu);
	flagmenu->insertItem("Unplayed", this, SLOT(flagUnplayed()));
	flagmenu->insertItem("Played", this, SLOT(flagPlayed()));
	menu->insertItem("Flag", flagmenu);

    QObjectList *ch=parent()->queryList("VirList");
    if(ch)
    {
        if(ch->count())
        {
            menu->insertSeparator();
            QPopupMenu *submenu=new QPopupMenu(menu);

            QObjectListIt i(*ch);
            QObject *obj;
            while((obj=i.current()) != 0)
            {
                ++i;
                PlayerList *list=(PlayerList *)obj;
                int id=submenu->insertItem(list->getTitle(), this, SLOT(moveToList(int)));
                submenu->setItemParameter(id, (long)list);
            }
            menu->insertItem("Send to", submenu);
        }
    }
	menu->insertItem("Select all", this, SLOT(selectAll()));
    delete ch;

	menu->popup(pos);
}

void PlayerList::removeItem()
{
	QList<QListViewItem> l;
	l.setAutoDelete(true);
	QListViewItem *it=lv->firstChild();
	while(it)
	{
		if(it->isSelected())
			l.append(it);
		it=it->nextSibling();
	}
	if(l.count() == 0)
		return;
	int cc=QMessageBox::warning(this, "Remove", "Really remove item(s) from playlist?", "Yes", "No", 0, 0, 1);
	if(cc != 0)
	{
		l.setAutoDelete(false);
		return;
	}
	
	for(it=l.first();it;it=l.next())
	{
		if(current_song[0] == it)
			current_song[0]=0;
		if(current_song[1] == it)
			current_song[1]=0;
		pl->scanThread()->removeFile(((DirViewItem *)it)->scanItem());
	}
	l.clear();
	save();
}

void PlayerList::save()
{
	if(file == "" || file == QString::null)
		return;

	FILE *fp=fopen(file, "w");

	if(!fp)
	{
		QMessageBox::warning(this, "Error", "Cannot save file", "OK", 0, 0, 0, 0);
		return;
	}

	QListViewItem *it=lv->firstChild();
	while(it)
	{
		if(it->text(3).left(7) != "cdda://")
			fprintf(fp, "%s\n", (const char *)it->text(3));
		it=it->nextSibling();
	}
	fclose(fp);
}

void PlayerList::addFile(QString a_file, bool s)
{
    DirViewItem *it=(DirViewItem *)lv->firstChild();
	DirViewItem *insert_after=0;
    while(it)
    {
//        if(it->text(3) == a_file)
//            return;
		insert_after=it;
        it=(DirViewItem *)it->nextSibling();
    }
	QFileInfo info(a_file);
	it=new DirViewItem(lv, info.fileName(), false);
	if(insert_after)
		it->moveItem(insert_after);
	it->setRecent();
	it->setPixmap(0, *p_file);
	it->setText(3, a_file);
	it->setScanItem(ScanItem(pl->scanThread(), this, a_file, it));
	pl->scanThread()->addFile(this, a_file, it);
	if(s)
		save();
}

void PlayerList::moveToList(int arg)
{
    List *list=(List *)arg;
    if(!list)
        return;

    QListViewItem *it=lv->firstChild();
	while(it)
	{
		if(it->isSelected())
		{
			QString path=it->text(3);
			list->addFile(path);
		}
		it=it->nextSibling();
	}
}

QString PlayerList::getSelectedFile()
{
    DirViewItem *item=(DirViewItem *)lv->currentItem();
    if(!item)
        return QString::null;
    QString path=item->text(3);
    return path;
}

void PlayerList::setCurrentSong(int player)
{
	if(current_song[player-1] && current_song[player-1] != current_song[1-(player -1)])
		current_song[player-1]->setPlayed();
	current_song[player-1]=(DirViewItem *)lv->currentItem();
	current_song[player-1]->setCurrent();
}

void PlayerList::clearCurrentSong(int player)
{
	if(current_song[player-1] && current_song[player-1] != current_song[1-(player -1)])
		current_song[player-1]->setPlayed();
	current_song[player-1]=0;
}

bool PlayerList::selectFirstUnplayed()
{
	DirViewItem *it=(DirViewItem *)lv->firstChild();
	lv->clearSelection();
	while(it)
	{
		if(!it->played() && !it->current())
		{
			lv->setSelected(it, true);
			lv->setCurrentItem(it);
			return true;
		}
		it=(DirViewItem *)it->nextSibling();
	}
	return false;
}

bool PlayerList::selectRandomUnplayed()
{
	QValueList<DirViewItem*> slist;

	DirViewItem *it=(DirViewItem *)lv->firstChild();
	lv->clearSelection();
	while(it)
	{
		if(!it->played() && !it->current())
		{
			slist.append(it);
		}
		it=(DirViewItem *)it->nextSibling();
	}
	if(!slist.count())
		return false;
	
	int rnd=rand()%slist.count();
	it=slist[rnd];
	lv->setSelected(it, true);
	lv->setCurrentItem(it);
	return true;
}

void PlayerList::flagUnplayed()
{
	DirViewItem *it=(DirViewItem *)lv->firstChild();
	while(it)
	{
		if(it->isSelected())
			if(it->played())
				it->setNormal();
		it=(DirViewItem *)it->nextSibling();
	}
}

void PlayerList::flagPlayed()
{
	DirViewItem *it=(DirViewItem *)lv->firstChild();
	while(it)
	{
		if(it->isSelected())
			if(!it->played())
				it->setPlayed();
		it=(DirViewItem *)it->nextSibling();
	}
}

