/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*
 * sockets related libraries, easy-handling routines.
 * $Id: libsocket.c,v 1.10 2001/12/09 12:57:24 dancer Exp $
 * 2001-8-17 dancer Added CVS id tag.
 */
/* nicked off pieces of code from :
 * nantarad client... obtains information from nantarad, and returns 
 * the value obtained to stdout and exit value.
 * on error, returns EXIT_FAILURE on normal failure, and -1 on 
 * more obscure failures.
 *
 * originally a Telnet clone which does little input/output cooking.
 * 2001 Feb 28 Junichi Uekawa <dancer@debian.org>
 * 2001 Mar 4 Junichi Uekawa <dancer@debian.org> reuse for nantaraclient
 * copyright 2001 Junichi Uekawa
 * See GPL version 2 or later for license.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <pthread.h>
#include "dmachinemon/libsocket.h"
#define BACKLOG 20

/**
   Make a TCP connection to host.
 */
int
dm_connect_to_host(const char * stringaddress, /// Hostname
		   int portnumber /// Port number
		   )
{
  struct sockaddr_in inet_address;
  struct hostent * hostinfo ;
  int sock;
    
  sock = socket (PF_INET, SOCK_STREAM, 0);
  
  inet_address.sin_family = AF_INET;
  inet_address.sin_port = htons(portnumber);
  hostinfo = gethostbyname(stringaddress);
  if (hostinfo == NULL)
    {
      fprintf(stderr, "Unknown host %s\n", stringaddress);
      return -1 ;
    }
  inet_address.sin_addr = *(struct in_addr * )hostinfo->h_addr ;

  if (connect (sock,
	       (struct sockaddr *)&inet_address,
	       sizeof (inet_address))<0)
    {
      perror("connect");
      return -1 ;
    }
  return sock;  
}

/**
   Get hostname of current system.
   Please free the returned value after use.
 */
char * 
dm_gethostname_versatile(void)
{
  const int unithostnamelen = 256;
  int unit = 1;
  char * localhostname = malloc (unithostnamelen + 1) ;
  if (!localhostname) return NULL;
  
  while (gethostname (localhostname, unithostnamelen * unit) == -1)
    {
      char * newlocalhostname = realloc(localhostname, unithostnamelen * (++ unit) + 1);
      if (newlocalhostname == NULL)
	{
	  free(localhostname);
	  return NULL;
	}
      else 
	localhostname = newlocalhostname ;
    }
  return localhostname;
}


#define malloc_with_error(A,BYTES) if (NULL==((A)=malloc(BYTES)))\
{fprintf(stderr, "out of memory in allocating %i bytes, in dmachinemon/libsocket\n", BYTES);return (1);}


				/* return 1 on error */
/**
   Set up a Internet daemon listening to TCP streams.
   Returns 1 on error.
   \Ref{dm_handle_incoming_params} is passed to 
   the callback function.
 */
int 
dm_tcp_host_setup( const char * programname, /// Name of program (used in error message)
		   const char * port_name, /// port number to listen
		   void * handle_incoming_function /// The callback function
		   )
{
  char *localhostname ;
  struct sockaddr_in sa;
  struct dm_handle_incoming_params * params;
    
  int incoming_socket;		/* the main waiting socket */
  struct hostent *hp;
  int i;
  pthread_t newthread_id ;
  pthread_attr_t pthread_attrib ;
  
				/* creating a pthread attribute */
  pthread_attr_init(&pthread_attrib);
  pthread_attr_setdetachstate(&pthread_attrib,1);
  
  if (!(localhostname = dm_gethostname_versatile ()))
    {
      fprintf(stderr, "%s: Cannot allocate enough memory to gethostname, in dmachinemon/libsocket\n", programname);
      return 1;      
    }
  if ((hp = gethostbyname(localhostname)) == NULL)
    {
      fprintf(stderr, "%s: cannot get localhost info, in dmachinemon/libsocket\n", programname);
      return 1;      
    }
  if ((incoming_socket = socket (hp->h_addrtype, SOCK_STREAM, 0 )) == -1 )
    {
      perror  ("socket in dmachinemon/libsocket");
      return 1;
    }

  sa.sin_port = htons(atoi(port_name));	/* this should hopefully be portable */
  sa.sin_addr.s_addr= htonl(INADDR_ANY); /* should it be like this? it's 0 in linux */
  sa.sin_family = AF_INET;
  
  if (bind(incoming_socket, (struct sockaddr*)&sa, sizeof (sa) ) < 0  ) 
    {
      perror ("bind in dmachinemon/libsocket");
      return 1;
    }

  listen (incoming_socket, BACKLOG);
  /* the main routine getting incoming connections */
  while (1)
    {
      i = sizeof (struct sockaddr_in);
      malloc_with_error(params, sizeof(struct dm_handle_incoming_params));
      malloc_with_error(params->tmpisap, i);
      if ((params->t = accept (incoming_socket, (struct sockaddr*)params->tmpisap, &i )) == -1)
	{
	  perror ("accept in dmachinemon/libsocket");
	  return 1;	  
	}      
      pthread_create (&newthread_id, &pthread_attrib, (void*)handle_incoming_function, params);
    }
}


