/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * command-line parser
 */

#ifndef _DMACHINEMON_COMMANDLINEPARSER_H__
#define _DMACHINEMON_COMMANDLINEPARSER_H__

/**
   Command line option information, used in dmachinemon_parse_options

   @version 0.12 changed the interface.
   @see dmachinemon_parse_options
 */
typedef struct dm_commandoption
{
  /** client port number, used for communicating with master from client programs */
  char* port_client; 
  /** nodes port number, used for internally communicating between servents and master */
  char* port_nodes; 
  /** parent host name, the initial uplink to connect to. */
  char* parenthostname; 
  /** sleep time between uplink connects in seconds. */
  int sleeptime; 
  /** number of hosts of seen-by to allow. */
  int number_of_hosts_of_seenby;
  /** number of times it will try to reconnect with parent. */
  int max_num_reconnect;
  /** whether to die on high load average  */
  int dieonload_flag;
  /** the load average value at which this node will die */
  float dieonload;
  /** the number of downlinks to have as maximum. */
  int downlinknum_threshold;
  /** The uplink is static and will not attempt to relink */
  int uplink_static;
  /** The downlink is static and will not attempt to relink the downlink. */
  int downlink_static;
  /** The debug level of messages */
  int debuglevel;
  /** The seen count threshold, default is 50, but may require to be higher on some applications */
  int clientseencount_threshold;
  /** remote shell command to use for connecting from servents to uplink. */
  char * rsh;
} dm_commandoption;

void dmachinemon_parse_options ( int ac, char ** av, dm_commandoption * cdat);
void dmachinemon_print_commandline_help (void);

#endif /* _DMACHINEMON_COMMANDLINEPARSER_H__ */
