/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * libp2papplication - application in P2P, doing things.
 *
 *$Id: dmachinemon-libp2papplication.h,v 1.4 2002/08/05 13:26:46 dancer Exp $
 */


#ifndef __DMACHINEMON_LIBP2PAPPLICATION_H_
#define __DMACHINEMON_LIBP2PAPPLICATION_H_

#include <dmachinemon/dmachinemon-commandlineparser.h>

/**@name DNAS application framework
   This is a group of functions that can be used for building 
   DNAS applications using DNAS framework.
   These functions are there to facilitate development of such programs.
 */
/*@{*/

/**
   Initialization for DNAS interface.
   Must be called on application startup.
   The argc, and argv arguments passed to 
   main function should be passed on to here.

   @return 1 on error, 0 on success.
   @version 0.31.0 changed name to DNAS_Init from dm_Init, requires pointer to cdat
 */
int
DNAS_Init (int * ac /** &argc */, 
	   char *** av /** &argv */ , 
	   dm_commandoption* p2pcdat /** command line parameter option */
	   );

/**
   Deinitialization for dmachinemon P2P interface.
   Must be called on application termination.
   It is currently a dummy application.

   @return 1 on error, 0 on success.
   @version 0.31.0 changed name to DNAS_Finalize from dm_Finalize, requires pointer to cdat
 */
int DNAS_Finalize(dm_commandoption * cdat /** Command line parameter option */);
/**
   Function to send information to the immediate uplink,
   to be gathered using \Ref{dm_gatherinfo}.

   Other nodes will be able to see the information 
   sent with the TAG, for nodes which are connected to the 
   same uplink, and all the children of the nodes which are
   connected to the same uplink.

   It takes some time before the information is sent to uplink,
   namely the --sleep parameter given to dmachinemon-servent
   determines it.

   Also this function should fail if dmachinemon-servent
   has terminated for some reason, maybe with --Dieonload
   option.

   Unless --layers is specified when invoking dmachinemon-servent,
   the information that has been given with sendinfo will be available on
   all of the uplinks, with gatherinfo.


   @version 0.31.0 changed name to DNAS_Finalize from dm_Finalize, requires pointer to cdat
   @return 1 on error, 0 on success.
 */
int DNAS_sendinfo (const char * TAG, /** TAG to identify information */
		   const char * string /** The information string. */,
		   dm_commandoption* p2pcdat /** command line parameter option */
		   );


				/* gather info */
/**
   Gather information with the specified tag from the immediate uplink.
   Other nodes have already sent this information using 
   \Ref{dm_sendinfo}.
   Information obtained with this function should be freed with
   \Ref{dm_freeinfo}.

   There is a notable delay between sendinfo and actually receiving
   information via gatherinfo.

   cdat cannot be used in this function, unless external interface is to be
   broken.
   
   @see dm_freeinfo
   @see dm_sendinfo
   @return array of character pointers, or NULL on failure.
   @version 0.31.0 changed name to DNAS_Finalize from dm_Finalize, requires pointer to cdat
 */
char ** 
DNAS_gatherinfo (const char * TAG /** Name of tag to search for */,
		 dm_commandoption* p2pcdat /** command line parameter option */
		 ) ;

/**
   Free the information obtained with \Ref{dm_gatherinfo}.

   @see dm_gatherinfo
   @version 0.31.0 changed name to DNAS_Finalize from dm_Finalize
 */
void DNAS_freeinfo(char ** m);

/*@}*/

#endif

