/*
 *  RNAS / routine to create the main window
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * GTK+ interface internals
 */
/*
 * routines to create GTK interface.
 * $Id: rnas-monitor-gtk-mainwindow.c,v 1.2 2002/09/26 07:42:07 dancer Exp $
 */
/* 
 * GTK+ interface for load average monitor program.
 * 2001 Jun 9 Junichi Uekawa
 */
/* 
 * code to do some timeout temperature monitoring.
 * a sample code to monitor the load average of a machine.
 * 5 June 2001. Copyright 2001 Junichi Uekawa
 * call this proggie with a command-line like :
 *   ./tempmon /proc/sys/dev/sensors/via686a-isa-6000/temp?
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <locale.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <string.h>
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "rnas-monitor-gtk.h"

static gint
delete_event (GtkWidget * w, GdkEvent * e, gpointer data)
{				/* I will be deleted */
  return FALSE;  
}

static gint
destroy_callback (GtkWidget * w, gpointer data)
{
  gtk_main_quit();
  return 0;  
}

static gint
apptitle_clicked (GtkWidget * w, gpointer data)
{
  char * s;
  char * server_name=GTK_WINDOW(w->parent->parent->parent->parent->parent)->title;
  

  gtk_label_get(GTK_LABEL(GTK_BIN(w)->child),&s);
  
  if (!fork())
    {
      char * buf[] =
	{
	  "xterm",
	  "-e",
	  "ssh",
	  "-t",
	  server_name,
	  "rsh",
	  s,
	  NULL
	};
      execv("/usr/bin/X11/xterm", buf);
      fprintf (stderr, "exec failed\n");
      exit(0);
      
    }
  return 0;
}

void
CreateApplicationDataTitle(GtkWidget* hbox, const char * s)
{
  GtkWidget * w = gtk_button_new_with_label(s);
  gtk_box_pack_start(GTK_BOX(hbox), w, TRUE, TRUE, FALSE);
  gtk_signal_connect (GTK_OBJECT(w), "clicked", 
		      GTK_SIGNAL_FUNC(apptitle_clicked), NULL);

  gtk_widget_show(w);
}

void
CreateHeadingsOne(GtkWidget*hbox, const char * text)
{
  GtkWidget * a = gtk_button_new_with_label(text);
  gtk_box_pack_start (GTK_BOX(hbox), a, TRUE, TRUE, FALSE);
  gtk_widget_show(a);
}

static void
CreateHeadings(GtkWidget *vbox, rnasmonitors * r)
{
  GtkWidget * horz = gtk_hbox_new(TRUE, FALSE);

  CreateHeadingsOne(horz, "hostname");
  
  gtk_box_pack_start (GTK_BOX(vbox), horz, FALSE, FALSE, FALSE);
  for ( ; r; r=r->next)
    {
      CreateHeadingsOne(horz, r->titlename);
    }
  gtk_widget_show(horz);
}

static GtkWidget * 
CreateVBox(GtkWidget * w, rnasmonitors *r)
{
  GtkWidget * v = gtk_vbox_new (FALSE, FALSE);  
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (w), v);
  CreateHeadings(v,r);  
  gtk_widget_show(v);  
				/* this v is the vbox people should add their objects to. */
  return v;  
}

static GtkWidget* 
CreateScrollableWindow(GtkWidget* w, rnasmonitors*r)
{
  GtkWidget* vbox;
  GtkWidget * s = gtk_scrolled_window_new(NULL, NULL);
  vbox=CreateVBox(s,r);
  gtk_container_add(GTK_CONTAINER (w), s);  
  gtk_widget_show(s);  
  return vbox;  
}

/**
 * Creates the main window for RNAS
 */
GtkWidget* 
CreateMainWindow(const char * title, rnasmonitors *r)
{
  GtkWidget *winMain ;  
  GtkWidget * vbox;

  winMain=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (winMain, 512, 400);
  gtk_window_set_title (GTK_WINDOW(winMain), title);
  
  gtk_signal_connect (GTK_OBJECT(winMain), "delete_event", 
		      GTK_SIGNAL_FUNC(delete_event), NULL);
  gtk_signal_connect (GTK_OBJECT(winMain), "destroy",
		      GTK_SIGNAL_FUNC(destroy_callback), NULL);  
  vbox=CreateScrollableWindow(winMain,r);
  gtk_widget_show(winMain);
  return vbox;
}
