/*
 *  Remote Network application system for DNAS -- common routines.
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: rnas-common.c,v 1.3 2002/12/01 13:27:24 dancer Exp $
 */
#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <pthread.h>
#include "config.h"
#include "dmachinemon/dmachinemon-debug.h"
#include "dmachinemon/dmachinemon.h"
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"

void
access_master(const dm_commandoption * cdat, const char * hostname, const char* portnumber)
{
  int fd = DNAS_connect_to_host(cdat, hostname, atoi(portnumber), 1);
  FILE* f=(fd!=-1)?fdopen (fd, "r"):NULL;
  
  if (!f)
    {
      fprintf (stderr, PROGRAMNAME ": cannot open server socket\n");
      exit(1);
    }

  if (dm_process_nodes_input (f, &maininfo, NULL, NULL))
    {
      fprintf (stderr, PROGRAMNAME ": could not handle input...\n");
      exit (1);
    }  

  fclose(f);
}
