<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                exclude-result-prefixes="doc"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: menudescrip.xsl,v 1.10 2003/05/24 13:52:45 stevecheng Exp $
     ********************************************************************

     &copy; 2000-2001 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Originally derived from Norman Walsh's XSL DocBook Stylesheet
     Distribution.

     ******************************************************************** -->

<!-- ==================================================================== -->
<doc:reference xmlns="">
<title>Texinfo menu descriptions</title>
<partintro>

<para>
Make descriptions for Texinfo menu entries, if available.
</para>

<section>
<title>Menu descriptions: processing expectations</title>

<para>
If an <sgmltag class="element">abstract</sgmltag> with <sgmltag
class="attribute">role</sgmltag>="make-texinfo-node" is found, that
is rendered as the menu description for the node.
</para>

<para>
If the above is not found, and
<parameter>menus-use-abstract</parameter> is true, then
a plain <sgmltag class="element">abstract</sgmltag> will be used.
If that is also not found, the node will have no description.
</para>

<para>
Descriptions should be one sentence or phrase long.
In any case only the first paragraph of an abstract is rendered.
</para>

</section>
</partintro>
</doc:reference>

<!-- ==================================================================== -->
<doc:mode mode="for-menu-description" xmlns="">
<refpurpose>Return description for Texinfo node</refpurpose>
<refdescription>
<para>
Processing an element using menu-description-mode returns a result tree
fragment that is the description for its menu entry.
</para>
<para>
This mode is still experimental.
</para>
</refdescription>
</doc:mode>

<xsl:template match="refentry"
              mode="for-menu-description">
  <xsl:apply-templates select="refnamediv/refpurpose/node()" />
</xsl:template>



<xsl:template match="reference|preface|chapter|appendix|glossary|bibliography|article|
                     sect1|sect2|sect3|sect4|sect5|refsect1|refsect2|refsect3|partintro|section|
                     book"
              mode="for-menu-description">
  <xsl:variable name="info"
    select="./docinfo|*[local-name(.)=concat(local-name(current()),'info')]" />

  <xsl:choose>
    <xsl:when test="$info/abstract[@role='texinfo-node']">
      <xsl:variable name="a" select="($info/abstract[@role='texinfo-node'])[1]" />
      <xsl:apply-templates select="($a/simpara | $a/para | $a/formalpara)[1]"
                           mode="coerce-into-inline" />
    </xsl:when>

    <xsl:when test="not($menus-use-abstract)">
    </xsl:when>

    <xsl:when test="$info/abstract">
      <xsl:variable name="a" select="$info/abstract[1]" />
      <xsl:apply-templates select="($a/simpara | $a/para | $a/formalpara)[1]"
                           mode="coerce-into-inline" />
    </xsl:when>

  </xsl:choose>
</xsl:template>

<xsl:template match="*" mode="for-menu-description">
</xsl:template>

</xsl:stylesheet>
