<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                exclude-result-prefixes="doc"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: texinode-base.xsl,v 1.19 2003/05/24 13:52:46 stevecheng Exp $
     ********************************************************************

     &copy; 2000-2001 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Originally derived from Norman Walsh's XSL DocBook Stylesheet
     Distribution.

     ******************************************************************** -->

<!-- ==================================================================== -->

<doc:reference xmlns="">
<title>Low-level Texinfo node templates</title>
<partintro>
<para>
These templates are used when creating Texinfo nodes and anchors.  The
user generally does not modify these templates.
</para>
</partintro>
</doc:reference>


<!-- ==================================================================== -->
<!-- Anchors -->

<doc:template name="anchor" xmlns="">
<refpurpose>Complete anchor link-end</refpurpose>
<refdescription>
<para>To complete the link end of a (cross) reference to an arbitrary
element that is not mapped to a Texinfo node, the following template
<emphasis>must</emphasis> be called before processing the element's
contents.</para>

<note>
<title>Implementation note</title>
<para>We use keys to test if an element is linked (using a <sgmltag
class="attribute">linkend</sgmltag> attribute on one of the linking or
cross-referencing elements).  </para>

<para>Clearly this will not work with XT.  If you insist on using it, 
just delete the key references.</para>
</note>

</refdescription>
</doc:template>

<xsl:key name="linkend-sources"
         match="*[@linkend]"
         use="@linkend" />

<xsl:template name="anchor">
  <xsl:if test="@id and key('linkend-sources', @id)">
    <anchor>
      <xsl:attribute name="node">
        <xsl:call-template name="get-texinfo-node-name" />
      </xsl:attribute>
    </anchor>
  </xsl:if>
</xsl:template>





<!-- ==================================================================== -->
<!-- Node statement -->

<doc:template name="make-texinfo-node" xmlns="">
<refpurpose>Output node element</refpurpose>
<refdescription>
<para>
This named template creates a node element in the result tree, 
which corresponds to the Texinfo <literal>@node</literal> command.
</para>
<para>
This template also generates menus if necessary.
</para>
</refdescription>
</doc:template>

<xsl:template name="make-texinfo-node">
  
  <!-- Safeguard code -->
  <xsl:variable name="isnode">
    <xsl:apply-templates select="." mode="is-texinfo-node" />
  </xsl:variable>
  <xsl:if test="$isnode != '1'">
    <xsl:call-template name="user-message">
      <xsl:with-param name="key">make-texinfo-node called for non-node</xsl:with-param>
    </xsl:call-template>
  </xsl:if>

  <xsl:variable name="nodename">
    <xsl:call-template name="get-texinfo-node-name" />
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="$nodename = 'Top'">
      <xsl:call-template name="make-texinfo-top-node" />
    </xsl:when>
    <xsl:otherwise>


  <!-- If this is the first 'subnode' of the parent node, then
       the parent node will end here, so make a menu.
  -->
  <xsl:variable name="isprevnode">
    <xsl:apply-templates select="preceding-sibling::*[1]"
                         mode="is-texinfo-node" />
  </xsl:variable>
  <xsl:if test="$isprevnode != '1'">
    <xsl:apply-templates select=".." mode="texinfo-menu" />
  </xsl:if>
  
  <node>
    <xsl:attribute name="name">
      <xsl:value-of select="$nodename" />
    </xsl:attribute>

    <!-- Previous, next, up pointers -->
    <xsl:if test="$isprevnode = '1'">
      <xsl:attribute name="previous">
        <xsl:call-template name="get-texinfo-node-name">
          <xsl:with-param name="node" select="preceding-sibling::*[1]" />
        </xsl:call-template>
      </xsl:attribute>
    </xsl:if>

    <xsl:variable name="parentnodename">
      <xsl:call-template name="get-texinfo-node-name">
        <xsl:with-param name="node" select=".." />
      </xsl:call-template>
    </xsl:variable>

    <xsl:if test="$parentnodename = 'Top' and $isprevnode != '1'">
      <xsl:attribute name="previous">
        <xsl:value-of select="$parentnodename" />
      </xsl:attribute>
    </xsl:if>

    <xsl:variable name="isnextnode">
      <xsl:apply-templates select="following-sibling::*[1]"
                           mode="is-texinfo-node" />
    </xsl:variable>
      
    <xsl:if test="$isnextnode = '1'">
      <xsl:attribute name="next">
        <xsl:call-template name="get-texinfo-node-name">
          <xsl:with-param name="node" select="following-sibling::*[1]" />
        </xsl:call-template>
      </xsl:attribute>
    </xsl:if>

    <xsl:attribute name="up">
      <xsl:value-of select="$parentnodename" />
    </xsl:attribute>
  </node>

  </xsl:otherwise></xsl:choose>
</xsl:template>


<xsl:template name="make-texinfo-top-node">
  <node>
    <xsl:attribute name="name">
      <xsl:value-of select="'Top'" />
    </xsl:attribute>

    <xsl:attribute name="previous">
    </xsl:attribute>

    <xsl:attribute name="next">
      <xsl:call-template name="make-texinfo-top-node-firstchild">
        <xsl:with-param name="node" select="child::*[1]" />
      </xsl:call-template>
    </xsl:attribute>

    <!-- We normally do not allow () in node names;
         we special-case 'Top' nodes in db2x_texixml... -->
  </node>
</xsl:template>

<!-- More recursive loops, because XSLT 1.0 cannot use
     templates as functions. -->
<xsl:template name="make-texinfo-top-node-firstchild">
  <xsl:param name="node" />
  <xsl:variable name="isnode">
    <xsl:apply-templates select="$node"
                         mode="is-texinfo-node" />
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="not($node)">
    </xsl:when>
    
    <xsl:when test="$isnode = '1'">
      <xsl:call-template name="get-texinfo-node-name">
        <xsl:with-param name="node" select="$node" />
      </xsl:call-template>
    </xsl:when>

    <xsl:otherwise>
      <xsl:call-template name="make-texinfo-top-node-firstchild">
        <xsl:with-param name="node" select="$node/following-sibling::*[1]" />
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>
      



<!-- ==================================================================== -->

<xsl:template match="*" mode="texinfo-node-name">
  <xsl:apply-templates mode="texinfo-node-name" />
</xsl:template>

<xsl:template match="text()" mode="texinfo-node-name">
  <xsl:value-of select="translate(string(.), &quot;().,:'&quot;, &quot;[]_;;_&quot;)" />
</xsl:template>

</xsl:stylesheet>

