/***************************************************************************
 *   Copyright (C) 2006 by Peter Penz (peter.penz@gmx.at),                 *
 *   Cvetoslav Ludmiloff and Patrice Tremblay                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "dolphinsettings.h"
#include <qdir.h>
#include <kicontheme.h>

#include "dolphiniconsviewsettings.h"
#include "dolphindetailsviewsettings.h"
#include "dolphin.h"
#include "kapplication.h"
#include "klocale.h"

DolphinSettings& DolphinSettings::instance()
{
    static DolphinSettings* instance = 0;
    if (instance == 0) {
        instance = new DolphinSettings();
    }
    return *instance;
}

void DolphinSettings::setHomeURL(const KURL& url)
{
    m_homeURL = url;
    if ((m_bookmarks.count() > 0) && url.isValid()) {
        m_bookmarks[Home].setURL(url);
    }
}

DolphinSettings::DolphinSettings() :
    m_defaultMode(DolphinView::IconsView),
    m_isViewSplit(false),
    m_isURLEditable(false)
{
    KConfig* config = kapp->config();
    config->setGroup("General");
    m_homeURL = KURL(config->readEntry("Home URL", QDir::homeDirPath()));
    m_defaultMode = static_cast<DolphinView::Mode>(config->readNumEntry("Default View Mode", DolphinView::IconsView));
    m_isViewSplit = config->readBoolEntry("Split View", false);
    m_isURLEditable = config->readBoolEntry("Editable URL", false);

    m_iconsView = new DolphinIconsViewSettings(DolphinIconsView::Icons);
    m_previewsView = new DolphinIconsViewSettings(DolphinIconsView::Previews);
    m_detailsView = new DolphinDetailsViewSettings();

    addFixedBookmarks();
    addEditableBookmarks();
    addFallbackBookmark();
}

DolphinSettings::~DolphinSettings()
{
    delete m_iconsView;
    m_iconsView = 0;

    delete m_previewsView;
    m_previewsView = 0;

    delete m_detailsView;
    m_detailsView = 0;
}

void DolphinSettings::addBookmark(const Bookmark& bookmark)
{
    QValueList<Bookmark>::iterator it = m_bookmarks.end();
    --it;
    m_bookmarks.insert(it, bookmark);
/*
    m_bookmarks.append(bookmark);

    KConfig* config = kapp->config();
    config->setGroup("Bookmarks");

    int bookmarkIndex = 0;
    QString bookmarkEntries;
    QValueList<Bookmark>::const_iterator it;
    for (it = m_bookmarks.begin(); it != m_bookmarks.end(); ++it) {
        const Bookmark& bookmark = (*it);
        if (bookmark.isEditable()) {
            bookmarkEntries += bookmark.name();
            bookmarkEntries += ';';
            bookmarkEntries += bookmark.url().prettyURL();
            bookmarkEntries += ';';
            bookmarkEntries += bookmark.icon();
            bookmarkEntries += ';';
            ++bookmarkIndex;
        }
    }
    config->writeEntry("Entries", bookmarkEntries);
    config->writeEntry("Count", bookmarkIndex);*/

    // TODO: it would be enough to refresh the navigation bar
    Dolphin::mainWin().refreshViews();
}

void DolphinSettings::updateEditableBookmarks(const QValueList<Bookmark>& bookmarks)
{
    m_bookmarks.clear();
    addFixedBookmarks();

    QValueList<Bookmark>::const_iterator it;
    for (it = bookmarks.begin(); it != bookmarks.end(); ++it) {
        m_bookmarks.append(*it);
    }

    addFallbackBookmark();
}

DolphinIconsViewSettings* DolphinSettings::iconsView(DolphinIconsView::LayoutMode mode) const
{
    return (mode == DolphinIconsView::Icons) ? m_iconsView : m_previewsView;
}

void DolphinSettings::save()
{
    KConfig* config = kapp->config();
    config->setGroup("General");
    config->writeEntry("Home URL", m_homeURL.prettyURL());
    config->writeEntry("Default View Mode", m_defaultMode);
    config->writeEntry("Split View", m_isViewSplit);
    config->writeEntry("Editable URL", m_isURLEditable);

    m_iconsView->save();
    m_previewsView->save();
    m_detailsView->save();

    config->setGroup("Bookmarks");
    int bookmarkIndex = 0;
    QString bookmarkEntries;
    QValueList<Bookmark>::const_iterator it;
    for (it = m_bookmarks.begin(); it != m_bookmarks.end(); ++it) {
        const Bookmark& bookmark = (*it);
        if (bookmark.isEditable()) {
            bookmarkEntries += bookmark.name();
            bookmarkEntries += ';';
            bookmarkEntries += bookmark.url().prettyURL();
            bookmarkEntries += ';';
            bookmarkEntries += bookmark.icon();
            bookmarkEntries += ';';
            ++bookmarkIndex;
        }
    }
    config->writeEntry("Entries", bookmarkEntries);
    config->writeEntry("Count", bookmarkIndex);
}

void DolphinSettings::addFixedBookmarks()
{
    m_bookmarks.append(Bookmark(i18n("Home"), m_homeURL, "folder_home", false));
    m_bookmarks.append(Bookmark(i18n("Storage Media"), KURL("media:/"), "blockdevice", false));
    m_bookmarks.append(Bookmark(i18n("Network"), KURL("remote:/"), "network_local", false));
    m_bookmarks.append(Bookmark(i18n("Root"), KURL("/"), "folder_red", false));
    m_bookmarks.append(Bookmark(i18n("Trash"), KURL("trash:/"), "trashcan_full", false));
}

void DolphinSettings::addEditableBookmarks()
{
    KConfig* config = kapp->config();
    config->setGroup("Bookmarks");
    const int count = config->readNumEntry("Count");
    const QString bookmarkEntries(config->readEntry("Entries"));
    for (int i = 0; i < count; ++i) {
        int index = i * 3;
        const QString name(bookmarkEntries.section(';', index, index));
        ++index;
        const QString url(bookmarkEntries.section(';', index, index));
        ++index;
        const QString icon(bookmarkEntries.section(';', index, index));;
        m_bookmarks.append(Bookmark(name, KURL(url), icon, true));
    }
}

void DolphinSettings::addFallbackBookmark()
{
    m_bookmarks.append(Bookmark("Custom Path", KURL(""), "folder", false));
}




