# A very simple setup script to create 2 executables.
#
# hello.py is a simple "hello, world" type program, which alse allows
# to explore the environment in which the script runs.
#
# test_wx.py is a simple wxPython program, it will be converted into a
# console-less program.
#
# If you don't have wxPython installed, you should comment out the
#   windows = ["test_wx.py"]
# line below.
#
#
# Run the build process by entering 'setup.py py2exe' or
# 'python setup.py py2exe' in a console prompt.
#
# If everything works well, you should find a subdirectory named 'dist'
# containing some files, among them hello.exe and test_wx.exe.


from distutils.core import setup
import py2exe

# The manifest enables the use of the XP theme in wxWidgets.
# How logical and intuitive.
manifest = """
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<assembly xmlns="urn:schemas-microsoft-com:asm.v1" manifestVersion="1.0">
<assemblyIdentity
    version="0.64.1.0"
    processorArchitecture="x86"
    name="Controls"
    type="win32"
/>
<description>Snowberry</description>
<dependency>
    <dependentAssembly>
        <assemblyIdentity
            type="win32"
            name="Microsoft.Windows.Common-Controls"
            version="6.0.0.0"
            processorArchitecture="X86"
            publicKeyToken="6595b64144ccf1df"
            language="*"
        />
    </dependentAssembly>
</dependency>
</assembly>
"""

opts = {
    "py2exe": {
        "includes": "webbrowser",
        'bundle_files': 1,
        'compressed': 1,
        'optimize': 2
    }
}

"""
installs manifest and icon into the .exe
but icon is still needed as we open it
for the window icon (not just the .exe)
changelog and logo are included in dist
"""

setup(
    version = "1.2.0",
    description = "Doomsday Engine Launcher",
    name = "Snowberry",
    options = opts,

    windows = [
        {
            "script": "snowberry.py",
            "icon_resources": [(1, "graphics/snowberry.ico")],
            "other_resources": [(24, 1, manifest)]
        }
    ],
    data_files= [ 
        ( '.', ['graphics/snowberry.ico'] ) 
    ]
)
