from re import compile, IGNORECASE

from dosage.helpers import BasicScraper, bounceStarter, queryNamer, indirectStarter
from dosage.util import getQueryParams


class DMFA(BasicScraper):
    latestUrl = 'http://www.missmab.com/'
    imageUrl = 'http://missmab.com/Comics/Vol_%s.php'
    imageSearch = compile(r'<img .*src="((.*comics/.*|[^/]*)(png|jpg|gif))".*>')
    prevSearch = compile(r'<a href="([^"]*\.php)"><img src="(\.\./)?Images/comicprev\.gif"')
    help = 'Index format: nnn (normally, some specials)'


class DandyAndCompany(BasicScraper):
    latestUrl = 'http://www.dandyandcompany.com/'
    imageUrl = 'http://www.dandyandcompany.com/%s'
    imageSearch = compile(r'<img src="(.*?/strips/.+?)"')
    prevSearch = compile(r'<a href="(.*)" class="prev"')
    help = 'Index format: yyyy/mm/dd'


class DeathToTheExtremist(BasicScraper):
    latestUrl = 'http://www.dtecomic.com/'
    imageUrl = 'http://www.dtecomic.com/?n=%s'
    imageSearch = compile(r'"(comics/.*?)"')
    prevSearch = compile(r'</a> <a href="(\?n=.*?)"><.+?/aprev.gif"')
    help = 'Index format: nnn'


class DoemainOfOurOwn(BasicScraper):
    latestUrl = 'http://www.furfolk.com/'
    imageUrl = 'http://www.furfolk.com/index.cgi/%s'
    imageSearch = compile(r"<img border='0' width='\d+' height='\d+' src='(/strips/\d{4}/\d{6}-[^\']+)'")
    prevSearch = compile(r'<a href="(/index\.cgi/\d{4}-\d{2}-\d{2})"><img width="\d+" height="\d+" border="\d+" alt="Previous Strip"')
    help = 'Index format: yyyy-mm-dd'


class DrFun(BasicScraper):
    latestUrl = 'http://www.ibiblio.org/Dave/this-week.html'
    imageUrl = 'http://www.ibiblio.org/Dave/this-week.html'
    imageSearch = compile(r'<A HREF=\s?"(Dr-Fun/df\d{6}/df\d{8}\.jpg)">')
    prevSearch = compile(r'<a href="(ar\d+.htm)#banner">Previous Week,\s?<\/A>')
    help = 'Index format: yyyymmdd'


class Dracula(BasicScraper):
    latestUrl = 'http://www.coyotepuck.dragoncity.net/dracula/index.php'
    imageUrl = 'http://www.coyotepuck.dragoncity.net/dracula/index.php?p=%s'
    imageSearch = compile(r'"(story/.+?)"')
    prevSearch = compile(r'(index.php\?p=.+?)">.+?back')
    help = 'Index format: nnn'


class DragonTails(BasicScraper):
    latestUrl = 'http://www.dragon-tails.com/'
    imageUrl = 'http://www.dragon-tails.com/archive.php?date=%s'
    imageSearch = compile(r'"(newcomic/.+?)"')
    prevSearch = compile(r'"(archive.+?)">.+n_2')
    help = 'Index format: yyyy-mm-dd'


class Drowtales(BasicScraper):
    latestUrl = 'http://www.drowtales.com/mainarchive.php'
    imageUrl = 'http://www.drowtales.com/mainarchive.php?location=%s'
    imageSearch = compile(r'src=".(/tmpmanga/.+?)"')
    prevSearch = compile(r'<a href="mainarchive.php(\?location=\d+)"><img src="[^"]*previousday\.gif"')
    help = 'Index format: yyyymmdd'


class DungeonCrawlInc(BasicScraper):
    latestUrl = 'http://www.dungeoncrawlinc.com/latest.html'
    imageUrl = 'http://www.dungeoncrawlinc.com/comic%s'
    imageSearch = compile(r'src="(.+?/DCI_.+?)"')
    prevSearch = compile(r'<a href="(.+?)">.+?back')
    help = 'Index format: nnn.html'


class DieselSweeties(BasicScraper):
    latestUrl = 'http://www.dieselsweeties.com/'
    imageUrl = 'http://www.dieselsweeties.com/archive/%s'
    imageSearch = compile(r'<img src="(/hstrips/\d+/\d+/\d+/\d+/\d{5}\..+?)" border="0"')
    prevSearch = compile(r'<a.+?href="((?:http://www\.dieselsweeties\.com)?/archive/\d+)">previous')
    help = 'Index format: n (unpadded)'

    def namer(cls, imageUrl, pageUrl):
        index = int(imageUrl.split('/')[-1].split('.')[0])
        return 'sw%02d' % (index,)


class DominicDeegan(BasicScraper):
    latestUrl = 'http://www.dominic-deegan.com/'
    imageUrl = 'http://www.dominic-deegan.com/view.php?date=%s'
    imageSearch = compile(r'<img src="(.+?save-as=.+?)" alt')
    prevSearch = compile(r'<a href="(view.php\?date=.+?)">Previous')
    help = 'Index format: yyyy-mm-dd'

    def namer(cls, imageUrl, pageUrl):
        return getQueryParams(imageUrl)['save-as'][0].rsplit('.', 1)[0]


def drunkDuck(shortName):
    linkSearch = r"<a href='(/[^/]*/index\.php\?p=\d+)' title='The %s page!'>"
    return BasicScraper.make(
        name='DrunkDuck/' + shortName,
        imageUrl='index.php?p=%s' % (shortName,),
        imageSearch=compile(r"<img src='(http://[a-z0-9]*.drunkduck.com/[^/]*/pages/[^'/]+)'>", IGNORECASE),
        prevSearch=compile(linkSearch % ('previous',), IGNORECASE),
        help='Index format: n (unpadded)',
        namer=queryNamer('p', usePageUrl=True),
        starter=bounceStarter('http://www.drunkduck.com/%s/' % (shortName,), compile(linkSearch % ('next',), IGNORECASE)))

duckComics = [
    '00_Wings',
    '20_Galaxies',
    '3rd_Party_Fantasy',
    'AACMAW',
    'ABNORMAL',
    'Al_De_Baran',
    'Alpha_Glitch',
    'Anti_Glory',
    'Assassin_Assassin',
    'Beyond_Help',
    'Blood_of_the_Dragon',
    'Bowsers_Plan_B',
    'bread',
    'Brutus',
    'CCC_Presents',
    'ChaoScape',
    'Charby_the_Vampirate',
    'College_Zoo',
    'Consoles',
    'Crazy_Duck',
    'Culture_Shock',
    'Dogs_Eye_View',
    'Dribble_For_Kids',
    'Elijah_and_Azuu',
    'Elijah_and_Azuu_Classic',
    'fallaparts_parts',
    'Frightmoore_University',
    'Fusion',
    'I_Cant_Draw',
    'Inner_Demons',
    'Insomnia',
    'Jet_and_Joe',
    'Kingdom_Hearts_Chain_Of_Oddness',
    'Kitschcore_Presents',
    'Kong_Comic',
    'Krud_E_Komix_Inc',
    'Laugh_It_Off',
    'Life_and_Death',
    'Lifes_A_Riot',
    'Locoma',
    'Lo_Rez',
    'Luciefer',
    'Mad_World',
    'Mahrs_Miscellaneous_Mishaps',
    'MegaMan_Theater',
    'Megaman__the_comic',
    'Mental_For_Rental',
    'MIKYAGU',
    'Mixed_Bag_Comics',
    'Mooks',
    'Nightmistress',
    'NPC',
    'Pinky_TA',
    'Psychic_Headache',
    'Puppetry',
    'Random_Thoughts',
    'Rogue_Agent_Axl',
    'schlock_horror',
    'Screwball_Islands',
    'Shiny_Things',
    'Slither_and_Friends',
    'SNAKES_ON_A_PLANE_THE_COMIC',
    'So_Fantastic_Pork_Show_9oCLOCK',
    'Songs_of_An_Angel',
    'Starving_Artists',
    'The_Gods_of_ArrKelaan',
    'The_Roach_Ranch',
    'The_Whovian_Observer',
    'This_Side_Up',
    'Tony_The_Hedgehog',
    'Too_Far',
    'trythesoup',
    'Vampire_Phantasm',
    'Villainy_Minor',
    'WeirdStar',
    'Wintergreen',
    'World_Domination',
    ]

for shortName in duckComics:
    globals()[shortName] = drunkDuck(shortName)


class DorkTower(BasicScraper):
    imageUrl = None
    imageSearch = compile(r'<img src="(images/comics/[^.]*.gif)"', IGNORECASE)
    prevSearch = compile(r'<a href="(archive.asp\?nextform=viewcomic\&id=\d{1,4})" onMouseOver="imgSwap\(\'igorback1\'', IGNORECASE)
    starter = indirectStarter('http://archive.gamespy.com/comics/dorktower/', prevSearch)
    help = 'Index format: None'


class DresdenCodak(BasicScraper):
    latestUrl = 'http://dresdencodak.com/'
    imageUrl = None
    imageSearch = compile(r'<img src="((?:cartoons/)?a_[a-z0-9_]+\.[^"]+)" width')
    prevSearch = compile(r'<a href="((?:cartoons/)?dc_\d{3}[a-z]*.html?)"><img src="(?:../)?images/b_prev')
