from re import compile, IGNORECASE

from dosage.helpers import BasicScraper, PHPScraper, queryNamer


class MadamAndEve(BasicScraper):
    latestUrl = 'http://www.madamandeve.co.za/week_of_cartns.php'
    imageUrl = 'http://www.madamandeve.co.za/week_of_cartns.php'
    imageSearch = compile(r'<IMG BORDER="0" SRC="(cartoons/me\d{6}\.(gif|jpg))">')
    prevSearch = compile(r'<a href="(weekend_cartoon.php)"')
    help = 'Index format: (none)'


class MakeWithTheFunny(BasicScraper):
    latestUrl = 'http://www.mwtfunny.com/'
    imageUrl = 'http://www.mwtfunny.com/index.php?ComicID=%s'
    imageSearch = compile(r'<img src=".+?(strips/\d{4}-\d{2}-\d{2}\..+?)">')
    prevSearch = compile(r'href="(index.php\?ComicID=.+?)" alt=".+?previous')
    help = 'Index format: n (unpadded)'


class Marilith(BasicScraper):
    latestUrl = 'http://www.marilith.com/'
    imageUrl = 'http://www.marilith.com/archive.php?date=%s'
    imageSearch = compile(r'<img src="(comics/.+?)" border')
    prevSearch = compile(r'<a href="(archive\.php\?date=.+?)"><img border=0 name=previous_day')
    help = 'Index format: yyyymmdd'


class MarryMe(BasicScraper):
    latestUrl = 'http://marrymemovie.com/main/'
    imageUrl = 'http://marrymemovie.com/main/%s'
    imageSearch = compile(r'(/comicfolder/.+?)"')
    prevSearch = compile(r'Previous.+?(/main/.+?)">Page')
    help = 'Index format: good luck !'


class MegaTokyo(BasicScraper):
    latestUrl = 'http://www.megatokyo.com/'
    imageUrl = 'http://www.megatokyo.com/strip/%s'
    imageSearch = compile(r'"(strips/.+?)"', IGNORECASE)
    prevSearch = compile(r'"(./strip/\d+?)">Prev')
    help = 'Index format: nnnn'


class MyPrivateLittleHell(BasicScraper):
    latestUrl = 'http://mutt.purrsia.com/mplh/'
    imageUrl = 'http://mutt.purrsia.com/mplh/?date=%s'
    imageSearch = compile(r'<img.+?src="(comics/.+?)"')
    prevSearch = compile(r'<a.+?href="(\?date=\d+/\d+/\d+)">Prev</a>')
    help = 'Index format: mm/dd/yyyy'


class MacHall(BasicScraper):
    latestUrl = 'http://www.machall.com/'
    imageUrl = 'http://www.machall.com/index.php?strip_id=%s'
    imageSearch = compile(r'<img src="(comics/\d{4}\d{2}\d{2}\..*?)" border=0>')
    prevSearch = compile(r'<a href="(view\.php\?date=\d{4}-\d{2}-\d{2})"><img border=0 src=\'drop_shadow/previous.gif\'>')
    help = 'Index format: n (unpadded)'


class Misfile(BasicScraper):
    latestUrl = 'http://www.misfile.com/'
    imageUrl = 'http://www.misfile.com/?page=%s'
    imageSearch = compile(r'<img src="(overlay\.php\?pageCalled=\d+)">')
    prevSearch = compile(r'<a href="(\?page=\d+)"><img src="/images/back\.gif"')
    help = 'Index format: n (unpadded)'
    namer = queryNamer('pageCalled')


class MinesBigger(BasicScraper):
    basePath = 'http://minesbigger.novablade.com/phpcomic/'
    prevSearch = compile(r'<a href="(http://minesbigger\.novablade\.com/phpcomic/daily\.php\?date=\d{6})"><img src="../../images/phpprevious.gif')
