dnl AM_PATH_ORBITCPP([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for ORBit-C++, and define ORBITCPP_CFLAGS, ORBITCPP_LIBS, ORBITCPP_NAME_CFLAGS, 
dnl ORBITCPP_NAME_LIBS
dnl
[dnl 
dnl Get the cflags and libraries from the orbitcpp-config script
dnl
AC_ARG_WITH(orbitcpp-prefix,[  --with-orbitcpp-prefix=PFX   Prefix where ORBITCPP is installed (optional)],
            orbitcpp_config_prefix="$withval", orbitcpp_config_prefix="")
AC_ARG_WITH(orbitcpp-exec-prefix,[  --with-orbitcpp-exec-prefix=PFX Exec prefix where ORBITCPP is installed (optional)],
            orbitcpp_config_exec_prefix="$withval", orbitcpp_config_exec_prefix="")
AC_ARG_ENABLE(orbitcpptest, [  --disable-orbitcpptest       Do not try to compile and run a test ORBITCPP program],
		    , enable_orbitcpptest=yes)

  for module in . $4
  do
      case "$module" in
         server) 
             orbitcpp_config_args="$orbitcpp_config_args server"
	 ;;
         client) 
             orbitcpp_config_args="$orbitcpp_config_args client"
         ;;
      esac
  done
  if test x$orbitcpp_config_args = x ; then
	orbitcpp_config_args=server
  fi

  if test x$orbitcpp_config_exec_prefix != x ; then
     orbitcpp_config_args="$orbitcpp_config_args --exec-prefix=$orbitcpp_config_exec_prefix"
     if test x${ORBITCPP_CONFIG+set} != xset ; then
        ORBITCPP_CONFIG=$orbitcpp_config_exec_prefix/bin/orbitcpp-config
     fi
  fi
  if test x$orbitcpp_config_prefix != x ; then
     orbitcpp_config_args="$orbitcpp_config_args --prefix=$orbitcpp_config_prefix"
     if test x${ORBITCPP_CONFIG+set} != xset ; then
        ORBITCPP_CONFIG=$orbitcpp_config_prefix/bin/orbitcpp-config
     fi
  fi

  AC_PATH_PROG(ORBITCPP_CONFIG, orbitcpp-config, no)
  min_orbitcpp_version=ifelse([$1], , 0.30.0, $1)
  AC_MSG_CHECKING(for ORBit-C++ - version >= $min_orbitcpp_version)
  no_orbitcpp=""
  if test "$ORBITCPP_CONFIG" = "no" ; then
    no_orbitcpp=yes
  else
    ORBITCPP_CFLAGS=`$ORBITCPP_CONFIG $orbitcpp_config_args --cflags`
    ORBITCPP_LIBS=`$ORBITCPP_CONFIG $orbitcpp_config_args --libs`
    orbitcpp_config_major_version=`$ORBITCPP_CONFIG $orbitcpp_config_args --version | \
	   sed -e 's,[[^0-9.]],,g' -e 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    orbitcpp_config_minor_version=`$ORBITCPP_CONFIG $orbitcpp_config_args --version | \
	   sed -e 's,[[^0-9.]],,g' -e 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    orbitcpp_config_micro_version=`$ORBITCPP_CONFIG $orbitcpp_config_args --version | \
	   sed -e 's,[[^0-9.]],,g' -e 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_orbitcpptest" = "xyes" ; then
      ac_save_CXXFLAGS="$CXXFLAGS"
      ac_save_LIBS="$LIBS"
      CXXFLAGS="$CXXFLAGS $ORBITCPP_CFLAGS"
      LIBS="$ORBITCPP_LIBS $LIBS"
dnl
dnl Now check if the installed ORBITCPP is sufficiently new. (Also sanity
dnl checks the results of orbitcpp-config to some extent
dnl
      rm -f conf.orbitcpptest
      AC_LANG_SAVE
      AC_LANG_CPLUSPLUS
      AC_TRY_RUN([
#include <cstdio>
#include <cstdlib>
#include <glib.h>
#include <orb/orbitcpp.hh>

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.orbitcpptest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_orbitcpp_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_orbitcpp_version");
     exit(1);
   }

  if ((_orbitcpp::MAJOR_VERSION != $orbitcpp_config_major_version) ||
      (_orbitcpp::MINOR_VERSION != $orbitcpp_config_minor_version) ||
      (_orbitcpp::MICRO_VERSION != $orbitcpp_config_micro_version))
    {
      printf("\n*** 'orbitcpp-config --version' returned %d.%d.%d, but ORBit-C++ (%d.%d.%d)\n", 
             $orbitcpp_config_major_version, $orbitcpp_config_minor_version, $orbitcpp_config_micro_version,
             _orbitcpp::MAJOR_VERSION, _orbitcpp::MINOR_VERSION, _orbitcpp::MICRO_VERSION);
      printf ("*** was found! If orbitcpp-config was correct, then it is best\n");
      printf ("*** to remove the old version of ORBit-C++. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If orbitcpp-config was wrong, set the environment variable ORBITCPP_CONFIG\n");
      printf("*** to point to the correct copy of orbitcpp-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
  else if ((_orbitcpp::MAJOR_VERSION != _orbitcpp::LIB_MAJOR_VERSION) ||
	       (_orbitcpp::MINOR_VERSION != _orbitcpp::LIB_MINOR_VERSION) ||
           (_orbitcpp::MICRO_VERSION != _orbitcpp::LIB_MICRO_VERSION))
    {
      printf("*** ORBit-C++ header files (version %d.%d.%d) do not match\n",
	     _orbitcpp::MAJOR_VERSION, _orbitcpp::MINOR_VERSION, _orbitcpp::MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     _orbitcpp::LIB_MAJOR_VERSION, _orbitcpp::LIB_MINOR_VERSION, _orbitcpp::LIB_MICRO_VERSION);
    }
  else
    {
      if ((_orbitcpp::MAJOR_VERSION > major) ||
        ((_orbitcpp::MAJOR_VERSION == major) && (_orbitcpp::MINOR_VERSION > minor)) ||
        ((_orbitcpp::MAJOR_VERSION == major) && (_orbitcpp::MINOR_VERSION == minor) && (_orbitcpp::MICRO_VERSION >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of ORBit-C++ (%d.%d.%d) was found.\n",
               _orbitcpp::MAJOR_VERSION, _orbitcpp::MINOR_VERSION, _orbitcpp::MICRO_VERSION);
        printf("*** You need version %d.%d.%d or greater of ORBit-C++. The latest version of\n",
	       major, minor, micro);
        printf("*** ORBit-C++ is always available from http://orbitcpp.sourceforge.net/.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the orbitcpp-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of ORBit-C++, but you can also set the ORBITCPP_CONFIG environment to point to the\n");
        printf("*** correct copy of orbitcpp-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_orbitcpp=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CXXFLAGS="$ac_save_CXXFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_orbitcpp" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$ORBITCPP_CONFIG" = "no" ; then
       echo "*** The orbitcpp-config script installed by ORBIT-C++ could not be found"
       echo "*** If ORBit-C++ was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the ORBITCPP_CONFIG environment variable to the"
       echo "*** full path to orbitcpp-config."
     else
       if test -f conf.orbitcpptest ; then
        :
       else
          echo "*** Could not run ORBITCPP test program, checking why..."
          CXXFLAGS="$CXXFLAGS $ORBITCPP_CFLAGS"
          LIBS="$LIBS $ORBITCPP_LIBS"
          AC_TRY_LINK([
#include <cstdio>
#include <orb/orbitcpp.hh>
],      [ return ((_orbitcpp::MAJOR_VERSION) || (_orbitcpp::MINOR_VERSION) || (_orbitcpp::MICRO_VERSION)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding ORBit-C++ or finding the wrong"
          echo "*** version of ORBit-C++. If it is not finding ORBit-C++, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means ORBITCPP was incorrectly installed"
          echo "*** or that you have moved ORBit-C++ since it was installed. In the latter case, you"
          echo "*** may want to edit the orbitcpp-config script: $ORBITCPP_CONFIG" ])
          CXXFLAGS="$ac_save_CXXFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     ORBITCPP_CFLAGS=""
     ORBITCPP_LIBS=""
     ifelse([$3], , :, [$3])
  fi

  AC_LANG_RESTORE

  if test "x$no_orbitcpp" = "xyes" ; then 
	exit 1
  fi

  AC_PATH_PROG(ORBIT_IDL, orbit-idl, ifelse([$3], , :, [$3]))
  ORBITCPP_NAME_CFLAGS=`$ORBITCPP_CONFIG --use-service=name --cflags client`
  ORBITCPP_NAME_LIBS=`$ORBITCPP_CONFIG --use-service=name --libs client`
  AC_SUBST(ORBITCPP_CFLAGS)
  AC_SUBST(ORBITCPP_LIBS)
  AC_SUBST(ORBIT_IDL)
  AC_SUBST(ORBITCPP_NAME_CFLAGS)
  AC_SUBST(ORBITCPP_NAME_LIBS)
  rm -f conf.orbitcpptest
])
