/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 William Pitcock <nenolod@sacredspiral.co.uk>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "dsyslog.h"

struct dsyslog_token_map_ {
	const gchar *name;
	guint value;
};

struct dsyslog_token_map_ severity_tokens[] = {
	{ "emergency", 0 },
	{ "alert",     1 },
	{ "critical",  2 },
	{ "error",     3 },
	{ "warn",      4 },
	{ "notice",    5 },
	{ "info",      6 },
	{ "debug",     7 },
};

struct dsyslog_token_map_ facility_tokens[] = {
	{ "kernel",    0 },
	{ "user",      1 },
	{ "mail",      2 },
	{ "system",    3 },
	{ "secure",    4 },
	{ "internal",  5 },
	{ "lpd",       6 },
	{ "nntp",      7 },
	{ "uucp",      8 },
	{ "cron",      9 },
	{ "auth",     10 },
	{ "ftpd",     11 },
	{ "ntpd",     12 },
	{ "audit",    13 },
	{ "alert",    14 },
	{ "at",       15 },
	{ "local0",   16 },
	{ "local1",   17 },
	{ "local2",   18 },
	{ "local3",   19 },
	{ "local4",   20 },
	{ "local5",   21 },
	{ "local6",   22 },
	{ "local7",   23 },
};

guint
dsyslog_facility_to_logcode(const gchar *facility)
{
	gint iter;

	_ENTER;

	for (iter = 0; iter < G_N_ELEMENTS(facility_tokens); iter++) {
		if (!g_ascii_strcasecmp(facility, facility_tokens[iter].name)) {
			_LEAVE facility_tokens[iter].value;
		}
	}

	_LEAVE 0;
}

guint
dsyslog_severity_to_logcode(const gchar *facility)
{
	gint iter;

	_ENTER;

	for (iter = 0; iter < G_N_ELEMENTS(severity_tokens); iter++) {
		if (!g_ascii_strcasecmp(facility, severity_tokens[iter].name)) {
			_LEAVE severity_tokens[iter].value;
		}
	}

	_LEAVE 0;
}

