/*=============================================================================
		e2ps.c
			by Nobuyuki SHIRAKI
			Last change : 31 January 2002  21:49:02
=============================================================================*/

/*-----------------------------------------------------------------------------
		e2ps  changes EUC text to JIS PostScript
-----------------------------------------------------------------------------*/


#include	"e2ps.h"
#include	"wtkf.h"


/* Global variables */
uchar	*gsCommand;		/* own file name */
FILE	*gpfOut;
float	gafFontsize[2][256];
char	gsEscapedStr[3];
char	gsAsciiFont[STRMAX], gsKanjiFont[STRMAX];
char	gsBoldAsciiFont[STRMAX], gsBoldItalicAsciiFont[STRMAX];
char	gsBoldKanjiFont[STRMAX], gsBoldItalicKanjiFont[STRMAX];
int	giWidth, giHeight;
int	giPage, giPsPage;
uchar	guStyle;
uchar	guBox;
uchar	guHeader;
int	giMaxLine, giLine;
float	gfTopMargin, gfBottomMargin, gfLeftMargin, gfRightMargin;
float	gfX, gfY;
float	gfFontSize, gfNlRate;
float	gfAsciiWidth, gfAsciiHeight;
float	gfKanjiWidth, gfKanjiHeight;
char	gsNowTime[STRMAX], gsHeadStr[STRMAX], gsPageStr[STRMAX];
uchar	guJapanese = 1;

#ifdef	JIS_PS
uchar	guKanjiCode = 0;
#else
uchar	guKanjiCode = 1;
#endif

char *gsMonth[12] = {
  "Jan", "Feb", "Mar", "Apr", "May", "Jun",
  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" 
};


/* Main */
int main(int argc, char **argv) {
  FILE		*read;
  struct tm	*systime;
  time_t	nowtime;
  char		*filename[256];
  char		printer[STRMAX];
  char		paper[10];
  char		string[STRMAX*10];
  signed char	ch;
  uchar		*filedata, *ctmp = NULL;
  char		*lang;
  int		files = 0, file;
  int		char_count;
  int		lpr = 0;
  int		mode;		/* Printing ASCII or Kanji */
  int		i, j, index;
  float		maxwidth;
  float		ftmp;
#ifdef	TEKTRO
  uchar		copy = 1;	/* Number of paper */
  uchar		dup = 0;	/* Both side */
#endif

  /* Signals */
  signal(SIGQUIT, quit);
  signal(SIGHUP,  quit);
  signal(SIGTERM, quit);
  signal(SIGINT,  quit);

  /* own file name */
  if ( argc > 0 ) {
    while ( strstr(argv[0], "/") ) {
      argv[0] = strstr(argv[0], "/") + 1;
    }
    gsCommand = setstring(argv[0]);
  }
  else {
    gsCommand = setstring(NAME);
  }

  /* Date and Time */
  nowtime = time(NULL);
  systime = localtime(&nowtime);
  switch ( Y2K ) {
  case 0:
  default:
    systime->tm_year += 1900;
    break;
  case 1:
    break;
  case 2:
    systime->tm_year += 2000;
    break;
  }
  sprintf(gsNowTime, "%s %.2d %.4d %.2d:%.2d:%.2d",
	  gsMonth[systime->tm_mon], systime->tm_mday, systime->tm_year,
	  systime->tm_hour, systime->tm_min, systime->tm_sec);

  /* Header string */
  gsHeadStr[0] = '\0';

  /* Page string */
  strcpy(gsPageStr, "Page");

  /* Other default */
  guStyle = 4;					/* Portrait */
  strcpy(gsAsciiFont, ASCII);
  strcpy(gsBoldAsciiFont, ASCII_BOLD);
  strcpy(gsBoldItalicAsciiFont, ASCII_BOLDITALIC);
  if ( guKanjiCode ) {
    strcpy(gsKanjiFont, EUC_KANJI);
    strcpy(gsBoldKanjiFont, EUC_KANJI_BOLD);
    strcpy(gsBoldItalicKanjiFont, EUC_KANJI_BOLDITALIC);
  }
  else {
    strcpy(gsKanjiFont, KANJI);
    strcpy(gsBoldKanjiFont, KANJI_BOLD);
    strcpy(gsBoldItalicKanjiFont, KANJI_BOLDITALIC);
  }
  giMaxLine		= MAXLINE;
  strcpy(paper, "A4");
  giWidth		= A4WIDTH;
  giHeight		= A4HEIGHT;
  gfFontSize		= FONTSIZE;
  gfTopMargin		= TOP;
  gfBottomMargin	= BOTTOM;
  gfLeftMargin		= LEFT;
  gfRightMargin		= RIGHT;
  gfNlRate		= NLRATE;
  gfAsciiWidth		= ASCIIWIDTH;
  gfAsciiHeight		= ASCIIHEIGHT;
  gfKanjiWidth		= KANJIWIDTH;
  gfKanjiHeight		= KANJIHEIGHT;
  guHeader		= 1;
  guBox			= 0;

  /* Languages */
  lang = (char *)getenv("LANG");
  if ( !strcmp(lang, "ja")
       || !strcmp(lang, "japanese")
       || !strcmp(lang, "ja_JP.ujis")
       || !strcmp(lang, "ja_JP.eucJP")
       || !strcmp(lang, "ja_JP.EUC")
       ) {
    guJapanese = 1;
  }
  else {
    guJapanese = 0;
  }

  /* Printer */
  if ( (char *)getenv("PRINTER") != NULL ) {
    strcpy(printer, (char *)getenv("PRINTER"));
  }
  else {
    printer[0] = '\0';
  }
  /* Use printer */
  if ( strstr(argv[0], LPRNAME) ) {
    /* Printer set */
    lpr = 1;
  }
  else {
    /* Standard Out */
    gpfOut = stdout;
  }

  /* Args */
  for ( i = 1 ; i < argc ; i++ ) {
    if ( strcmp(argv[i], "-l") == 0 ) {
      /* Landscape */
      guStyle = 0;
      continue;
    }
    else if ( strcmp(argv[i], "-l2") == 0 ) {
      /* Landscape Double */
      guStyle = 1;
      continue;
    }
    else if ( strcmp(argv[i], "-l4") == 0 ) {
      /* Landscape Quartet */
      guStyle = 2;
      continue;
    }
    else if ( strcmp(argv[i], "-p") == 0 ) {
      /* Portrait */
      guStyle = 3;
      continue;
    }
    else if ( strcmp(argv[i], "-p2") == 0 ) {
      /* Portrait Double */
      guStyle = 4;
      continue;
    }
    else if ( strcmp(argv[i], "-p4") == 0 ) {
      /* Portrait Quartet */
      guStyle = 5;
      continue;
    }
    else if ( strcmp(argv[i], "-ohp") == 0 ) {
      /* OHP printing */
      gfFontSize = OHPFONTSIZE;
      guStyle = 3;
      guHeader = 0;
      continue;
    }
    else if ( strcmp(argv[i], "-box") == 0 ) {
      /* Box printing */
      guBox = 1;
      continue;
    }
    else if ( strcmp(argv[i], "-af") == 0 ) {
      /* ASCII Font */
      i++;
      if ( i < argc ) strcpy(gsAsciiFont, argv[i]);
      continue;
    }
    else if ( strcmp(argv[i], "-abf") == 0 ) {
      /* ASCII Bold Font */
      i++;
      if ( i < argc ) strcpy(gsBoldAsciiFont, argv[i]);
      continue;
    }
    else if ( strcmp(argv[i], "-abif") == 0 ) {
      /* ASCII Bold Font Italic */
      i++;
      if ( i < argc ) strcpy(gsBoldItalicAsciiFont, argv[i]);
      continue;
    }
    else if ( strcmp(argv[i], "-size") == 0 ) {
      /* Font Size */
      i++;
      if ( i < argc ) {
	gfFontSize = atof(argv[i]);
	if ( gfFontSize == 0.0 ) gfFontSize = FONTSIZE;
      }
      continue;
    }
    else if ( strcmp(argv[i], "-afw") == 0 ) {
      /* ASCII Font Width */
      i++;
      if ( i < argc ) {
	gfAsciiWidth = atof(argv[i]);
	if ( gfAsciiWidth == 0.0 ) gfAsciiWidth = ASCIIWIDTH;
      }
      continue;
    }
    else if ( strcmp(argv[i], "-afh") == 0 ) {
      /* ASCII Font Height */
      i++;
      if ( i < argc ) {
	gfAsciiHeight = atof(argv[i]);
	if ( gfAsciiHeight == 0.0 || gfAsciiHeight > ASCIIHEIGHT )
	  gfAsciiHeight = ASCIIHEIGHT;
      }
      continue;
    }
    else if ( strcmp(argv[i], "-kfw") == 0 ) {
      /* KANJI Font Width */
      i++;
      if ( i < argc ) {
	gfKanjiWidth = atof(argv[i]);
	if ( gfKanjiWidth == 0.0 ) gfKanjiWidth = KANJIWIDTH;
      }
      continue;
    }
    else if ( strcmp(argv[i], "-kfh") == 0 ) {
      /* KANJI Font Height */
      i++;
      if ( i < argc ) {
	gfKanjiHeight = atof(argv[i]);
	if ( gfKanjiHeight == 0.0 || gfKanjiHeight > KANJIHEIGHT )
	  gfKanjiHeight = KANJIHEIGHT;
      }
      continue;
    }
    else if ( strcmp(argv[i], "-ls") == 0 ) {
      /* Space ratio */
      i++;
      if ( i < argc ) {
	gfNlRate = atof(argv[i]);
	if ( gfNlRate == 0.0 ) gfNlRate = NLRATE;
      }
      continue;
    }
    else if ( strcmp(argv[i], "-line") == 0 ) {
      /* Max Lines per page */
      i++;
      if ( i < argc ) {
	giMaxLine = atoi(argv[i]);
	if ( giMaxLine < 1 ) giMaxLine = MAXLINE;
      }
      continue;
    }
    else if ( strcmp(argv[i], "-a4") == 0 ) {
      /* A4 */
      strcpy(paper, "A4");
      giWidth = A4WIDTH;
      giHeight = A4HEIGHT;
    }
    else if ( strcmp(argv[i], "-b4") == 0 ) {
      /* B4 */
      strcpy(paper, "B4");
      giWidth = B4WIDTH;
      giHeight = B4HEIGHT;
    }
    else if ( strcmp(argv[i], "-le") == 0 ) {
      /* Letter */
      strcpy(paper, "LETTER");
      giWidth = LEWIDTH;
      giHeight = LEHEIGHT;
    }
    else if ( strcmp(argv[i], "-tm") == 0 ) {
      /* Top margin */
      i++;
      if ( i < argc ) {
	gfTopMargin = atof(argv[i]);
	if ( gfTopMargin == 0.0 ) gfTopMargin = TOP;
      }
      continue;
    }
    else if ( strcmp(argv[i], "-bm") == 0 ) {
      /* Bottom margin */
      i++;
      if ( i < argc ) {
	gfBottomMargin = atof(argv[i]);
	if ( gfBottomMargin == 0.0 ) gfBottomMargin = BOTTOM;
      }
      continue;
    }
    else if ( strcmp(argv[i], "-lm") == 0 ) {
      /* Left margin */
      i++;
      if ( i < argc ) {
	gfLeftMargin = atof(argv[i]);
	if ( gfLeftMargin == 0.0 ) gfLeftMargin = LEFT;
      }
      continue;
    }
    else if ( strcmp(argv[i], "-rm") == 0 ) {
      /* Right margin */
      i++;
      if ( i < argc ) {
	gfRightMargin = atof(argv[i]);
	if ( gfRightMargin == 0.0 ) gfRightMargin = RIGHT;
      }
      continue;
    }
    else if ( strcmp(argv[i], "-P") == 0 ) {
      /* Printer */
      i++;
      if ( i < argc ) {
	strcpy(printer, argv[i]);
	lpr = 1;
      }
      continue;
    }
    else if ( argv[i][0] == '-' && argv[i][1] == 'P' && argv[i][2] != '\0' ) {
      /* Printer */
      strcpy(printer, argv[i]+2);
      lpr = 1;
      continue;
    }
    else if ( strcmp(argv[i], "-date") == 0 ) {
      /* Date string */
      i++;
      if ( i < argc ) {
	strcpy(gsNowTime, argv[i]);
      }
      continue;
    }
    else if ( strcmp(argv[i], "-head") == 0 ) {
      /* Header string */
      i++;
      if ( i < argc ) {
	strcpy(gsHeadStr, argv[i]);
      }
      continue;
    }
    else if ( strcmp(argv[i], "-page") == 0 ) {
      /* Page string */
      i++;
      if ( i < argc ) {
	strcpy(gsPageStr, argv[i]);
      }
      continue;
    }
    else if ( strcmp(argv[i], "-nh") == 0 ) {
      /* No header */
      guHeader = 0;
      continue;
    }
    else if ( strcmp(argv[i], "-e") == 0 ) {
      /* EUC printing */
      guKanjiCode = 1;
      strcpy(gsKanjiFont, EUC_KANJI);
      strcpy(gsBoldKanjiFont, EUC_KANJI_BOLD);
      strcpy(gsBoldItalicKanjiFont, EUC_KANJI_BOLDITALIC);
      continue;
    }
    else if ( strcmp(argv[i], "-j") == 0 ) {
      /* JIS printing */
      guKanjiCode = 0;
      strcpy(gsKanjiFont, KANJI);
      strcpy(gsBoldKanjiFont, KANJI_BOLD);
      strcpy(gsBoldItalicKanjiFont, KANJI_BOLDITALIC);
      continue;
    }
#ifdef	TEKTRO
    else if ( strcmp(argv[i], "-copy") == 0 ) {
      /* Number of paper */
      i++;
      if ( i < argc ) {
	copy = atoi(argv[i]);
      }
      else {
	copy = 1;
      }
      if ( copy < 1 ) copy = 1;
      continue;
    }
    else if ( strcmp(argv[i], "-dup") == 0 ) {
      /* Both side */
      dup = 1;
      continue;
    }
#endif
    else if ( strcmp(argv[i], "-h") == 0 || strcmp(argv[i], "--help") == 0 ) {
      /* Help */
      help(NULL);
    }
    else if ( strcmp(argv[i], "-v") == 0 || strcmp(argv[i], "--version") == 0 ) {
      /* Version */
      while ( strstr(argv[0], "/") ) {
	argv[0] = strstr(argv[0], "/") + 1;
      }
      if ( guJapanese ) {
	printf("%s θߤΥС Version %.2f (%s) Ǥ\n", argv[0], VERSION/100.0, DATE);
      }
      else {
	printf("%s's version is %.2f (%s).\n", argv[0], VERSION/100.0, DATE);
      }
      exit(0);
    }
    else if ( strcmp(argv[i], "-fl") == 0 ) {
      /* Print Font List */
      if ( guJapanese ) {
	printf("\nեȥꥹ\n");
	printf("%s", ps_font(NULL, NULL));
	/*  printf("Ryumin-Light-H\n"); */
	/*  printf("Ryumin-Light-H-Italic\n"); */
	/*  printf("Ryumin-Light-EUC-H\n"); */
	/*  printf("Ryumin-Light-EUC-H-Italic\n"); */
	/*  printf("GothicBBB-Medium-H\n"); */
	/*  printf("GothicBBB-Medium-H-Italic\n"); */
	/*  printf("GothicBBB-Medium-EUC-H\n"); */
	/*  printf("GothicBBB-Medium-EUC-H-Italic\n\n"); */
      }
      else {
	printf("\nFont Lists\n");
	printf("%s", ps_font(NULL, NULL));
	/*  printf("Ryumin-Light-H\n"); */
	/*  printf("Ryumin-Light-H-Italic\n"); */
	/*  printf("Ryumin-Light-EUC-H\n"); */
	/*  printf("Ryumin-Light-EUC-H-Italic\n"); */
	/*  printf("GothicBBB-Medium-H\n"); */
	/*  printf("GothicBBB-Medium-H-Italic\n"); */
	/*  printf("GothicBBB-Medium-EUC-H\n"); */
	/*  printf("GothicBBB-Medium-EUC-H-Italic\n\n"); */
      }
      exit(0);
    }
    else if ( strcmp(argv[i], "-lib") == 0 ) {
      /* Environment */
      /* Version */
      while ( strstr(argv[0], "/") ) {
	argv[0] = strstr(argv[0], "/") + 1;
      }
      if ( guJapanese ) {
	printf("ޥ̾               : %s\n", argv[0]);
	printf("                   : %s\n", CREATOR);
	printf("С               : Version %.2f\n", VERSION/100.0);
	printf("                   : %s\n", DATE);
	printf("եȥ           : %.2f\n", FONTSIZE);
	printf("                   : %d\n", TABSTOP);
	printf("Ψ                   : %.2f\n", NLRATE);
	printf("Կ                 : %d\n", MAXLINE);
	printf("ѻ;               : %.2f\n", TOP);
	printf("ѻ沼;               : %.2f\n", BOTTOM);
	printf("ѻ溸;               : %.2f\n", LEFT);
	printf("ѻ汦;               : %.2f\n", RIGHT);
	printf("Ψ       : %.2f\n", gfAsciiWidth);
	printf("Ψ       : %.2f\n", gfAsciiHeight);
	printf("ե     : %s\n", gsBoldAsciiFont);
	printf("Υե : %s\n", gsBoldItalicAsciiFont);
	printf("Ψ           : %.2f\n", gfKanjiWidth);
	printf("Ψ           : %.2f\n", gfKanjiHeight);
	printf("ե             : %s\n", gsKanjiFont);
	printf("ե         : %s\n", gsBoldKanjiFont);
	printf("Υե     : %s\n", gsBoldItalicKanjiFont);
      }
      else {
	printf("Command Name             : %s\n", argv[0]);
	printf("Creator                  : %s\n", CREATOR);
	printf("Version                  : Version %.2f\n", VERSION/100.0);
	printf("Created Date             : %s\n", DATE);
	printf("Font Size                : %.2f\n", FONTSIZE);
	printf("Tab Width                : %d\n", TABSTOP);
	printf("Space Ratio              : %.2f\n", NLRATE);
	printf("Max Lines                : %d\n", MAXLINE);
	printf("Top    Margin            : %.2f\n", TOP);
	printf("Bottom Margin            : %.2f\n", BOTTOM);
	printf("Left   Margin            : %.2f\n", LEFT);
	printf("Right  Margin            : %.2f\n", RIGHT);
	printf("ASCII Font Print Width   : %.2f\n", gfAsciiWidth);
	printf("ASCII Font Print Height  : %.2f\n", gfAsciiHeight);
	printf("ASCII Font               : %s\n", gsAsciiFont);
	printf("ASCII Bold Font          : %s\n", gsBoldAsciiFont);
	printf("ASCII Bold Italic Font   : %s\n", gsBoldItalicAsciiFont);
	printf("KANJI Font Print Width   : %.2f\n", gfKanjiWidth);
	printf("KANJI Font Print Height  : %.2f\n", gfKanjiHeight);
	printf("KANJI Font               : %s\n", gsKanjiFont);
	printf("KANJI Bold Font          : %s\n", gsBoldKanjiFont);
	printf("KANJI Bold Italic Font   : %s\n", gsBoldItalicKanjiFont);
      }
      exit(0);
    }
    else if ( ( read = fopen(argv[i], "r") ) != NULL ) {
      /* File existence */
      fclose(read);
      if ( files < 256 ) {
	filename[files] = argv[i];
	files++;
      }
      else {
	if ( guJapanese ) {
	  strcpy(string, "ꤷե256ۤޤ");
	}
	else {
	  strcpy(string, "Files for printing are over 256.");
	}
	exit(0);
      }
    }
    else {
      /* Mistake of arg */
      if ( guJapanese ) {
	sprintf(string, "˴ְ㤤ޤ==> %s", argv[i]);
      }
      else {
	sprintf(string, "Wrong argment==> %s", argv[i]);
      }
      help(string);
    }
  }

  /* Set Max Lines */
  if ( guStyle > 2 &&
       !strcmp(gsAsciiFont, "Courier") &&
       giMaxLine == MAXLINE &&
       giWidth   == A4WIDTH &&
       giHeight  == A4HEIGHT &&
       gfFontSize  == FONTSIZE &&
       (int)(gfNlRate*10) == (int)(NLRATE*10) ) {
    giMaxLine = MAXLINE;
  }

  /* Pipe */
  if ( lpr ) {
    if ( printer[0] != '\0' ) {
      sprintf(string, "lpr -P %s", printer);
    }
    else {
      strcpy(string, "lpr");
    }
    if ( ( gpfOut = popen(string, "w") ) == NULL ) {
      if ( guJapanese ) {
	fprintf(stderr, "ѥפĤʤޤ\n");
      }
      else {
	fprintf(stderr, "Cannot make pipe.\n");
      }
      gpfOut = stdout;
    }
  }

  /* Standard In */
  if ( files == 0 ) {
    filename[files++] = "stdin";
  }

  /* Start Input and Output */
  /* Header */
  fprintf(gpfOut, "%%!PS-Adobe-2.0 EPSF-1.2\n");
  fprintf(gpfOut, "%%%%Title:");
  for ( file = 0 ; file < files ; file++ ) {
    fprintf(gpfOut, " %s", filename[file]);
  }
  fprintf(gpfOut, "\n");
  fprintf(gpfOut, "%%%%Creator: %s\n", CREATOR);
  fprintf(gpfOut, "%%%%CreationDate: %s\n", gsNowTime);
  fprintf(gpfOut, "%%%%Pages: (atend)\n");
  fprintf(gpfOut, "%%%%PageOrder: Ascend\n");
  fprintf(gpfOut, "%%%%DocumentPaperSizes: %s\n", paper);
  fprintf(gpfOut, "%%%%Orientation: Portrait\n");
#ifdef	TEKTRO
  /* Number of paper */
  fprintf(gpfOut, "%%%%Requirements: numcopies(%d) collate\n", copy);
#endif
  fprintf(gpfOut, "%%%%EndComments\n\n");
#ifdef	TEKTRO
  /* Number of Paper */
  fprintf(gpfOut, "/#copies %d def\n\n", copy);
  /* Both side */
  if ( dup ) {
    fprintf(gpfOut, "[{\n");
    fprintf(gpfOut, "%%%%BeginFeature: *Duplex DuplexTumble\n\n");
    fprintf(gpfOut, "        <</Duplex true /Tumble false>> setpagedevice\n");
    fprintf(gpfOut, "%%%%EndFeature\n");
    fprintf(gpfOut, "} stopped cleartomark\n\n");
  }
#endif

  /* Set Fonts */
  fprintf(gpfOut, "/A-R { /%s findfont %.2f scalefont [1 0 0 1 0 0.12] makefont setfont } bind def\n", gsAsciiFont, gfFontSize);
  fprintf(gpfOut, "/A-B { /%s findfont %.2f scalefont [1 0 0 1 0 0.12] makefont setfont } bind def\n", gsBoldAsciiFont, gfFontSize);
  fprintf(gpfOut, "/A-BI { /%s findfont %.2f scalefont [1 0 0 1 0 0.12] makefont setfont } bind def\n", gsBoldItalicAsciiFont, gfFontSize);
  fprintf(gpfOut, "/K-R { /%s findfont %.2f scalefont setfont } bind def\n", gsKanjiFont, gfFontSize);
  fprintf(gpfOut, "/K-B { /%s findfont %.2f scalefont setfont } bind def\n", gsBoldKanjiFont, gfFontSize);
  fprintf(gpfOut, "/K-BI { /%s findfont %.2f scalefont [1 0 0.3 1 0 0] makefont setfont } bind def\n", gsBoldKanjiFont, gfFontSize);
  fprintf(gpfOut, "\n");
  if ( guKanjiCode ) {
    fprintf(gpfOut, "%% Copy Font\n");
    fprintf(gpfOut, "/copyfont {\n");
    fprintf(gpfOut, "    dup maxlength 1 add dict begin\n");
    fprintf(gpfOut, "    {\n");
    fprintf(gpfOut, "        1 index /FID ne 2 index /UniqueID ne and\n");
    fprintf(gpfOut, "        {def} {pop pop} ifelse\n");
    fprintf(gpfOut, "    } forall\n");
    fprintf(gpfOut, "    currentdict\n");
    fprintf(gpfOut, "    end\n");
    fprintf(gpfOut, "} bind def\n\n");
    fprintf(gpfOut, "%% Merge Font  From tgif\n");
    fprintf(gpfOut, "/mergefont {\n");
    fprintf(gpfOut, "    12 dict begin\n");
    fprintf(gpfOut, "        dup type /nametype eq { findfont } if\n");
    fprintf(gpfOut, "        dup /WMode known {\n");
    fprintf(gpfOut, "            dup /WMode get /WMode exch def\n");
    fprintf(gpfOut, "            WMode 1 eq {\n");
    fprintf(gpfOut, "                [0.0 1.0 -1.0 0.0 0.0 0.3] makefont\n");
    fprintf(gpfOut, "            } if\n");
    fprintf(gpfOut, "        } if\n");
    fprintf(gpfOut, "        copyfont dup begin\n");
    fprintf(gpfOut, "            /Encoding Encoding\n");
    fprintf(gpfOut, "            FMapType dup 2 eq {\n");
    fprintf(gpfOut, "                pop 128 128\n");
    fprintf(gpfOut, "            } { 5 eq {\n");
    fprintf(gpfOut, "                256 256\n");
    fprintf(gpfOut, "            } {\n");
    fprintf(gpfOut, "                /compositefont errordict /invalidfont get exec\n");
    fprintf(gpfOut, "            } ifelse\n");
    fprintf(gpfOut, "            } ifelse\n");
    fprintf(gpfOut, "            getinterval def\n");
    fprintf(gpfOut, "        end\n");
    fprintf(gpfOut, "        /kanjifont exch definefont\n");
    fprintf(gpfOut, "        exch\n");
    fprintf(gpfOut, "\n");
    fprintf(gpfOut, "        dup type /nametype eq { findfont } if\n");
    fprintf(gpfOut, "        exch\n");
    fprintf(gpfOut, "\n");
    fprintf(gpfOut, "        /FDepVector [ 4 2 roll ] def\n");
    fprintf(gpfOut, "        /FontType 0 def\n");
    fprintf(gpfOut, "        /FMapType 4 def\n");
    fprintf(gpfOut, "        /FontMatrix matrix def\n");
    fprintf(gpfOut, "        /Encoding [ 0 1 ] def\n");
    fprintf(gpfOut, "        /FontBBox {0 0 0 0} def\n");
    fprintf(gpfOut, "        dup /FontName exch def\n");
    fprintf(gpfOut, "        currentdict\n");
    fprintf(gpfOut, "    end\n");
    fprintf(gpfOut, "    definefont pop\n");
    fprintf(gpfOut, "} def\n");
    fprintf(gpfOut, "\n");
    fprintf(gpfOut, "/HEAD /Helvetica /Ryumin-Light-EUC-H mergefont\n");
    fprintf(gpfOut, "/HEAD-BOLD /Helvetica-Bold /GothicBBB-Medium-EUC-H mergefont\n");
  }
  else {
    fprintf(gpfOut, "/HEAD { /Helvetica } bind def\n");
    fprintf(gpfOut, "/HEAD-BOLD { /Helvetica-Bold } bind def\n");
  }
  fprintf(gpfOut, "\n\n");

  /* Page */
  giPsPage = 0;
  
  if ( guStyle < 3 ) {
    /* Exchange */
    ftmp = giWidth;
    giWidth = giHeight;
    giHeight = ftmp;
  }

  /* Max Width */
  maxwidth = giWidth - gfRightMargin;

  /* File Loop */
  for ( file = 0 ; file < files ; file++ ) {
    filedata = NULL;
    /* Read from ? */
    if ( strcmp(filename[file], "stdin") ) {
      /* File */
      read = fopen(filename[file], "r");
    }
    else {
      /* Standard Input */
      read = stdin;
    }
    /* Read File */
    while ( fgets(string, STRMAX, read) ) {
      filedata = addstring(filedata, string);
    }
    fclose(read);
    /* Change to EUC */
    ctmp = change2euc(filedata);
    free(filedata);
    filedata = ctmp;
    
    /* Setting before printing */
    giPage = 0;
    giLine = 1;
    newpage(filename[file]);
    mode = 0;
    char_count = 0;
    ps_font(gsAsciiFont, gafFontsize[0]);
    ps_font(gsBoldItalicAsciiFont, gafFontsize[1]);
    string[0] = '\0';
    for ( index = 0 ; ( ch = *(filedata+index) ) != '\0' ; index++ ) {
      if ( ch == NEWPAGE ) {
	/* New Page */
	newpage(filename[file]);
	giLine = 1;
	continue;
      }
      if ( ch == NEWLINE ) {
	/* New Line */
	newline(mode, string, filename[file]);
	string[0] = '\0';
	char_count = 0;
	continue;
      }
      if ( ch == TAB ) {
	/* TAB */
	if ( mode != 0 ) {
	  print(mode, string);
	  string[0] = '\0';
	}
	for ( j = 0 ; j < TABSTOP - ( char_count % TABSTOP ) ; j++ )
	  strcat(string, " ");
	mode = 0;
	/* String width */
	gfX += gafFontsize[0][' '] * gfAsciiWidth/ASCIIWIDTH *
	  ( TABSTOP - ( char_count % TABSTOP ) ) * gfFontSize;
	char_count += TABSTOP - ( char_count % TABSTOP );
	/* New Line? */
	if ( gfX >= maxwidth && *(filedata+index+1) != '\n' ) {
	  newline(mode, string, filename[file]);
	  string[0] = '\0';
	  char_count = 0;
	}
	continue;
      }
      if ( ch == '_' && *(filedata+index+1) == BACKSPACE ) {
	/* Back Space */
	if ( ( *(filedata+index+2) & 128 ) == 0 ) {
	  if ( mode != 2 ) {
	    print(mode, string);
	    string[0] = '\0';
	  }
	  strcat(string, escape(*(filedata+index+2)));
	  index += 2;
	  char_count++;
	  mode = 2;
	  /* String width */
	  /*  ps_font(gsBoldItalicAsciiFont, gafFontsize); */
	  gfX += gafFontsize[1][(int)*(filedata+index+2)] *
	    gfAsciiWidth/ASCIIWIDTH * gfFontSize;
	  /*  ps_font(gsAsciiFont, gafFontsize); */
	  /* New Line? */
	  if ( gfX >= maxwidth && *(filedata+index+1) != '\n' ) {
	    newline(mode, string, filename[file]);
	    string[0] = '\0';
	    char_count = 0;
	  }
	}
	else {
	  if ( mode != 3 ) {
	    print(mode, string);
	    string[0] = '\0';
	  }
	  strcat(string, escape(*(filedata+index+2)));
	  strcat(string, escape(*(filedata+index+3)));
	  index += 3;
	  char_count++;
	  char_count++;
	  mode = 3;
	  /* String width */
	  /*  gfX += gfFontSize * 1.2; */
	  gfX += gfFontSize * gfKanjiWidth;
	  /* New Line? */
	  if ( gfX >= maxwidth && *(filedata+index+1) != '\n' ) {
	    newline(mode, string, filename[file]);
	    string[0] = '\0';
	    char_count = 0;
	  }
	}
	continue;
      }
      if ( ( ch & 0x80 ) == 0 ) {
	if ( mode != 0 ) {
	  print(mode, string);
	  string[0] = '\0';
	}
	strcat(string, escape(ch));
	char_count++;
	mode = 0;
	/* String width */
	gfX += gafFontsize[0][(int)ch] * gfAsciiWidth/ASCIIWIDTH * gfFontSize;
	/* New Line? */
	if ( gfX >= maxwidth && *(filedata+index+1) != '\n' ) {
	  newline(mode, string, filename[file]);
	  string[0] = '\0';
	  char_count = 0;
	}
      }
      else {
	if ( mode != 1 ) {
	  print(mode, string);
	  string[0] = '\0';
	}
	strcat(string, escape(ch));
	ch = *(filedata+(++index));
	strcat(string, escape(ch));
	char_count++;
	char_count++;
	mode = 1;
	/* String width */
	/*  gfX += gfFontSize * 1.2; */
	gfX += gfFontSize * gfKanjiWidth;
	/* New Line? */
	if ( gfX >= maxwidth && *(filedata+index+1) != '\n' ) {
	  newline(mode, string, filename[file]);
	  string[0] = '\0';
	  char_count = 0;
	}
      }
    }
    print(mode, string);
    string[0] = '\0';
    char_count = 0;
    fprintf(gpfOut, "\n\ngrestore\n\nshowpage\n\n");
    free(filedata);
  }
  /* Finish */
  fprintf(gpfOut, "%%%%Trailer\n");

  if ( lpr ) {
    pclose(gpfOut);
  }
  else {
    fclose(gpfOut);
  }

  /* Number of pages */
  if ( guJapanese ) {
    fprintf(stderr, "%% %d ڡ\n", giPsPage);
  }
  else {
    fprintf(stderr, "%% %d pages output.\n", giPsPage);
  }

  if ( gsCommand != NULL ) free(gsCommand);

  return 0;
}


/* Print */
void print(int mode, char *string) {
  int	i;

  if ( string[0] != '\0' ) {
    switch ( mode ) {
    case 0:
      /* ASCII */
      print_font(gsAsciiFont);
      fprintf(gpfOut, "%.2f %.2f scale\n", gfAsciiWidth/ASCIIWIDTH, gfAsciiHeight);
      fprintf(gpfOut, "(%s) show\n", string);
      fprintf(gpfOut, "1.0 %.2f div 1.0 %.2f div scale\n", gfAsciiWidth/ASCIIWIDTH, gfAsciiHeight);
      break;
    case 1:
      /* KANJI */
      print_font(gsKanjiFont);
      if ( guKanjiCode ) {
	/*  fprintf(gpfOut, "%.2f 0 (%s) ashow\n", gfFontSize * 0.2, string); */
	if ( gfKanjiWidth >= 1.0 ) {
	  /* Kanji font (default width=1.2) */
	  fprintf(gpfOut, "%.2f 0 (%s) ashow\n", gfFontSize * (gfKanjiWidth-1.0), string);
	}
	else {
	  fprintf(gpfOut, "%.2f %.2f scale\n", gfKanjiWidth-0.2, gfKanjiHeight);
	  fprintf(gpfOut, "(%s) show\n", string);
	  fprintf(gpfOut, "1.0 %.2f div 1.0 %.2f div scale\n", gfKanjiWidth-0.2, gfKanjiHeight);
	}
      }
      else {
	/* For printers without EUC fonts */
	/* Change to JIS Code */
	/*  fprintf(gpfOut, "%.2f 0 (", gfFontSize * 0.2); */
	if ( gfKanjiWidth >= 1.0 ) {
	  fprintf(gpfOut, "%.2f 0 (", gfFontSize * (gfKanjiWidth-1.0));
	  for ( i = 0 ; *(string+i) != '\0' ; i++ ) {
	    fprintf(gpfOut, "\\%03o", *(string+i) & 0x7f);
	  }
	  fprintf(gpfOut, ") ashow\n");
	}
	else {
	  fprintf(gpfOut, "%.2f %.2f scale\n", gfKanjiWidth-0.2, gfKanjiHeight);
	  fprintf(gpfOut, "(");
	  for ( i = 0 ; *(string+i) != '\0' ; i++ ) {
	    fprintf(gpfOut, "\\%03o", *(string+i) & 0x7f);
	  }
	  fprintf(gpfOut, ") show\n");
	  fprintf(gpfOut, "1.0 %.2f div 1.0 %.2f div scale\n", gfKanjiWidth-0.2, gfKanjiHeight);
	}
      }
      break;
    case 2:
      /* Bold Italic ASCII */
      print_font(gsBoldItalicAsciiFont);
      fprintf(gpfOut, "%.2f %.2f scale\n", gfAsciiWidth/ASCIIWIDTH, gfAsciiHeight);
      fprintf(gpfOut, "(%s) show\n", string);
      fprintf(gpfOut, "1.0 %.2f div 1.0 %.2f div scale\n", gfAsciiWidth/ASCIIWIDTH, gfAsciiHeight);
      break;
    case 3:
      /* Bold Italic KANJI */
      print_font(gsBoldItalicKanjiFont);
      if ( guKanjiCode ) {
	/*  fprintf(gpfOut, "%.2f 0 (%s) ashow\n", gfFontSize * 0.2, string); */
	if ( gfKanjiWidth >= 1.0 ) {
	  fprintf(gpfOut, "%.2f 0 (%s) ashow\n", gfFontSize * (gfKanjiWidth-1.0), string);
	}
	else {
	  fprintf(gpfOut, "%.2f %.2f scale\n", gfKanjiWidth-0.2, gfKanjiHeight);
	  fprintf(gpfOut, "(%s) show\n", string);
	  fprintf(gpfOut, "1.0 %.2f div 1.0 %.2f div scale\n", gfKanjiWidth-0.2, gfKanjiHeight);
	}
      }
      else {
	/* For printers without EUC fonts */
	/* Change to JIS Code */
	/*  fprintf(gpfOut, "%.2f 0 (", gfFontSize * 0.2); */
	if ( gfKanjiWidth >= 1.0 ) {
	  fprintf(gpfOut, "%.2f 0 (", gfFontSize * (gfKanjiWidth-1.0));
	  for ( i = 0 ; *(string+i) != '\0' ; i++ ) {
	    fprintf(gpfOut, "\\%03o", *(string+i) & 0x7f);
	  }
	  fprintf(gpfOut, ") ashow\n");
	}
	else {
	  fprintf(gpfOut, "%.2f %.2f scale\n", gfKanjiWidth-0.2, gfKanjiHeight);
	  fprintf(gpfOut, "(");
	  for ( i = 0 ; *(string+i) != '\0' ; i++ ) {
	    fprintf(gpfOut, "\\%03o", *(string+i) & 0x7f);
	  }
	  fprintf(gpfOut, ") show\n");
	  fprintf(gpfOut, "1.0 %.2f div 1.0 %.2f div scale\n", gfKanjiWidth-0.2, gfKanjiHeight);
	}
      }
      break;
    }
  }

  return;
}


/* New Line */
void newline(int mode, char *string, char *filename) {
  print(mode, string);
  gfX = gfLeftMargin;
  gfY -= gfFontSize * gfNlRate;
  giLine++;
  /* New Page? */
  if ( gfY < gfLeftMargin || giLine > giMaxLine ) {
    /* New Page */
    newpage(filename);
    giLine = 1;
  }
  else {
    fprintf(gpfOut, "\n%.2f %.2f moveto\n", gfX, gfY);
  }

  return;
}


/* New Page */
void newpage(char *filename) {
  char	string[STRMAX];

  /* Page++ */
  giPage++;
  if ( giPage > 1 ) fprintf(gpfOut, "\n\ngrestore\n\n");
  /* PosctScript Page++? */
  if (
      ( guStyle == 0 ) ||
      ( guStyle == 1 && ( giPage % 2 ) == 1 ) ||
      ( guStyle == 2 && ( giPage % 4 ) == 1 ) ||
      ( guStyle == 3 ) ||
      ( guStyle == 4 && ( giPage % 2 ) == 1 ) ||
      ( guStyle == 5 && ( giPage % 4 ) == 1 )
      ) {
    giPsPage++;
    if ( giPage > 1 ) fprintf(gpfOut, "showpage\n\n");
    fprintf(gpfOut, "%%%%Page: %d %d\n\n", giPsPage, giPsPage);
    /* First Position */
    gfX = gfLeftMargin;
    gfY = giHeight - gfTopMargin;
  }
  /* Keep PostScript State */
  fprintf(gpfOut, "gsave\n\n");
  switch ( guStyle ) {
  case 0:
    /* Landscape */
    fprintf(gpfOut, "90 rotate\n");
    fprintf(gpfOut, "0 -%d translate\n", giHeight);
    break;
  case 1:
    /* Landscape Double */
    fprintf(gpfOut, "%.2f %.2f scale\n", SQRT, SQRT);
    if ( ( giPage % 2 ) == 1 ) {
      /* Odd page */
      fprintf(gpfOut, "0 %d translate\n", giHeight);
    }
    break;
  case 2:
    /* Landscape Quartet */
    fprintf(gpfOut, "0.5 0.5 scale\n");
    fprintf(gpfOut, "90 rotate\n");
    switch ( giPage % 4 ) {
    case 1:
      fprintf(gpfOut, "0 -%d translate\n", giHeight);
      break;
    case 2:
      fprintf(gpfOut, "0 -%d translate\n", 2*giHeight);
      break;
    case 3:
      fprintf(gpfOut, "%d -%d translate\n", giWidth, giHeight);
      break;
    case 0:
      fprintf(gpfOut, "%d -%d translate\n", giWidth, 2*giHeight);
      break;
    }
  case 3:
    /* Portrait */
    /* Do nothing */
    break;
  case 4:
    /* Portrait Double */
    fprintf(gpfOut, "%.2f %.2f scale\n", SQRT, SQRT);
    fprintf(gpfOut, "90 rotate\n");
    switch ( giPage % 2 ) {
    case 1:
      /* Odd page */
      fprintf(gpfOut, "0 -%d translate\n", giHeight);
      break;
    case 0:
      /* Even page */
      fprintf(gpfOut, "%d -%d translate\n", giWidth, giHeight);
      break;
    }
    break;
  case 5:
    fprintf(gpfOut, "0.5 0.5 scale\n");
    switch ( giPage % 4 ) {
    case 1:
      fprintf(gpfOut, "0 %d translate\n", giHeight);
      break;
    case 2:
      fprintf(gpfOut, "%d %d translate\n", giWidth, giHeight);
      break;
    case 3:
      break;
    case 0:
      fprintf(gpfOut, "%d 0 translate\n", giWidth);
      break;
    }
  }
  /* Box printing */
  if ( guBox ) {
    fprintf(gpfOut, "\ngsave\n");
    fprintf(gpfOut, "  1.0 setlinewidth \n");
    fprintf(gpfOut, "  newpath\n");
    fprintf(gpfOut, "  %.2f %.2f moveto\n", LEFT-5.0, BOTTOM-5.0);
    fprintf(gpfOut, "  %.2f %.2f lineto\n", LEFT-5.0, giHeight-TOP+15.0);
    fprintf(gpfOut, "  %.2f %.2f lineto\n", giWidth-RIGHT+5.0, giHeight-TOP+15.0);
    fprintf(gpfOut, "  %.2f %.2f lineto\n", giWidth-RIGHT+5.0, BOTTOM-5.0);
    fprintf(gpfOut, "  closepath\n");
    fprintf(gpfOut, "  %.2f %.2f moveto\n", LEFT-5.0, giHeight-TOP-5.0);
    fprintf(gpfOut, "  %.2f %.2f lineto\n", giWidth-RIGHT+5.0, giHeight-TOP-5.0);
    fprintf(gpfOut, "  stroke\n");
    fprintf(gpfOut, "grestore\n");
  }
  /* First Position */
  fprintf(gpfOut, "\n%.2f %.2f moveto\n", (gfX = gfLeftMargin), (gfY = (float)giHeight-gfTopMargin));
  /* Header */
  if ( guHeader ) {
    fprintf(gpfOut, "\n%% Header\n");
    /* Date*/
    fprintf(gpfOut, "HEAD findfont 12 scalefont setfont\n");
    fprintf(gpfOut, "(%s) show\n", gsNowTime);
    /* FileName */
    if ( gsHeadStr[0] != '\0' ) {
      strcpy(string, gsHeadStr);
    }
    else {
      strcpy(string, filename);
    }
    fprintf(gpfOut, "HEAD-BOLD findfont 14 scalefont setfont\n");
    fprintf(gpfOut, "%.2f (%s) stringwidth pop sub 2 div %.2f moveto\n", (float)giWidth, string, gfY);
    fprintf(gpfOut, "(%s) show\n", string);
    /* Page */
    fprintf(gpfOut, "HEAD findfont 12 scalefont setfont\n");
    fprintf(gpfOut, "%.2f (%s %d) stringwidth pop sub %.2f moveto\n", giWidth-gfRightMargin, gsPageStr, giPage, gfY);
    fprintf(gpfOut, "(%s %d) show\n\n", gsPageStr, giPage);
    /* Move */
    gfY -= gfFontSize * gfNlRate + 14.0;
    fprintf(gpfOut, "%.2f %.2f moveto\n", gfX, gfY);
  }

  return;
}


/* Font */
void print_font(char *font) {
  if ( !strcmp(font, gsAsciiFont) ) {
    fprintf(gpfOut, "A-R  ");
  }
  else if ( !strcmp(font, gsKanjiFont) ) {
    fprintf(gpfOut, "K-R  ");
  }
  else if ( !strcmp(font, gsBoldItalicAsciiFont) ) {
    fprintf(gpfOut, "A-BI ");
  }
  else if ( !strcmp(font, gsBoldItalicKanjiFont) ) {
    fprintf(gpfOut, "K-BI ");
  }

  return;
}


/* Escape */
char *escape(char ch) {
  if ( ch == '(' || ch == ')' || ch == '<' || ch == '>' || ch == '\\' ) {
    sprintf(gsEscapedStr, "\\%c", ch);
  }
  else {
    sprintf(gsEscapedStr, "%c", ch);
  }

  return gsEscapedStr;
}


/* malloc string area */
char *setstring(char *string) {
  char	*sMalloc;

  if ( string == NULL || *string == '\0' ) return NULL;

  if ( ( sMalloc = (char *)malloc(sizeof(char)*(strlen(string)+1)) ) == NULL ) {
    if ( guJapanese ) {
      fprintf(stderr, "꤬­ޤ\n");
    }
    else {
      fprintf(stderr, "Memory overflow.\n");
    }
    exit(0);
  }

  strcpy(sMalloc, string);

  return sMalloc;
}


/* string realloc */
char *addstring(char *sOrigin, char *string) {
  char	*sRealloc;
  int	length;

  if ( string == NULL || *string == '\0' ) return sOrigin;

  if ( sOrigin == NULL ) return setstring(string);

  length = strlen(sOrigin) + strlen(string);

  if ( ( sRealloc = (char *)realloc(sOrigin, sizeof(char)*(length+1)) ) == NULL ) {
    if ( guJapanese ) {
      fprintf(stderr, "꤬­ޤ\n");
    }
    else {
      fprintf(stderr, "Memory overflow.\n");
    }
    exit(0);
  }

  strcat(sRealloc, string);

  return sRealloc;
}


/* Signal of Quit */
void quit(int sig) {
  signal(sig, SIG_IGN);

  exit(1);
}


/* Error and Help */
void help(char *string) {
  if ( string != NULL && *string != '\0' ) {
    fprintf(stderr, "\n%s\n", string);
  }

  fprintf(stderr, "\n'%s' Version %.2f (%s) ---  White Tools Presents.\n", gsCommand, VERSION/100.0, DATE);
  fprintf(stderr, "                Copyright (c) %s  %s\n\n", COPYRIGHTYEAR, CREATOR);
  if ( guJapanese ) {
    fprintf(stderr, "Ȥ : %s\n", gsCommand);
    fprintf(stderr, "    [-l|-l2|-l4] [-p|-p2|-p4] [-af ascii-font] [-abf ascii-bold]\n");
    fprintf(stderr, "    [-abif ascii-bolditalic] [-size fontsize] [-ls nlrate] [-line line]\n");
    fprintf(stderr, "    [-a4|-b4|-le] [-ohp] [-box] [-tm margin] [-bm margin] [-lm margin]\n");
    fprintf(stderr, "    [-rm margin][-nh] [-P printer] [-date string] [-head string]\n");
#ifdef	TEKTRO
    fprintf(stderr, "    [-page string] [-e] [-j] [-copy num] [-dup] [-h|--help] [-v|--version] \n");
    fprintf(stderr, "    [-fl] [-lib] [filenames...]\n\n");
#else
    fprintf(stderr, "    [-page string] [-e] [-j] [-h|--help] [-v|--version] [-fl] [-lib]\n");
    fprintf(stderr, "    [filenames...]\n\n");
#endif
    fprintf(stderr, "    -l                        : ɥ\n");
    fprintf(stderr, "    -l2                       : ɥ2ɽ\n");
    fprintf(stderr, "    -l4                       : ɥ4ɽ\n");
    fprintf(stderr, "    -p                        : ݡȥ쥤\n");
    fprintf(stderr, "    -p2                       : ݡȥ쥤2ɽ (ǥե)\n");
    fprintf(stderr, "    -p4                       : ݡȥ쥤4ɽ\n");
    fprintf(stderr, "    -af ascii-font            : ե   (%s)\n", gsAsciiFont);
    fprintf(stderr, "    -abf ascii-bold           : ܡɥե   (%s)\n", gsBoldAsciiFont);
    fprintf(stderr, "    -abif ascii-bolditalic    : ܡɥå (%s)\n", gsBoldItalicAsciiFont);
    fprintf(stderr, "    -size fontsize            : եȥ (%.1f)\n", FONTSIZE);
    fprintf(stderr, "    -afw magnification        : Ψ (%.1f)\n", ASCIIWIDTH);
    fprintf(stderr, "    -afh magnification        : Ψ (%.1f)\n", ASCIIHEIGHT);
    fprintf(stderr, "    -kfw magnification        : Ψ (%.1f)\n", KANJIWIDTH);
    fprintf(stderr, "    -kfh magnification        : Ψ (%.1f)\n", KANJIHEIGHT);
    fprintf(stderr, "    -ls nlrate                : Ψ (%.1f)\n", NLRATE);
    fprintf(stderr, "    -line line                : ڡκԿ (%d)\n", MAXLINE);
    fprintf(stderr, "    -a4                       : A4 (ǥե)\n");
    fprintf(stderr, "    -b4                       : B4\n");
    fprintf(stderr, "    -le                       : 쥿\n");
    fprintf(stderr, "    -ohp                      : OHPѰ (եȥ:%0.1f)\n", OHPFONTSIZE);
    fprintf(stderr, "    -box                      : Ȱ (looks like a2ps)\n");
    fprintf(stderr, "    -tm margin                : ;\n");
    fprintf(stderr, "    -bm margin                : ;\n");
    fprintf(stderr, "    -lm margin                : ;\n");
    fprintf(stderr, "    -rm margin                : ;\n");
    fprintf(stderr, "    -nh                       : إåʤ\n");
    fprintf(stderr, "    -Pprinter                 : ץ󥿥å\n");
    fprintf(stderr, "    -date string              : ʸ (%s)\n", gsNowTime);
    fprintf(stderr, "    -head string              : إåʸ\n");
    fprintf(stderr, "    -page string              : ڡʸ (ǥե:Page)\n");
#ifdef	JIS_PS
    fprintf(stderr, "    -e                        : EUCեȤѤư\n");
    fprintf(stderr, "    -j                        : JISեȤѤư(ǥե)\n");
#else
    fprintf(stderr, "    -e                        : EUCեȤѤư(ǥե)\n");
    fprintf(stderr, "    -j                        : JISեȤѤư\n");
#endif
#ifdef	TEKTRO
    fprintf(stderr, "    -dup                      : ξ̰\n");
    fprintf(stderr, "    -copy number              :  (1)\n");
#endif
    fprintf(stderr, "    -h | --help               : إפɽ\n");
    fprintf(stderr, "    -v | --version            : Сɽ\n");
    fprintf(stderr, "    -fl                       : եȥꥹɽ\n");
    fprintf(stderr, "    -lib                      : ƼĶɽ\n\n");
  }
  else {
    fprintf(stderr, "Usage : %s\n", gsCommand);
    fprintf(stderr, "    [-l|-l2|-l4] [-p|-p2|-p4] [-af ascii-font] [-abf ascii-bold]\n");
    fprintf(stderr, "    [-abif ascii-bolditalic] [-size fontsize] [-ls nlrate] [-line line]\n");
    fprintf(stderr, "    [-a4|-b4|-le] [-ohp] [-box] [-tm margin] [-bm margin] [-lm margin]\n");
    fprintf(stderr, "    [-rm margin] [-nh] [-P printer] [-date string] [-head string]\n");
#ifdef	TEKTRO
    fprintf(stderr, "    [-page string] [-e] [-j] [-copy num] [-dup] [-h|--help] [-v|--version]\n");
    fprintf(stderr, "    [-fl] [-lib] [filenames...]\n\n");
#else
    fprintf(stderr, "    [-page string] [-e] [-j] [-h|--help] [-v|--version] [-fl] [-lib]\n");
    fprintf(stderr, "    [filenames...]\n\n");
#endif
    fprintf(stderr, "    -l                        : landscape\n");
    fprintf(stderr, "    -l2                       : landscape 2 pages/paper\n");
    fprintf(stderr, "    -l4                       : landscape 4 pages/paper\n");
    fprintf(stderr, "    -p                        : portrate\n");
    fprintf(stderr, "    -p2                       : portrate 2 pages/paper (default)\n");
    fprintf(stderr, "    -p4                       : portrate 4 pages/paper\n");
    fprintf(stderr, "    -af ascii-font            : ASCII font (%s)\n", gsAsciiFont);
    fprintf(stderr, "    -abf ascii-bold           : ASCII bold font (%s)\n", gsBoldAsciiFont);
    fprintf(stderr, "    -abif ascii-bolditalic    : ASCII bold italic font (%s)\n", gsBoldItalicAsciiFont);
    fprintf(stderr, "    -size fontsize            : font size (%0.1f)\n", FONTSIZE);
    fprintf(stderr, "    -afw magnification        : ASCII width  (%.1f)\n", ASCIIWIDTH);
    fprintf(stderr, "    -afh magnification        : ASCII height (%.1f)\n", ASCIIHEIGHT);
    fprintf(stderr, "    -kfw magnification        : ASCII width  (%.1f)\n", KANJIWIDTH);
    fprintf(stderr, "    -kfh magnification        : ASCII height (%.1f)\n", KANJIHEIGHT);
    fprintf(stderr, "    -ls nlrate                : space ratio between lines (%0.1f)\n", NLRATE);
    fprintf(stderr, "    -line line                : max lines (%d)\n", MAXLINE);
    fprintf(stderr, "    -a4                       : A4 paper (default)\n");
    fprintf(stderr, "    -b4                       : B4 paper\n");
    fprintf(stderr, "    -le                       : letter paper\n");
    fprintf(stderr, "    -ohp                      : OHP printing (font size:%0.1f)\n", OHPFONTSIZE);
    fprintf(stderr, "    -box                      : print page frame-line (looks like a2ps)\n");
    fprintf(stderr, "    -tm margin                : top    margin\n");
    fprintf(stderr, "    -bm margin                : bottom margin\n");
    fprintf(stderr, "    -lm margin                : left   margin\n");
    fprintf(stderr, "    -rm margin                : right  margin\n");
    fprintf(stderr, "    -nh                       : not print headers\n");
    fprintf(stderr, "    -Pprinter                 : printer\n");
    fprintf(stderr, "    -date string              : date string (%s)\n", gsNowTime);
    fprintf(stderr, "    -head string              : header string\n");
    fprintf(stderr, "    -page string              : page string (Page)\n");
#ifdef	JIS_PS
    fprintf(stderr, "    -e                        : print with EUC postscript font\n");
    fprintf(stderr, "    -j                        : print with JIS postscript font(default)\n");
#else
    fprintf(stderr, "    -e                        : print with EUC postscript font(default)\n");
    fprintf(stderr, "    -j                        : print with JIS postscript font\n");
#endif
#ifdef	TEKTRO
    fprintf(stderr, "    -dup                      : double side printing\n");
    fprintf(stderr, "    -copy number              : number of papers (1)\n");
#endif
    fprintf(stderr, "    -h | --help               : show help\n");
    fprintf(stderr, "    -v | --version            : show version\n");
    fprintf(stderr, "    -fl                       : show font list\n");
    fprintf(stderr, "    -lib                      : show library\n\n");
  }

  exit(1);
}


/*=============================================================================
			end
=============================================================================*/
