#
#   eagleconfig: configuration utility for eagle USB modems
#
#   Copyright (C) 2003 Jerome Marant <jerome.marant@sagem.com>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License Version 2 as 
#   published by the Free Software Foundation.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#   or contact the author.
#
#   $Id: mandrake.pl,v 1.1 2004/02/15 12:50:16 Tux Exp $
#

use File::Copy;

my $sysconfig_dir = $etcdir . '/sysconfig';
my $netscripts_dir = $sysconfig_dir . '/network-scripts';

my $netscript = $netscripts_dir . '/ifcfg-' . $interface;
my $network = $sysconfig_dir . '/network';

sub static ($$)
  {
    my ($ip, $netmask) = @_;

    if (-e "$netscript" && ! -e "$netscript.eagleconfig_save")
      {
	move ("$netscript", "$netscript.eagleconfig_save");
      }

    open NETSCRIPT, ">$netscript" or die "Error: Could not create $netscript.";
    print NETSCRIPT "#\n# Generated by eagleconfig\n#\n\n";
    print NETSCRIPT "BOOTPROTO=static\n";
    print NETSCRIPT "DEVICE=$interface\n";
    print NETSCRIPT "IPADDR=$ip\n";
    print NETSCRIPT "NETMASK=$netmask\n";
    print NETSCRIPT "ONBOOT=yes\n";
    #print NETSCRIPT "BROADCAST=";
    close NETSCRIPT;
  }

sub dhcp
  {
    if (-e "$netscript" && ! -e "$netscript.eagleconfig_save")
      {
	move ("$netscript", "$netscript.eagleconfig_save");
      }

    open NETSCRIPT, ">$netscript" or die "Error: Could not create $netscript.";
    print NETSCRIPT "BOOTPROTO=dhcp\n";
    close NETSCRIPT;

  }

sub dns ($$)
  {
    my ($dns1, $dns2) = @_;

    if (-e "$resolv_conf" && ! -e "$resolv_conf.eagleconfig_save")
      {
	move ("$resolv_conf", "$resolv_conf.eagleconfig_save");
      }

    open RESOLVCONF, ">$resolv_conf" or die "Error: Could not create $resolv_conf.";
    print RESOLVCONF "nameserver $dns1\n";
    print RESOLVCONF "nameserver $dns2\n" if ($dns2 ne "");
    close RESOLVCONF;
      
  }

sub gateway_config ($)
  {
    my ($gateway) = @_;

    if (-e "$network" && ! -e "$network.eagleconfig_save")
      {
	move ("$network", "$network.eagleconfig_save");
      }

    open NETWORK, ">$network" or die "Error: Could not create $network.";
    print NETWORK "NETWORKING=yes\n";

    if ($gateway ne "")
      {
	print NETWORK "GATEWAY=$gateway\n";
	print NETWORK "GATEWAY_IF=$interface\n";
      }

    close NETWORK;
  }
