/***************************************************************************
                          vumeter.h  -  description
                             -------------------
    begin                : Sun Mar 18 2001
    copyright            : (C) 2001 by M. Ritscher
    email                : unreachable@gmx.net

    changes: 
    --------
    18.6.2001, adapted to ecamegapedal, (C) 2001 Kai Vehmanen <k@eca.cx>

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INCLUDED_QEVUMETER_H
#define INCLUDED_QEVUMETER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>
#include <qframe.h>
#include <qpen.h>
#include <qpixmap.h>
#include <sample-specs.h>
#include <samplebuffer.h>
#include <eca-version.h>
#include <kvu_locks.h>

#define QE_METER_HEIGHT 6
#define QE_L_Y_OFFS QE_METER_HEIGHT
#define QE_R_Y_OFFS QE_METER_HEIGHT *4
#define QE_X_OFFS 5
#define QE_PEAK_WIDTH 3
#define QE_CHANNELS 2

enum MeterConsts{
  tleft,
  tright,
  cleft,
  cright,
  peakl,
  peakr,
  counterl,
  counterr,
  qe_aver,
  qe_db,
  qe_ConstEnd
};

/**
 * Displays level of captuered audio signal
 * @author M. Ritscher
 * @author Kai Vehmanen
 */
class QEVUMeter : public QFrame
{
  Q_OBJECT
public: 
  QEVUMeter(QWidget *parent=0, const char *name=0);
  ~QEVUMeter();

  void setDelay(int d);
  void timerEvent(QTimerEvent* e);

public slots:
    void dataUpdated(const SAMPLE_BUFFER*);

private: // private functions																
  /** 
   * sets resolution of meter scale
   * 
   * @param res sampling resolution of input device e.g. 8bit 16bit
   */
  void setResolution(int res);

  void newData(void);

  void newData(const unsigned char *buffer,
	       unsigned int uDataStart,
	       unsigned int uDataEnd,
	       unsigned int uBuffer_Size);	

  void prepareBufferDev(void);
	
private: // Private attributes
  QPixmap* BufferDev;
  int t[qe_ConstEnd];
  int* dBTable;
  int scaleMax, scaleFactor, i35dB;
  /** n times (call newDate) -> peakDelay */
  int pDelay;
  int buffer_latency_rep;
  int tablesize_rep;

  /* FIXME: replace with pthread_lock() and pthread_trylock() */
  ATOMIC_INTEGER access_lock_rep, edit_lock_rep;

  bool data_refreshed_rep;
#if ECA_LIBECASOUND_VERSION > 7
  std::vector<std::vector<SAMPLE_SPECS::sample_t> > sbuf_rep;
#else
  std::vector<std::vector<SAMPLE_SPECS::sample_type> > sbuf_rep;
#endif

protected: // Protected methods
  /** No descriptions */
  void paintEvent(QPaintEvent*);
  virtual void resizeEvent(QResizeEvent* ev);
  void mousePressEvent(QMouseEvent *);

signals: // Signals
  /** right mouse button was pressed */
  void rbPressed(QPoint);
};

#endif
