## ------------------------------------------------------------------------
## Check for correct libecasound version
## 
## version: 4
## ------------------------------------------------------------------------
##
AC_DEFUN(AC_CHECK_LIBECASOUND,
[
ecasound_required_interface=$1

AC_PATH_PROG(ECASOUND_CONFIG, ecasound-config, /usr/local/bin/ecasound-config,
 ${prefix}/bin:/usr/bin)

AC_MSG_CHECKING(for libecasound interface version $ecasound_required_interface)


if test x$include_debug = xyes; then
	ecasound_libraries=`$ECASOUND_CONFIG --libs_debug`
	AC_SUBST(ecasound_libraries)
else
	ecasound_libraries=`$ECASOUND_CONFIG --libs`
	AC_SUBST(ecasound_libraries)
fi
ecasound_includes=`$ECASOUND_CONFIG --cflags`
AC_SUBST(ecasound_includes)

CFLAGS="$CFLAGS $ecasound_includes"
LDFLAGS="$LDFLAGS $ecasound_libraries"

AC_LANG_CPLUSPLUS
AC_TRY_RUN([
#include <iostream>
#include <ecasound/eca-version.h>

int main(void)
{
  cerr << ecasound_library_version_current << endl;
  cerr << ecasound_library_version_age << endl;

  if ($ecasound_required_interface <= ecasound_library_version_current &&
      $ecasound_required_interface >= ecasound_library_version_current -
				     ecasound_library_version_age)
	return(0);

	return(-1);
}
],
  [AC_MSG_RESULT(found.)],
  [AC_MSG_RESULT(not present.)
   AC_MSG_WARN(** Compatible interface version of libecasound not found. Will still try compiling... **)]
)
]
)

## ------------------------------------------------------------------------
## Check whether namespaces are supported.
##
## version: 1
## ------------------------------------------------------------------------
##
AC_DEFUN(AC_CHECK_CXX_NAMESPACE_SUPPORT,
[
AC_MSG_CHECKING(if C++ compiler supports namespaces)
AC_LANG_CPLUSPLUS
old_cxx_flags=$CXXFLAGS
CXXFLAGS="-fno-exceptions $CXXFLAGS" # hack around gcc3.x feature
AC_TRY_RUN(
[
#include <string>
#include <vector>

using std::string;

int main(void)
{	
	string s ("foo");
 	std::vector<string> v;
	return(0);
}
],
[ 	
	AC_MSG_RESULT(yes.)
	AC_DEFINE(USE_CXX_STD_NAMESPACE)
],
[
	AC_MSG_RESULT(no.)
]
,
[
	AC_MSG_RESULT(no.)
]
)
CXXFLAGS=$old_cxx_flags
])

## ------------------------------------------------------------------------
## Find the meta object compiler in the PATH, in $QTDIR/bin, and some
## more usual places
## 
## version: 2
## ------------------------------------------------------------------------
##
AC_DEFUN(AC_PATH_QT_MOC,
[
AC_MSG_CHECKING([for QT 2.x moc compiler])

AC_ARG_WITH(qt-dir,
    [  --with-qt-dir           where the root of qt is installed ],
    [  ac_qt_bindir="$withval"/bin
    ])


AC_PATH_PROG(MOC, moc moc2, /usr/bin/moc,
 $ac_qt_bindir:$QTDIR/bin:$PATH:/usr/bin:/usr/X11R6/bin:/usr/lib/qt/bin:/usr/local/qt/bin)
])


## ------------------------------------------------------------------------
## Try to find the QT headers and libraries.
## $(QT_LDFLAGS) will be -Lqtliblocation (if needed)
## and $(QT_INCLUDES) will be -Iqthdrlocation (if needed)
## ------------------------------------------------------------------------
##
AC_DEFUN(AC_PATH_QT_2,
[
AC_MSG_CHECKING([for QT 2.x])
ac_qt_includes=NO ac_qt_libraries=NO
qt_libraries=""
qt_includes=""
AC_ARG_WITH(qt-dir,
    [  --with-qt-dir           where the root of qt is installed ],
    [  ac_qt_includes="$withval"/include
       ac_qt_libraries="$withval"/lib
    ])

AC_ARG_WITH(qt-includes,
    [  --with-qt-includes      where the qt includes are. ],
    [  
       ac_qt_includes="$withval"
    ])
    
AC_ARG_WITH(qt-libraries,
    [  --with-qt-libraries     where the qt library is installed.],
    [  ac_qt_libraries="$withval"
    ])

if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NO; then

AC_CACHE_VAL(ac_cv_have_qt,
[#try to guess qt locations

qt_incdirs="$ac_qt_includes /usr/lib/qt/include /usr/local/qt/include /usr/include/qt /usr/include/qt2 /usr/include /usr/X11R6/include/X11/qt $x_includes $QTINC"
test -n "$QTDIR" && qt_incdirs="$QTDIR/include $QTDIR $qt_incdirs"
AC_FIND_FILE(qtranslator.h, $qt_incdirs, qt_incdir)
ac_qt_includes=$qt_incdir

qt_libdirs="$ac_qt_libraries /usr/lib/qt/lib /usr/local/qt/lib /usr/lib/qt /usr/lib/qt2 /usr/X11R6/lib /usr/lib $x_libraries $QTLIB"
test -n "$QTDIR" && qt_libdirs="$QTDIR/lib $QTDIR $qt_libdirs"
AC_FIND_FILE(libqt.so.2, $qt_libdirs, qt_libdir)
ac_qt_libraries=$qt_libdir

if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NO; then
  ac_cv_have_qt="have_qt=no"
  ac_qt_notfound=""
  if test "$ac_qt_includes" = NO; then
    if test "$ac_qt_libraries" = NO; then
      ac_qt_notfound="(headers and libraries)";
    else
      ac_qt_notfound="(headers)";
    fi
  else
    ac_qt_notfound="(libraries)";
  fi

  AC_MSG_ERROR([QT-2.x $ac_qt_notfound not found. Please check your installation! ]);
else
  have_qt="yes"
fi
])
else
  have_qt="yes"
fi

eval "$ac_cv_have_qt"

if test "$have_qt" != yes; then
  AC_MSG_RESULT([$have_qt]);
else
  ac_cv_have_qt="have_qt=yes \
    ac_qt_includes=$ac_qt_includes ac_qt_libraries=$ac_qt_libraries"
  AC_MSG_RESULT([libraries $ac_qt_libraries, headers $ac_qt_includes])
  
  qt_libraries=$ac_qt_libraries
  qt_includes=$ac_qt_includes
fi

AC_SUBST(qt_libraries)
AC_SUBST(qt_includes)

if test "$qt_includes" = "$x_includes" || test -z "$qt_includes"; then
 QT_INCLUDES="";
else
 QT_INCLUDES="-I$qt_includes"
 all_includes="$QT_INCLUDES $all_includes"
fi

if test "$qt_libraries" = "$x_libraries" || test -z "$qt_libraries"; then
 QT_LDFLAGS=""
else
 QT_LDFLAGS="-L$qt_libraries"
 all_libraries="$QT_LDFLAGS $all_libraries"
fi

AC_SUBST(QT_INCLUDES)
AC_SUBST(QT_LDFLAGS)
AC_PATH_QT_MOC
])

## ------------------------------------------------------------------------
## Find a file (or one of more files in a list of dirs)
## ------------------------------------------------------------------------
##
AC_DEFUN(AC_FIND_FILE,
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    if test -r "$i/$j"; then
      $3=$i
      break 2
    fi
  done
done
])
