#ifndef _ECS_VEC_REAL_H_
#define _ECS_VEC_REAL_H_

/*============================================================================
 *  Prototypes des fonctions de base
 *   associees a la structure `ecs_vec_real_t' decrivant un vecteur indexe reel
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_real.h"


/*============================================================================
 *                         Declaration de la structure
 *============================================================================*/

typedef struct _ecs_vec_real_t ecs_vec_real_t ;


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction allouant et initialisant une structure `ecs_vec_real_t'
 *----------------------------------------------------------------------------*/

ecs_vec_real_t * ecs_vec_real__cree
(                          /* <-- Pointeur sur une structure `ecs_vec_real_t' */
 void
) ;


/*----------------------------------------------------------------------------
 *  Fonction liberant une structure `ecs_vec_real_t' donnee en argument.
 *  Elle renvoie un pointeur NULL
 *----------------------------------------------------------------------------*/

ecs_vec_real_t * ecs_vec_real__detruit
(
 ecs_vec_real_t * this_vec_real
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui alloue une structure `ecs_vec_real_t' ainsi que ses membres
 *----------------------------------------------------------------------------*/

ecs_vec_real_t * ecs_vec_real__alloue
(                      /* <-- Renvoie la reference a la structure creee       */
 size_t      pos_nbr,  /* --> Nombre de positions pour tableau des positions  */
 size_t      val_nbr   /* --> Nombre de valeurs   pour tableau des valeurs    */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui redimensionne les membres d'une structure `ecs_vec_real_t'
 *----------------------------------------------------------------------------*/

void ecs_vec_real__redimensionne
(
 ecs_vec_real_t  *const this_vec_real ,
 size_t                 pos_nbr,  /* --> Nouvelle dim. du tableau des pos.    */
 size_t                 val_nbr   /* --> Nouvelle dim. du tableau des val. x  */
) ;


/*----------------------------------------------------------------------------
 *  Fonction liberant une structure `ecs_vec_real_t'
 *----------------------------------------------------------------------------*/

ecs_vec_real_t * ecs_vec_real__libere
(                                 /* <-- Renvoie un pointeur NULL             */
 ecs_vec_real_t  *this_vec_real   /* <-> Structure `ecs_vec_real_t' a liberer */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui cree un vecteur `ecs_vec_real_t'
 *   et qui l'initialise avec les references donnees
 *----------------------------------------------------------------------------*/

ecs_vec_real_t * ecs_vec_real__initialise
(
 const ecs_int_t          pos_nbr,
 const ecs_int_t          pos_pas,
       ecs_real_t  *const val_tab
) ;


/*----------------------------------------------------------------------------
 *  Fonction retournant le nombre de positions
 *----------------------------------------------------------------------------*/

size_t ecs_vec_real__ret_pos_nbr
(
 const ecs_vec_real_t *const this_vec_real
) ;


/*----------------------------------------------------------------------------
 *  Fonction retournant le nombre de valeurs associees au tableau des positions
 *----------------------------------------------------------------------------*/

size_t ecs_vec_real__ret_val_nbr
(
 const ecs_vec_real_t *const this_vec_real_pos
) ;


/*----------------------------------------------------------------------------
 *  Fonction retournant le pas des positions
 *----------------------------------------------------------------------------*/

size_t ecs_vec_real__ret_pos_pas
(
 const ecs_vec_real_t *const this_vec_real
) ;


/*----------------------------------------------------------------------------
 *  Fonction retournant la reference du tableau des valeurs
 *----------------------------------------------------------------------------*/

ecs_real_t  * ecs_vec_real__ret_val_tab

(
 const ecs_vec_real_t *const this_vec_real
) ;


#endif /* _ECS_VEC_REAL_H_ */
