/* Copyright (C) 2004 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef SEM_SYNC_H
#define SEM_SYNC_H

#include "prog_defs.h"

#include <semaphore.h>
#include <errno.h>

class Sem_sync {

  bool valid;
  sem_t sem;
public:
  
  bool is_valid(void) const {return valid;}
  int getvalue(void);
  int post(void) {return sem_post(&sem);}
  void wait(void);
  Sem_sync(unsigned int init_count = 0);
  ~Sem_sync(void);
};

inline int Sem_sync::getvalue(void) {
  int count;
  sem_getvalue(&sem, &count);
  return count;
}

inline void Sem_sync::wait(void) {

  while (sem_wait(&sem) == -1 && errno == EINTR);
}

inline Sem_sync::Sem_sync(unsigned int init_count): valid(false) {

  if(sem_init(&sem, 0, init_count) == 0) valid = true;
}

inline Sem_sync::~Sem_sync(void) {

  while (getvalue() < 1) post();
  sem_destroy(&sem);
}

#endif
