/* Copyright (C) 2001 2002 2003 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef SOCKET_LIST_H
#define SOCKET_LIST_H

#include "prog_defs.h"

#include <string>
#include <list>
#include <utility>

#include <gtkmm/window.h>
#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/liststore.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/toolbar.h>
#include <gtkmm/box.h>
#include <glibmm/ustring.h>
#include <glibmm/thread.h>


#if GTKMM_VERSION >= 24
#include <gtkmm/toolbutton.h>
#endif

#include "socket_server.h"
#include "shared_ptr.h"


class SocketListModelColumns: public Gtk::TreeModel::ColumnRecord {
  Gtk::TreeModelColumn<Glib::ustring> fax_label;
  Gtk::TreeModelColumn<std::string> fax_filename;
  // private constructor - only SocketListDialog can create objects of this class
  SocketListModelColumns(void) {add(fax_label); add(fax_filename);}
public:
  friend class SocketListDialog;
};

class SocketListDialog: public Gtk::Window {
  static int is_socket_list;
  const int standard_size;
  Gtk::VBox socket_list_box;
  Gtk::Table table;
  Gtk::Toolbar tool_bar;
  Gtk::ScrolledWindow socket_list_scroll_window;
  Gtk::Button close_button;
  Gtk::HButtonBox button_box;
  SocketListModelColumns model_columns;
  Gtk::TreeView tree_view;
  Glib::RefPtr<Gtk::ListStore> list_store_r;

#if GTKMM_VERSION >= 24
  Gtk::ToolButton* send_button_p;
  Gtk::ToolButton* view_button_p;
  Gtk::ToolButton* remove_button_p;
#else
  Gtk::Button send_button;
  Gtk::Button* view_button_p;
  Gtk::Button* remove_button_p;
#endif

  sigc::signal1<void, const std::string&> send_fax;

  void send_fax_slot(void);
  void set_buttons_slot(void);
  void view_file(void);
  void remove_file_prompt(void);
  void remove_file(void);
  std::pair<const char*, char* const*> get_view_file_parms(const string&);
  void delete_parms(std::pair<const char*, char* const*>);

protected:
  virtual bool on_delete_event(GdkEventAny*);
public:

#if GTKMM_VERSION >= 24
  sigc::signal1<void, const std::pair<Glib::ustring, std::string>& > selected_fax;
  sigc::signal1<void, const std::string&> remove_from_socket_server_filelist;
  sigc::signal0<void> dialog_closed;
#else
  SigC::Signal1<void, const std::pair<Glib::ustring, std::string>& > selected_fax;
  SigC::Signal1<void, const std::string&> remove_from_socket_server_filelist;
  SigC::Signal0<void> dialog_closed;
#endif

  void close_slot(void);

  void set_socket_list_rows(std::pair<Shared_ptr<FilenamesList>, Shared_ptr<Glib::Mutex::Lock> >);
  static int get_is_socket_list(void) {return is_socket_list;}

  SocketListDialog(std::pair<Shared_ptr<FilenamesList>,
		             Shared_ptr<Glib::Mutex::Lock> > filenames_pair,
		   const int standard_size_);
  ~SocketListDialog(void);
};

#endif
