-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Contains routines for returning info from child to parent"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: child.e,v 1.9 2000/09/15 09:45:25 dan Exp $"

deferred class CHILD

inherit
	WRITER
	CAN_BE_CREATED

feature {NONE}

	empty_tree: TAG_TREE is
		once
			!!Result.make("Empty tree")
		end

	find_child is
		do
			if child_tree = Void then
				child_tree := widget_tree.find_child("child")
				if child_tree = Void then
					child_tree := empty_tree
				end
			end
		ensure
			child_tree /= Void
		end
	
feature

	child_tree: TAG_TREE

	property(tag: STRING): STRING is
		do
			find_child
			Result := child_tree.get_string_from_field(tag)
		end

	boolean_property(tag: STRING): STRING is
		do
			find_child
			Result := child_tree.get_boolean_string_from_field(tag)
		end

	flag(tag: STRING; def: BOOLEAN): BOOLEAN is
		do
			find_child
			Result := child_tree.get_boolean_from_field(tag, def)
		end

end
