-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "The tag tree from the XML"
	author: "Daniel Elphick"
	cvs: "$Id"

class TAG_TREE

creation

	make

feature
		
	tag: STRING
	subtree: LINKED_LIST[ANY]
	make(tagname: STRING) is
		require
			valid_tagname: tagname /= Void and then not tagname.is_empty
		do
			!!subtree.make
			tag := tagname
		end
	
	no_children: BOOLEAN is
		do
			Result := subtree.is_empty
		ensure
			Result = subtree.is_empty
		end

	count: INTEGER is
		do
			Result := subtree.count
		ensure
			Result = subtree.count
		end

	get_real_string_from_field(field: STRING): STRING is
		require
			valid_field: field /= Void and then not field.is_empty
		local
			temp_tree: TAG_TREE
		do
			temp_tree := find_child(field)
			if temp_tree = Void then
				Result := Void
			else
				Result ?= temp_tree @ 0
				if Result = Void or else (not Result.is_integer and not Result.is_real) then
					print("field "+field+" must contain a real%N")
					die_with_code(exit_failure_code)
				end
				if Result.is_integer then
				   Result.append(".0")
				end
			end
		ensure
			result_is_string: Result = Void or else Result.is_real
		end

	get_integer_string_from_field(field: STRING): STRING is
		require
			valid_field: field /= Void and then not field.is_empty
		local
			temp_tree: TAG_TREE
		do
			temp_tree := find_child(field)
			if temp_tree = Void then
				Result := Void
			else
				Result ?= temp_tree @ 0
				if Result = Void or else not Result.is_integer then
					print("field "+field+" must contain an integer%N")
					die_with_code(exit_failure_code)
				end
			end
		ensure
			result_is_string: Result = Void or else Result.is_integer
		end
			
	get_string_from_field(field: STRING): STRING is
		require
			valid_field: field /= Void and then not field.is_empty
		local
			temp_tree: TAG_TREE
		do
			temp_tree := find_child(field)
			if temp_tree = Void or else temp_tree.no_children then
				Result := ""
			else
				Result ?= temp_tree @ 0
				if Result = Void then
					print("field "+field+" must contain a string%N")
					die_with_code(exit_failure_code)
				end
			end
		ensure
			result_is_string: Result /= Void
		end

	get_boolean_from_field(field: STRING; deflt: BOOLEAN): BOOLEAN is
		require
			valid_field: field /= Void and then not field.is_empty
		local
			temp: STRING
		do
			temp := get_boolean_string_from_field(field)
			if temp.is_equal("True") then
				Result := True
			elseif temp.is_equal("False") then
				Result := False
			else
				Result := deflt
			end
		end
			
	get_boolean_string_from_field(field: STRING): STRING is
			-- Find the field in the current object and return the value
			-- If it is empty it returns an empty string
		require
			valid_field: field /= Void and then not field.is_empty
		local
			temp_tree: TAG_TREE
		do
			temp_tree := find_child(field)
			if temp_tree = Void or else temp_tree.no_children then
				Result := ""
			else
				Result ?= temp_tree @ 0
				if Result = Void then
					print("field "+field+" does not contain a string%N")
					die_with_code(exit_failure_code)
				elseif not (result.is_equal("True") or else result.is_equal("False")) then
					print("field "+field+" must contain True or False%N")
					die_with_code(exit_failure_code)
				end
				
			end
		ensure
			result_is_string: Result /= Void
		end
			
	
	infix "@" (index: INTEGER): ANY is
		require
			not_empty_subtree: not no_children
		do
			Result := subtree @ (subtree.lower + index)
		end

	find_children(tag_to_find: STRING): ARRAY[TAG_TREE] is
			-- Like find_child except it returns an array of all the TAG_TREEs
			-- with the tag, tag_to_find
		require
			valid_tag: tag_to_find /= Void and then not tag_to_find.is_empty
		local
			i, j: INTEGER
			temptree: TAG_TREE
		do
			!!Result.make(0,0)
			from
				i := subtree.lower
				j := 0
			variant
				subtree.upper - subtree.lower + 1 - i
			until
				i > subtree.upper
			loop
				temptree ?= subtree @ i
				if temptree /= Void and then temptree.tag.is_equal(tag_to_find) then
					Result.force(temptree,j)
					j := j + 1
				end
				i := i + 1
			end
			if j = 0 then
				Result := Void
			end
		end

	find_child(tag_to_find: STRING): TAG_TREE is
			-- Search this node's children for a tag name
			-- This is not recursive.
			-- Returns Void if it can't find it.
		require
			valid_tag: tag_to_find /= Void and then not tag_to_find.is_empty
		local
			i: INTEGER
			temptree: TAG_TREE
		do
			from
				i := subtree.lower
			variant
				subtree.upper - subtree.lower + 1 - i
			until
				Result /= Void or else i > subtree.upper
			loop
				temptree ?= subtree @ i
				if temptree /= Void and then temptree.tag.is_equal(tag_to_find) then
					Result := temptree
				end
				i := i + 1
			end
		end

	add_child(newtree: ANY) is
		require
			non_void_child: newtree /= Void
		do
			subtree.add_last(newtree)
		ensure
			count_increased: count = old count + 1
		end

	add_children(list: LINKED_LIST[ANY]) is
		require
			valid_list: list /= Void
		local
			i: INTEGER
		do
			from
				i := list.lower
			variant
				list.upper - list.lower + 1 - i
			until
				i > list.upper
			loop
				add_child(list.item(i))
				i := i + 1
			end
		ensure
			count_increased: count = old count + (list.upper - list.lower + 1)
		end

end
