-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkCheckButton objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_check_button_writer.e,v 1.8 2000/07/10 11:31:11 elphick Exp $"

class GTK_CHECK_BUTTON_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_CHECK_BUTTON"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			label := widget_tree.get_string_from_field("label")
			active := widget_tree.get_boolean_from_field("active", False)
			draw_indicator := widget_tree.get_boolean_string_from_field("draw_indicator")
			if draw_indicator = "" then
				draw_indicator := "True"
			end
		end
			
	label: STRING
	active: BOOLEAN
	draw_indicator: STRING

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make_with_label(%""+label+"%")")
			if active then
				code.add_last(name + ".set_state_down")
			else
				code.add_last(name + ".set_state_up")
			end
			-- How to implement draw_indicator?
			add_widget_code(code)
		end
end
