/* C routines for the Eiffel-Gnome interface, egnome */

/* Author: Oliver Elphick
	Date:   31st August, 2000
	CVS: $Id: eiffel_gnome.c,v 1.1 2000/09/05 05:49:20 elphick Exp $
*/

#include <gnome.h>
#include <signal.h>

static gchar answer[1025];

gchar*
c_gnome_help_file_find_file (gchar *name, gchar *path)
{
  gchar* tmp;

  tmp = gnome_help_file_find_file (name, path);
  strncpy(answer, tmp, 1024);
  g_free(tmp);
}

gchar*
c_gnome_help_file_path (gchar *name, gchar *path)
{
  gchar* tmp;

  tmp = gnome_help_file_path (name, path);
  strncpy(answer, tmp, 1024);
  g_free(tmp);
}

void
c_gnome_help_display (gchar *name, gchar *path)
{
  GnomeHelpMenuEntry ghme;
  void *ignore;

  ghme.name = name;
  ghme.path = path;

  gnome_help_display(ignore, &ghme);
}

void
c_gnome_help_pbox_display (gint page_num, gchar *name, gchar *path)
{
  GnomeHelpMenuEntry ghme;
  void *ignore;

  ghme.name = name;
  ghme.path = path;

  gnome_help_pbox_display (ignore, page_num, &ghme);
}

void
c_gnome_help_pbox_goto (gchar *name, gchar *path)
{
  GnomeHelpMenuEntry ghme;
  void *ignore;
  int ignore2;

  ghme.name = name;
  ghme.path = path;

  gnome_help_pbox_goto (ignore, ignore2, &ghme);
}

void
c_ignore_sig_child()
{
  signal(SIGCHLD, SIG_IGN);
}
