<?php
/**
 * eGroupWare - Addressbook - importexport
 *
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package addressbook
 * @subpackage importexport
 * @link http://www.egroupware.org
 * @author Cornelius Weiss <nelius@cwtech.de>
 * @copyright Cornelius Weiss <nelius@cwtech.de>
 * @version $Id: class.egw_addressbook_record.inc.php 22827 2006-11-10 15:35:35Z nelius_weiss $
 */

require_once(EGW_INCLUDE_ROOT. '/importexport/inc/class.iface_egw_record.inc.php');
require_once(EGW_INCLUDE_ROOT. '/addressbook/inc/class.bocontacts.inc.php');

/**
 * class egw_addressbook_record
 * compability layer for iface_egw_record needet for importexport
 */
class egw_addressbook_record implements iface_egw_record  
{

	private $identifier = '';
	private $contact = array();
	private $bocontacts;
	
	
	
	/**
	 * constructor
	 * reads record from backend if identifier is given.
	 *
	 * @param string $_identifier
	 */
	public function __construct( $_identifier='' ){
		$this->identifier = $_identifier;
		$this->bocontacts = new bocontacts();
		$this->contact = $this->bocontacts->read($this->identifier);
	}
	
	/**
	 * magic method to set attributes of record
	 *
	 * @param string $_attribute_name
	 */
	public function __get($_attribute_name) {
		
	}
	
	/**
	 * magig method to set attributes of record
	 *
	 * @param string $_attribute_name
	 * @param data $data
	 */
	public function __set($_attribute_name, $data) {
		
	}
	
	/**
	 * converts this object to array. 
	 * @abstract We need such a function cause PHP5
	 * dosn't allow objects do define it's own casts :-(
	 * once PHP can deal with object casts we will change to them!
	 *
	 * @return array complete record as associative array
	 */
	public function get_record_array() {
		return $this->contact;
	}
	
	/**
	 * gets title of record
	 * 
	 *@return string tiltle
	 */
	public function get_title() {
		if (empty($this->contact)) {
			$this->get_record();
		}
		return $this->contact['fn'];
	}
	
	/**
	 * sets complete record from associative array
	 *
	 * @todo add some checks
	 * @return void
	 */
	public function set_record(array $_record){
		$this->contact = $_record;
	}
	
	/**
	 * gets identifier of this record
	 *
	 * @return string identifier of current record
	 */
	public function get_identifier() {
		return $this->identifier;
	}
	
	/**
	 * saves record into backend
	 * 
	 * @return string identifier
	 */
	public function save ( $_dst_identifier ) {
		
	}
	
	/**
	 * copys current record to record identified by $_dst_identifier
	 *
	 * @param string $_dst_identifier
	 * @return string dst_identifier
	 */
	public function copy ( $_dst_identifier ) {
		
	}
	
	/**
	 * moves current record to record identified by $_dst_identifier
	 * $this will become moved record
	 *
	 * @param string $_dst_identifier
	 * @return string dst_identifier
	 */
	public function move ( $_dst_identifier ) {
		
	}
	
	/**
	 * delets current record from backend
	 * 
	 */
	public function delete () {
		
	}
	
	/**
	 * destructor
	 *
	 */
	public function __destruct() {
		unset ($this->bocontacts);
	}

} // end of egw_addressbook_record
?>
