/* $Id: log.h 2590 2005-12-05 20:20:10Z wojtekka $ */

/*
 *  (C) Copyright 2001-2003 Wojtek Kaniewski <wojtekka@irc.pl>
 *                          Robert J. Wony <speedy@ziew.org>
 *                          Pawe Maziarz <drg@o2.pl>
 *                          Dawid Jarosz <dawjar@poczta.onet.pl>
 *                          Piotr Domagalski <szalik@szalik.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LOG_H
#define __LOG_H

#include <sys/types.h>
#include <time.h>

#include "dynstuff.h"
#include "libgadu.h"

struct last {
	int type;		/* 0 - przychodzca, 1 - wychodzca */
	uin_t uin;		/* od kogo, lub do kogo przy wysyanych */
	time_t time;		/* czas */
	time_t sent_time;	/* czas wysania wiadomoci przychodzcej */
	unsigned char *message;	/* wiadomo */
};

list_t lasts;

void last_add(int type, uin_t uin, time_t t, time_t st, const char *msg);
void last_del(uin_t uin);
int last_count(uin_t uin);
void last_free(void);

void put_log(uin_t uin, const char *format, ...);
const char *log_timestamp(time_t t);

#endif /* __LOG_H */
