# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

# We are a Group
from pgm.graph.group import Group

# for fade-in and fade-out
from pgm.timing import implicit

# for automatic time based fade out
from twisted.internet import reactor

"""
An OSD Widget for Pigment Views
"""


class OSD(Group):
    """
    A simple OSD, that does fade-in and -out on visibility changes. To show it
    only for a certain time and let it automatically fade it out afterwards,
    it has the method L{show}.
    """

    def __init__(self):
        super(OSD, self).__init__()

        self._show = None

        self._animated_group = implicit.AnimatedObject(self)
        self._animated_group.mode = implicit.REPLACE
        self._animated_group.setup_next_animations(duration = 500,
                                                   transformation = implicit.DECELERATE)
        self.visible = False

    def show(self, time_to_show=-1):
        """
        Show the player dock for the next seconds
        @time_to_show: duration before the dock disappears (in seconds)
                       if set to -1 the dock will not disappear
        """
        self.visible = True

        if time_to_show > 0:
            if self._show != None and self._show.active():
                self._show.reset(time_to_show)
            else:
                self._show = reactor.callLater(time_to_show, self.hide)

    def _cancel_timer(self):
        if self._show != None and self._show.active():
            self._show.cancel()

    def hide(self):
        """
        Hide the dock
        """
        self._cancel_timer()
        self.visible = False

    # overwritten
    def visible__set(self, value):
        if value == self.visible:
            # no change, do nothing
            return

        if value:
            # we need to show it ;)
            self._animated_group.opacity = 255
            super(OSD, self).visible__set(True)
        else:
            self._animated_group.opacity = 0


    def visible__get(self):
        return self._animated_group.opacity > 0
