# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'

"""
Module loaded before Elisa
used to set the windows version evironement
"""

import sys, platform, os

if platform.system() == 'Windows':
    
    relative_library_paths = [
                    'python\\Dlls',
                    'gtk-deps',
                    'glib\\glib-2.14.2\\bin',
                    'gtk\\gtk+-2.12.1\\bin',
                    'gstreamer\\0.10\\bin',
                    'gstreamer\\0.10\\lib\\gstreamer-0.10',
                    'gstreamer\\0.10\\deps',
                    'pigment\\pigment-0.3.4.1',
                    'temp'
                     ]
    
    relative_python_paths = [
                    'python\\Lib\\site-packages\\setuptools-0.6c7-py2.5.egg',
                    'python\\Dlls',
                    'python\\Lib',
                    'python\\Lib\\site-packages',
                    'python\\Lib\\site-packages\\PIL',
                    'python\\Lib\\site-packages\\gtk-2.0',
                    'python\\Lib\\site-packages\\zope',
                    'python\\Lib\\site-packages\\win32',
                    'python\\Lib\\site-packages\\win32\\lib',
                    'gstreamer\\0.10\\site-packages',
                    'gstreamer\\0.10\\site-packages\\gst-0.10',
                    'pigment\\pigment-python-0.3.2.1',
                    'temp',
                    ''
                     ]


    def get_prefix():    
        if sys.argv[0].endswith('elisa.exe'):
            return sys.prefix
            
        if os.environ.has_key('ELISA_DEPS'):
            return os.environ['ELISA_DEPS']
        
        return sys.prefix
     
    def add_python_path(path):
        sys.path.insert(0,path)
        
    
    def add_env(key, new_value, env_file=None):
        if os.environ.has_key(key):
            value = os.environ[key]
            os.environ[key] = "%s;%s" % (new_value, value)
        else:
            os.environ[key] = new_value
            
        if env_file != None:
            t = "SET %s=%s;%%%s%%\r\n" % (key, new_value, key)
            env_file.write(t)
        
        
    def add_library_paths(env_file):
        #add relavite path to the system path
        new_value = ''
        prefix = get_prefix()
        for path in relative_library_paths:
            lib_path = "%s\\%s" % (prefix, path)
            add_env('PATH', lib_path, None)
            new_value = "%s;%s" % (new_value, lib_path)
        
        if env_file != None:
            key = 'PATH'
            t = "SET %s=%s;%%%s%%\r\n" % (key, new_value, key)
            env_file.write(t)
            
    def add_python_paths(env_file):
        new_value = ''
        prefix = get_prefix()
        #add relavite path to the system path
        for path in relative_python_paths:
            lib_path = "%s\\%s" % (prefix, path)
            add_python_path(lib_path)
            new_value = "%s;%s" % (new_value, lib_path)
        
        if env_file != None:
            key = 'PYTHONPATH'
            t = "SET %s=%s;%%%s%%\r\n" % (key, new_value, key)
            env_file.write(t)
            
    def install_core():
        contents = []
        #Find eggs core in the userdir
        user_core_dir = os.path.join(os.path.expanduser('~'), '.elisa', 'core')
        if os.path.exists(user_core_dir):
            contents = os.listdir(user_core_dir)
            contents.sort()
        
        #If no core installed in userdir, looking for a system wide
        if len(contents) == 0:
            core_dir = "%s\\core" % (get_prefix())
            if os.path.exists(core_dir):
                contents = os.listdir(core_dir)
                contents.sort()
                
        if len(contents) > 0:
            for egg in contents:
                if egg[-3:] == 'egg':
                    egg_path = "%s\\%s" % (core_dir, egg)
                    add_python_path(egg_path)
        else:
            print "no core found in %s and %s" % (user_core_dir, core_dir)
            sys.exit()
            
    def import_module(mod):
        #remove the path if included
        p = get_prefix()
        if mod[0:len(p)] == p:
            mod = mod[len(p)+1:]

        #find if there is a egg file to import
        p = mod.find('.egg\\')
        if p >= 0:
            egg_file = mod[0:p+4]
            add_python_path(egg_file)
            import_file = mod[p+5:]
        else:
            import_file = mod
        #remplace \\ by . and remove .py extention
        import_line = import_file[0:-3].replace('\\', '.')
        mod = __import__(import_line)
            
    def show_path():
        for p in sys.path:
            print p
            
    
    env_file = None    
    try:
        filepath = os.path.join(os.path.abspath(os.curdir), 'set_env.bat')
        env_file = open(filepath, 'w')
    except:
        print "Can't write set_env.bat file"
    
    #set the Gstreamer plugin path
    prefix = get_prefix()
    add_env('GST_PLUGIN_PATH', "%s\\%s" % (prefix, 'gstreamer\\0.10\\lib\\gstreamer-0.10'), env_file) 
    add_env('PGM_PLUGIN_PATH', "%s\\%s" % (prefix, 'pigment\\pigment-0.3.4.1\\pigment-0.3\\0.3.4.1'), env_file)
    add_env('ELISA_PLUGIN_PATH', "%s\\%s" % (prefix, 'plugins'), env_file)
    
    add_library_paths(env_file)
    add_python_paths(env_file)
    
    if sys.argv[0].endswith('elisa.exe'):
        install_core()
        from elisa.core.application import Option
        options = Options()
        try:
            options.parseOptions(args[1:])
            if options['import']:
                import_module(options['import'])
        except:
            pass

        #add_env('ELISA_DEBUG', "*:5")
        #FIXME : does not work under windows !!!
        #sys.argv.append('-l')
    
    if env_file != None:
        env_file.close()
    
    if 'interactive' in sys.argv[1:]:
        print "enter in interactive mode"
        import pdb
        pdb.set_trace()
        sys.exit()

        
